/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class FeatureBuilder {
    private final String type;
    private final List<String> biomes = Lists.newArrayList();
    private final List<String> features = Lists.newArrayList();
    private final String step;

    public FeatureBuilder(String type, String step) {
        this.type = type;
        this.step = step;
    }

    public FeatureBuilder feature(String singleFeature) {
        this.features.add(singleFeature);
        return this;
    }

    public FeatureBuilder features(List<String> multipleFeatures) {
        this.features.addAll(multipleFeatures);
        return this;
    }

    public FeatureBuilder biome(String singleBiome) {
        this.biomes.add(singleBiome);
        return this;
    }

    public FeatureBuilder biomes(List<String> multipleBiomes) {
        this.biomes.addAll(multipleBiomes);
        return this;
    }

    public void save(Consumer<IFinishedGenericJSON> consumer, ResourceLocation jsonResourceLocation) {
        consumer.accept(new Result(jsonResourceLocation, this.type, this.biomes, this.features, this.step));
    }

    public class Result
    implements IFinishedGenericJSON {
        private final ResourceLocation id;
        private final String type;
        private final List<String> biomes;
        private final List<String> features;
        private final String step;

        public Result(ResourceLocation id, String type, List<String> biomes, List<String> features, String step) {
            this.id = id;
            this.type = type;
            this.biomes = biomes;
            this.features = features;
            this.step = step;
        }

        @Override
        public void serializeJSONData(JsonObject recipeJson) {
            JsonArray jsonarray;
            if (!this.type.isEmpty()) {
                recipeJson.addProperty("type", this.type);
            }
            if (this.features.size() > 1) {
                jsonarray = new JsonArray();
                for (String s : this.features) {
                    jsonarray.add(s);
                }
                recipeJson.add("features", (JsonElement)jsonarray);
            }
            if (this.features.size() == 1) {
                recipeJson.addProperty("features", this.features.get(0));
            }
            if (this.biomes.size() > 1) {
                jsonarray = new JsonArray();
                for (String b : this.biomes) {
                    jsonarray.add(b);
                }
                recipeJson.add("biomes", (JsonElement)jsonarray);
            }
            if (this.biomes.size() == 1) {
                recipeJson.addProperty("biomes", this.biomes.get(0));
            }
            if (!this.step.isEmpty()) {
                recipeJson.addProperty("step", this.step);
            }
        }

        public String getType() {
            return this.type;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

