/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericRecipe;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class EERecipeProvider
implements DataProvider {
    protected final DataGenerator generator;

    public EERecipeProvider(DataGenerator gen) {
        this.generator = gen;
    }

    public void m_213708_(CachedOutput directoryCache) throws IOException {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        this.buildRecipes(consumer -> {
            if (!set.add(consumer.getId())) {
                throw new IllegalStateException("Duplicate recipe " + consumer.getId());
            }
            try {
                EERecipeProvider.saveRecipe(directoryCache, consumer.serializeRecipe(), path.resolve("data/" + consumer.getId().m_135827_() + "/recipes/" + consumer.getId().m_135815_() + ".json"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        if (this.getClass() == EERecipeProvider.class) {
            this.saveAdvancement(directoryCache, Advancement.Builder.m_138353_().m_138386_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138400_(), path.resolve("data/minecraft/advancements/recipes/root.json"));
        }
    }

    private static void saveRecipe(CachedOutput directoryCache, JsonObject recipeJson, Path recipePath) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8);
        JsonWriter jsonwriter = new JsonWriter((Writer)writer);
        jsonwriter.setSerializeNulls(false);
        jsonwriter.setIndent("  ");
        GsonHelper.m_216207_((JsonWriter)jsonwriter, (JsonElement)recipeJson, (Comparator)f_236068_);
        jsonwriter.close();
        directoryCache.m_213871_(recipePath, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
    }

    protected void saveAdvancement(CachedOutput directoryCache, JsonObject recipeJson, Path recipePath) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8);
        JsonWriter jsonwriter = new JsonWriter((Writer)writer);
        jsonwriter.setSerializeNulls(false);
        jsonwriter.setIndent("  ");
        GsonHelper.m_216207_((JsonWriter)jsonwriter, (JsonElement)recipeJson, (Comparator)f_236068_);
        jsonwriter.close();
        directoryCache.m_213871_(recipePath, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
    }

    protected static EnterBlockTrigger.TriggerInstance insideOf(Block block) {
        return new EnterBlockTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, block, StatePropertiesPredicate.f_67658_);
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike item) {
        return EERecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> tag) {
        return EERecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... itemPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, itemPredicates);
    }

    protected void buildRecipes(Consumer<IFinishedGenericRecipe> consumer) {
    }

    public String m_6055_() {
        return null;
    }
}

