/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class BlockStateBuilder {
    private final Map<String, VariantBuilder> variants = Maps.newLinkedHashMap();

    public BlockStateBuilder variant(VariantBuilder builder) {
        this.variants.put(builder.getFaceName(), builder);
        return this;
    }

    public void save(Consumer<IFinishedGenericJSON> consumer, ResourceLocation resourceLocation) {
        consumer.accept(new Result(resourceLocation, this.variants));
    }

    public static class VariantBuilder {
        private final String faceName;
        private String model;
        private int x = -1;
        private int y = -1;

        public VariantBuilder(String faceName) {
            this.faceName = faceName;
        }

        public String getFaceName() {
            return this.faceName;
        }

        public VariantBuilder setModel(String model) {
            this.model = model;
            return this;
        }

        public VariantBuilder setX(int x) {
            this.x = x;
            return this;
        }

        public VariantBuilder setY(int y) {
            this.y = y;
            return this;
        }

        JsonObject toJson() {
            JsonObject ret = new JsonObject();
            ret.addProperty("model", this.model);
            if (this.x != -1) {
                ret.addProperty("x", (Number)this.x);
            }
            if (this.y != -1) {
                ret.addProperty("y", (Number)this.y);
            }
            return ret;
        }
    }

    public class Result
    implements IFinishedGenericJSON {
        private final ResourceLocation id;
        private final Map<String, VariantBuilder> variants;

        public Result(ResourceLocation id, Map<String, VariantBuilder> variants) {
            this.id = id;
            this.variants = variants;
        }

        @Override
        public void serializeJSONData(JsonObject json) {
            if (!this.variants.isEmpty()) {
                JsonObject variantsJson = new JsonObject();
                for (Map.Entry<String, VariantBuilder> s : this.variants.entrySet()) {
                    variantsJson.add(s.getKey(), (JsonElement)s.getValue().toJson());
                }
                json.add("variants", (JsonElement)variantsJson);
            }
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

