/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BlockModelBuilder {
    protected final String parent;
    protected final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();
    protected final Map<String, String> textures = new LinkedHashMap<String, String>();
    private final Map<String, BlockModelBuilder> childModels = new LinkedHashMap<String, BlockModelBuilder>();
    private final List<String> itemRenderOrder = new ArrayList<String>();
    protected String customLoader = null;
    protected String renderType = null;
    protected ResourceLocation location;

    public BlockModelBuilder(String parent) {
        this.parent = parent;
    }

    public BlockModelBuilder setLoader(String loader) {
        this.customLoader = loader;
        return this;
    }

    public BlockModelBuilder texture(String key, String texture) {
        if (texture.charAt(0) == '#') {
            this.textures.put(key, texture);
            return this.self();
        }
        ResourceLocation asLoc = texture.contains(":") ? new ResourceLocation(texture) : new ResourceLocation(this.getLocation().m_135827_(), texture);
        return this.texture(key, asLoc);
    }

    public BlockModelBuilder texture(String key, ResourceLocation texture) {
        this.textures.put(key, texture.toString());
        return this.self();
    }

    public BlockModelBuilder renderType(String renderType) {
        return this.renderType(new ResourceLocation(renderType));
    }

    public BlockModelBuilder renderType(ResourceLocation renderType) {
        this.renderType = renderType.toString();
        return this.self();
    }

    public ElementBuilder element() {
        ElementBuilder ret = new ElementBuilder();
        this.elements.add(ret);
        return ret;
    }

    private String serializeLocOrKey(String tex) {
        if (tex.charAt(0) == '#') {
            return tex;
        }
        return new ResourceLocation(tex).toString();
    }

    private JsonArray serializeVector3f(Vector3f vec) {
        JsonArray ret = new JsonArray();
        ret.add(this.serializeFloat(vec.m_122239_()));
        ret.add(this.serializeFloat(vec.m_122260_()));
        ret.add(this.serializeFloat(vec.m_122269_()));
        return ret;
    }

    private Number serializeFloat(float f) {
        if ((float)((int)f) == f) {
            return (int)f;
        }
        return Float.valueOf(f);
    }

    public void save(Consumer<IFinishedGenericJSON> consumer, ResourceLocation jsonResourceLocation) {
        consumer.accept(new Result(jsonResourceLocation, this.parent, this.customLoader, this.elements, this.textures, this.renderType, this.childModels, this.itemRenderOrder));
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    private BlockModelBuilder self() {
        return this;
    }

    public BlockModelBuilder child(String name, BlockModelBuilder modelBuilder) {
        this.childModels.put(name, modelBuilder);
        this.itemRenderOrder.add(name);
        return this;
    }

    public BlockModelBuilder itemRenderOrder(String ... names) {
        for (String name : names) {
            if (this.childModels.containsKey(name)) continue;
            throw new IllegalArgumentException("names contains \"" + name + "\", which is not a child of this model");
        }
        this.itemRenderOrder.clear();
        this.itemRenderOrder.addAll(Arrays.asList(names));
        return this;
    }

    public JsonObject toJson(JsonObject baseJson) {
        baseJson.addProperty("parent", this.parent);
        if (this.renderType != null) {
            baseJson.addProperty("render_type", this.renderType);
        }
        if (this.customLoader != null) {
            baseJson.addProperty("loader", this.customLoader);
        }
        if (!this.textures.isEmpty()) {
            JsonObject textures = new JsonObject();
            for (Map.Entry<String, String> e : this.textures.entrySet()) {
                textures.addProperty(e.getKey(), this.serializeLocOrKey(e.getValue()));
            }
            baseJson.add("textures", (JsonElement)textures);
        }
        if (!this.elements.isEmpty()) {
            JsonArray elements = new JsonArray();
            this.elements.stream().map(ElementBuilder::build).forEach(part -> {
                JsonObject partObj = new JsonObject();
                partObj.add("from", (JsonElement)this.serializeVector3f(part.from));
                partObj.add("to", (JsonElement)this.serializeVector3f(part.to));
                JsonObject faces = new JsonObject();
                for (Direction dir : Direction.values()) {
                    ElementBuilder.BlockElementFace face = part.faces.get(dir);
                    if (face == null) continue;
                    JsonObject faceObj = new JsonObject();
                    faceObj.addProperty("texture", this.serializeLocOrKey(face.texture));
                    if (!Arrays.equals(face.uv.uvs, part.uvsByFace(dir))) {
                        faceObj.add("uv", new Gson().toJsonTree((Object)face.uv.uvs));
                    }
                    if (face.cullForDirection != null) {
                        faceObj.addProperty("cullface", face.cullForDirection.m_7912_());
                    }
                    if (face.uv.rotation != 0) {
                        faceObj.addProperty("rotation", (Number)face.uv.rotation);
                    }
                    if (face.tintIndex != -1) {
                        faceObj.addProperty("tintindex", (Number)face.tintIndex);
                    }
                    if (face.emissivity > 0) {
                        faceObj.addProperty("emissivity", (Number)face.emissivity);
                    }
                    if (!face.hasAmbientOcclusion) {
                        faceObj.addProperty("ambientocclusion", Boolean.valueOf(face.hasAmbientOcclusion));
                    }
                    faces.add(dir.m_7912_(), (JsonElement)faceObj);
                }
                if (!part.faces.isEmpty()) {
                    partObj.add("faces", (JsonElement)faces);
                }
                elements.add((JsonElement)partObj);
            });
            baseJson.add("elements", (JsonElement)elements);
        }
        return baseJson;
    }

    public JsonObject childJson(JsonObject json) {
        JsonObject children = new JsonObject();
        for (Map.Entry<String, BlockModelBuilder> entry : this.childModels.entrySet()) {
            children.add(entry.getKey(), (JsonElement)entry.getValue().toJson(new JsonObject()));
        }
        json.add("children", (JsonElement)children);
        JsonArray itemRenderOrder = new JsonArray();
        for (String name : this.itemRenderOrder) {
            itemRenderOrder.add(name);
        }
        json.add("item_render_order", (JsonElement)itemRenderOrder);
        return json;
    }

    public class ElementBuilder {
        private Vector3f from = new Vector3f();
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private final Map<Direction, FaceBuilder> faces = new LinkedHashMap<Direction, FaceBuilder>();

        public ElementBuilder from(float x, float y, float z) {
            this.from = new Vector3f(x, y, z);
            return this;
        }

        public ElementBuilder to(float x, float y, float z) {
            this.to = new Vector3f(x, y, z);
            return this;
        }

        public FaceBuilder face(Direction dir) {
            Preconditions.checkNotNull((Object)dir, (Object)"Direction must not be null");
            return this.faces.computeIfAbsent(dir, x$0 -> new FaceBuilder((Direction)x$0));
        }

        public ElementBuilder allFaces(BiConsumer<Direction, FaceBuilder> action) {
            Arrays.stream(Direction.values()).forEach(d -> action.accept((Direction)d, this.face((Direction)d)));
            return this;
        }

        public ElementBuilder faces(BiConsumer<Direction, FaceBuilder> action) {
            this.faces.entrySet().stream().forEach(e -> action.accept((Direction)e.getKey(), (FaceBuilder)e.getValue()));
            return this;
        }

        public ElementBuilder texture(String texture) {
            return this.faces(this.addTexture(texture));
        }

        public ElementBuilder cube(String texture) {
            return this.allFaces(this.addTexture(texture).andThen((dir, f) -> f.cullface((Direction)dir)));
        }

        public ElementBuilder cross(String texture) {
            return this.faces(this.addTexture(texture).andThen((dir, f) -> f.cullface((Direction)dir)));
        }

        private BiConsumer<Direction, FaceBuilder> addTexture(String texture) {
            return ($, f) -> f.texture(texture);
        }

        BlockElement build() {
            Map faces = this.faces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FaceBuilder)e.getValue()).build(), (k1, k2) -> {
                throw new IllegalArgumentException();
            }, LinkedHashMap::new));
            return new BlockElement(this.from, this.to, faces, null, true);
        }

        public BlockModelBuilder end() {
            return BlockModelBuilder.this.self();
        }

        public class FaceBuilder {
            private Direction cullface;
            private int tintindex = -1;
            private String texture;
            private float[] uvs;
            private FaceRotation rotation = FaceRotation.ZERO;
            private int emissivity = 0;
            private boolean hasAmbientOcclusion = true;

            FaceBuilder(Direction dir) {
            }

            public FaceBuilder cullface(@Nullable Direction dir) {
                this.cullface = dir;
                return this;
            }

            public FaceBuilder tintindex(int index) {
                this.tintindex = index;
                return this;
            }

            public FaceBuilder texture(String texture) {
                Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
                this.texture = texture;
                return this;
            }

            public FaceBuilder uvs(float u1, float v1, float u2, float v2) {
                this.uvs = new float[]{u1, v1, u2, v2};
                return this;
            }

            public FaceBuilder rotation(FaceRotation rot) {
                Preconditions.checkNotNull((Object)((Object)rot), (Object)"Rotation must not be null");
                this.rotation = rot;
                return this;
            }

            public FaceBuilder emissivity(int emissivity) {
                this.emissivity = emissivity;
                return this;
            }

            public FaceBuilder emissive() {
                return this.emissivity(15);
            }

            public FaceBuilder ao(boolean ao) {
                this.hasAmbientOcclusion = ao;
                return this;
            }

            BlockElementFace build() {
                if (this.texture == null) {
                    throw new IllegalStateException("A model face must have a texture");
                }
                return new BlockElementFace(this.cullface, this.tintindex, this.texture, new BlockFaceUV(this.uvs, this.rotation.rotation), this.emissivity, this.hasAmbientOcclusion);
            }

            public ElementBuilder end() {
                return ElementBuilder.this;
            }
        }

        public class BlockElement {
            private static final boolean DEFAULT_RESCALE = false;
            private static final float MIN_EXTENT = -16.0f;
            private static final float MAX_EXTENT = 32.0f;
            public final Vector3f from;
            public final Vector3f to;
            public final Map<Direction, BlockElementFace> faces;
            public final BlockElementRotation rotation;
            public final boolean shade;

            public BlockElement(Vector3f from, Vector3f to, @Nullable Map<Direction, BlockElementFace> faces, BlockElementRotation rotation, boolean shade) {
                this.from = from;
                this.to = to;
                this.faces = faces;
                this.rotation = rotation;
                this.shade = shade;
                this.fillUvs();
            }

            private void fillUvs() {
                for (Map.Entry<Direction, BlockElementFace> entry : this.faces.entrySet()) {
                    float[] afloat = this.uvsByFace(entry.getKey());
                    entry.getValue().uv.setMissingUv(afloat);
                }
            }

            public float[] uvsByFace(Direction direction) {
                switch (direction) {
                    case DOWN: {
                        return new float[]{this.from.m_122239_(), 16.0f - this.to.m_122269_(), this.to.m_122239_(), 16.0f - this.from.m_122269_()};
                    }
                    case UP: {
                        return new float[]{this.from.m_122239_(), this.from.m_122269_(), this.to.m_122239_(), this.to.m_122269_()};
                    }
                    default: {
                        return new float[]{16.0f - this.to.m_122239_(), 16.0f - this.to.m_122260_(), 16.0f - this.from.m_122239_(), 16.0f - this.from.m_122260_()};
                    }
                    case SOUTH: {
                        return new float[]{this.from.m_122239_(), 16.0f - this.to.m_122260_(), this.to.m_122239_(), 16.0f - this.from.m_122260_()};
                    }
                    case WEST: {
                        return new float[]{this.from.m_122269_(), 16.0f - this.to.m_122260_(), this.to.m_122269_(), 16.0f - this.from.m_122260_()};
                    }
                    case EAST: 
                }
                return new float[]{16.0f - this.to.m_122269_(), 16.0f - this.to.m_122260_(), 16.0f - this.from.m_122269_(), 16.0f - this.from.m_122260_()};
            }
        }

        public class BlockElementRotation {
            public final Vector3f origin;
            public final Direction.Axis axis;
            public final float angle;
            public final boolean rescale;

            public BlockElementRotation(Vector3f vector3f, Direction.Axis axis, float angle, boolean rescale) {
                this.origin = vector3f;
                this.axis = axis;
                this.angle = angle;
                this.rescale = rescale;
            }
        }

        public class BlockElementFace {
            public static final int NO_TINT = -1;
            public final Direction cullForDirection;
            public final int tintIndex;
            public final String texture;
            public final BlockFaceUV uv;
            public final int emissivity;
            public final boolean hasAmbientOcclusion;

            public BlockElementFace(Direction direction, int tint, String texture, BlockFaceUV uv, int emissivity, boolean hasAmbientOcclusion) {
                this.cullForDirection = direction;
                this.tintIndex = tint;
                this.texture = texture;
                this.uv = uv;
                this.emissivity = emissivity;
                this.hasAmbientOcclusion = hasAmbientOcclusion;
            }
        }

        public class BlockFaceUV {
            public float[] uvs;
            public final int rotation;

            public BlockFaceUV(float[] uvs, int rotation) {
                this.uvs = uvs;
                this.rotation = rotation;
            }

            public void setMissingUv(float[] uvs) {
                if (this.uvs == null) {
                    this.uvs = uvs;
                }
            }
        }
    }

    public class Result
    implements IFinishedGenericJSON {
        private final ResourceLocation id;
        private final String parent;
        private final String customLoader;
        private final List<ElementBuilder> elements;
        private final Map<String, String> textures;
        private final Map<String, BlockModelBuilder> childModels;
        private final List<String> itemRenderOrder;
        protected String renderType;

        public Result(ResourceLocation id, @Nullable String parent, String customLoader, List<ElementBuilder> elements, @Nullable Map<String, String> textures, @Nullable String renderType, @Nullable Map<String, BlockModelBuilder> childModels, List<String> itemRenderOrder) {
            this.id = id;
            this.parent = parent;
            this.customLoader = customLoader;
            this.elements = elements;
            this.textures = textures;
            this.renderType = renderType;
            this.childModels = childModels;
            this.itemRenderOrder = itemRenderOrder;
        }

        @Override
        public void serializeJSONData(JsonObject json) {
            BlockModelBuilder.this.toJson(json);
            if (!this.childModels.isEmpty()) {
                BlockModelBuilder.this.childJson(json);
            }
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }

    public static enum FaceRotation {
        ZERO(0),
        CLOCKWISE_90(90),
        UPSIDE_DOWN(180),
        COUNTERCLOCKWISE_90(270);

        final int rotation;

        private FaceRotation(int rotation) {
            this.rotation = rotation;
        }
    }
}

