/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EEFeatureProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.FeatureBuilder;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.EEDeposits;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.IDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonDepositModelBase;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class OreFeatureDataGen
extends EEFeatureProvider {
    private final EmendatusDataRegistry registry;
    private final List<String> DEFAULT_COAL_ORE = List.of("minecraft:ore_coal_upper", "minecraft:ore_coal_lower");
    private final List<String> DEFAULT_COPPER_ORE = List.of("minecraft:ore_copper", "minecraft:ore_copper_large");
    private final List<String> DEFAULT_IRON_ORE = List.of("minecraft:ore_iron_upper", "minecraft:ore_iron_middle", "minecraft:ore_iron_small");
    private final List<String> DEFAULT_GOLD_ORE = List.of("minecraft:ore_gold_extra", "minecraft:ore_gold", "minecraft:ore_gold_lower");
    private final List<String> DEFAULT_NETHER_GOLD_ORE = List.of("minecraft:ore_gold_nether", "minecraft:ore_gold_deltas");
    private final List<String> DEFAULT_REDSTONE_ORE = List.of("minecraft:ore_redstone", "minecraft:ore_redstone_lower");
    private final List<String> DEFAULT_LAPIS_ORE = List.of("minecraft:ore_lapis", "minecraft:ore_lapis_buried");
    private final List<String> DEFAULT_DIAMOND_ORE = List.of("minecraft:ore_diamond", "minecraft:ore_diamond_large", "minecraft:ore_diamond_buried");
    private final List<String> DEFAULT_EMERALD_ORE = List.of("minecraft:ore_emerald");
    private final List<String> DEFAULT_QUARTZ_ORE = List.of("minecraft:ore_quartz_nether", "minecraft:ore_quartz_deltas");

    public OreFeatureDataGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen);
        this.registry = registry;
    }

    @Override
    protected void buildFeatures(Consumer<IFinishedGenericJSON> consumer) {
        for (MaterialModel material : this.registry.getMaterials()) {
            if (material.isVanilla() && material.getId().contains("coal") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_COAL_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_coal_ore"));
            }
            if (material.isVanilla() && material.getId().contains("copper") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_COPPER_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_copper_ore"));
            }
            if (material.isVanilla() && material.getId().contains("iron") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_IRON_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_iron_ore"));
            }
            if (material.isVanilla() && material.getId().contains("gold") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_GOLD_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_gold_ore"));
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_nether").features(this.DEFAULT_NETHER_GOLD_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_nether_gold_ore"));
            }
            if (material.isVanilla() && material.getId().contains("redstone") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_REDSTONE_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_redstone_ore"));
            }
            if (material.isVanilla() && material.getId().contains("lapis") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_LAPIS_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_lapis_ore"));
            }
            if (material.isVanilla() && material.getId().contains("diamond") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_DIAMOND_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_diamond_ore"));
            }
            if (material.isVanilla() && material.getId().contains("emerald") && material.getDisableDefaultOre()) {
                new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_overworld").features(this.DEFAULT_EMERALD_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_emerald_ore"));
            }
            if (!material.isVanilla() || !material.getId().contains("quartz") || !material.getDisableDefaultOre()) continue;
            new FeatureBuilder("forge:remove_features", "underground_ores").biome("#minecraft:is_nether").features(this.DEFAULT_QUARTZ_ORE).save(consumer, new ResourceLocation("emendatusenigmatica", "remove_default_nether_quartz_ore"));
        }
        for (IDepositProcessor processor : EEDeposits.ACTIVE_PROCESSORS) {
            CommonDepositModelBase model = processor.getCommonModel();
            ArrayList<String> biomes = new ArrayList<String>();
            ArrayList<String> features = new ArrayList<String>();
            if (model.getDimension().equals("minecraft:overworld")) {
                if (!model.getBiomes().isEmpty()) {
                    biomes.addAll(model.getBiomes());
                } else {
                    biomes.add("#minecraft:is_overworld");
                }
                features.add("emendatusenigmatica:" + model.getName());
                new FeatureBuilder("forge:add_features", "underground_ores").biomes(biomes).features(features).save(consumer, new ResourceLocation("emendatusenigmatica", model.getName() + "_ore_features"));
            }
            if (model.getDimension().equals("minecraft:the_nether")) {
                if (!model.getBiomes().isEmpty()) {
                    biomes.addAll(model.getBiomes());
                } else {
                    biomes.add("#minecraft:is_nether");
                }
                features.add("emendatusenigmatica:" + model.getName());
                new FeatureBuilder("forge:add_features", "underground_ores").biomes(biomes).features(features).save(consumer, new ResourceLocation("emendatusenigmatica", model.getName() + "_ore_features"));
            }
            if (model.getDimension().equals("minecraft:the_end")) {
                if (!model.getBiomes().isEmpty()) {
                    biomes.addAll(model.getBiomes());
                } else {
                    biomes.add("#minecraft:is_end");
                }
                features.add("emendatusenigmatica:" + model.getName());
                new FeatureBuilder("forge:add_features", "underground_ores").biomes(biomes).features(features).save(consumer, new ResourceLocation("emendatusenigmatica", model.getName() + "_ore_features"));
            }
            if (!Stream.of("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end").noneMatch(s -> model.getDimension().equals(s))) continue;
            if (!model.getBiomes().isEmpty()) {
                biomes.addAll(model.getBiomes());
            } else {
                biomes.add("#" + this.getModdedDim(model.getDimension()) + ":is_" + this.getModdedDim(model.getDimension()));
            }
            features.add("emendatusenigmatica:" + model.getName());
            new FeatureBuilder("forge:add_features", "underground_ores").biomes(biomes).features(features).save(consumer, new ResourceLocation("emendatusenigmatica", model.getName() + "_ore_features"));
        }
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Features";
    }

    private String getModdedDim(String dim) {
        return StringUtils.substringBefore((String)dim, (String)":");
    }
}

