/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EELootProvider;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;

public class LootTablesGen
extends EELootProvider {
    private final EmendatusDataRegistry registry;

    public LootTablesGen(DataGenerator dataGeneratorIn, EmendatusDataRegistry registry) {
        super(dataGeneratorIn);
        this.registry = registry;
    }

    @Override
    protected void addTables() {
        for (MaterialModel material : this.registry.getMaterials()) {
            List<String> processedType = material.getProcessedTypes();
            if (processedType.contains("storage_block")) {
                this.blockLootTable.put((Block)EERegistrar.storageBlockMap.get(material.getId()).get(), LootTablesGen.selfDrop((Block)EERegistrar.storageBlockMap.get(material.getId()).get()));
            }
            if (processedType.contains("cluster")) {
                this.blockLootTable.put((Block)EERegistrar.clusterShardBlockMap.get(material.getId()).get(), LootTablesGen.selfDrop((Block)EERegistrar.clusterShardBlockMap.get(material.getId()).get()));
                this.blockLootTable.put((Block)EERegistrar.smallBudBlockMap.get(material.getId()).get(), LootTablesGen.dropWhenSilkTouch((Block)EERegistrar.smallBudBlockMap.get(material.getId()).get()));
                this.blockLootTable.put((Block)EERegistrar.mediumBudBlockMap.get(material.getId()).get(), LootTablesGen.dropWhenSilkTouch((Block)EERegistrar.mediumBudBlockMap.get(material.getId()).get()));
                this.blockLootTable.put((Block)EERegistrar.mediumBudBlockMap.get(material.getId()).get(), LootTablesGen.dropWhenSilkTouch((Block)EERegistrar.mediumBudBlockMap.get(material.getId()).get()));
                this.blockLootTable.put((Block)EERegistrar.clusterBlockMap.get(material.getId()).get(), LootTablesGen.dropWhenSilkTouchWithSetCount((Block)EERegistrar.clusterBlockMap.get(material.getId()).get(), (Item)EERegistrar.clusterShardMap.get(material.getId()).get(), 2.0f, 4.0f));
            }
            if (processedType.contains("raw")) {
                this.blockLootTable.put((Block)EERegistrar.rawBlockMap.get(material.getId()).get(), LootTablesGen.selfDrop((Block)EERegistrar.rawBlockMap.get(material.getId()).get()));
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                if (processedType.contains("ore") && material.getProperties().getMaterialType().equals("metal")) {
                    if (material.getOreDrop().getMax() == 1) {
                        this.blockLootTable.put((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), LootTablesGen.specialDrop((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), processedType.contains("raw") && material.getOreDrop().getDrop().isEmpty() ? (Item)EERegistrar.rawMap.get(material.getId()).get() : material.getOreDrop().getDefaultItemDropAsItem().m_5456_()));
                    } else {
                        this.blockLootTable.put((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), LootTablesGen.specialCountDrop((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), processedType.contains("raw") && material.getOreDrop().getDrop().isEmpty() ? (ItemLike)EERegistrar.rawMap.get(material.getId()).get() : material.getOreDrop().getDefaultItemDropAsItem(), UniformGenerator.m_165780_((float)material.getOreDrop().getMin(), (float)material.getOreDrop().getMax())));
                    }
                }
                if (processedType.contains("ore") && material.getProperties().getMaterialType().equals("gem")) {
                    if (material.getOreDrop().getMax() == 1) {
                        this.blockLootTable.put((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), LootTablesGen.specialDrop((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), processedType.contains("gem") && material.getOreDrop().getDrop().isEmpty() ? (Item)EERegistrar.gemMap.get(material.getId()).get() : material.getOreDrop().getDefaultItemDropAsItem().m_5456_()));
                    } else {
                        this.blockLootTable.put((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), LootTablesGen.specialCountDrop((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), processedType.contains("gem") && material.getOreDrop().getDrop().isEmpty() ? (ItemLike)EERegistrar.gemMap.get(material.getId()).get() : material.getOreDrop().getDefaultItemDropAsItem(), UniformGenerator.m_165780_((float)material.getOreDrop().getMin(), (float)material.getOreDrop().getMax())));
                    }
                }
                if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                if (material.getOreDrop().getMax() == 1) {
                    this.blockLootTable.put((Block)((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), LootTablesGen.specialDrop((Block)((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), processedType.contains("raw") && material.getOreDrop().getDrop().isEmpty() ? (Item)EERegistrar.rawMap.get(material.getId()).get() : material.getOreDrop().getDefaultItemDropAsItem().m_5456_()));
                    continue;
                }
                this.blockLootTable.put((Block)((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), LootTablesGen.specialCountDrop((Block)((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), processedType.contains("raw") && material.getOreDrop().getDrop().isEmpty() ? (ItemLike)EERegistrar.rawMap.get(material.getId()).get() : material.getOreDrop().getDefaultItemDropAsItem(), UniformGenerator.m_165780_((float)material.getOreDrop().getMin(), (float)material.getOreDrop().getMax())));
            }
        }
    }
}

