/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EELangProvider;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.RegistryObject;

public class LangGen
extends EELangProvider {
    private final EmendatusDataRegistry registry;

    public LangGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen, "emendatusenigmatica", "en_us");
        this.registry = registry;
    }

    @Override
    protected void addTranslations() {
        this.add("itemGroup.emendatusenigmatica", "Emendatus Enigmatica");
        this.add((Item)EERegistrar.ENIGMATIC_HAMMER.get(), "Enigmatic Hammer");
        this.add((Item)EERegistrar.FELINIUM_JAMINITE.get(), "Felinium Jaminite Ingot");
        for (MaterialModel material : this.registry.getMaterials()) {
            StringBuilder sb7;
            StringBuilder sb6;
            StringBuilder sb5;
            StringBuilder sb4;
            StringBuilder sb3;
            StringBuilder sb2;
            StringBuilder sb;
            List<String> processedType = material.getProcessedTypes();
            if (processedType.contains("storage_block")) {
                sb = new StringBuilder();
                sb.append("Block of ");
                sb.append(material.getLocalizedName());
                this.add((Block)EERegistrar.storageBlockMap.get(material.getId()).get(), sb.toString());
                if (material.getProperties().hasOxidization()) {
                    sb2 = new StringBuilder();
                    sb2.append("Exposed ");
                    sb2.append(material.getLocalizedName());
                    this.add((Block)EERegistrar.exposedBlockMap.get(material.getId()).get(), sb2.toString());
                    sb3 = new StringBuilder();
                    sb3.append("Weathered ");
                    sb3.append(material.getLocalizedName());
                    this.add((Block)EERegistrar.weatheredBlockMap.get(material.getId()).get(), sb3.toString());
                    sb4 = new StringBuilder();
                    sb4.append("Oxidized ");
                    sb4.append(material.getLocalizedName());
                    this.add((Block)EERegistrar.oxidizedBlockMap.get(material.getId()).get(), sb4.toString());
                    sb5 = new StringBuilder();
                    sb5.append("Waxed Block of ");
                    sb5.append(material.getLocalizedName());
                    this.add((Block)EERegistrar.waxedStorageBlockMap.get(material.getId()).get(), sb5.toString());
                    sb6 = new StringBuilder();
                    sb6.append("Waxed Exposed ");
                    sb6.append(material.getLocalizedName());
                    this.add((Block)EERegistrar.waxedExposedBlockMap.get(material.getId()).get(), sb6.toString());
                    sb7 = new StringBuilder();
                    sb7.append("Waxed Weathered ");
                    sb7.append(material.getLocalizedName());
                    this.add((Block)EERegistrar.waxedWeatheredBlockMap.get(material.getId()).get(), sb7.toString());
                    StringBuilder sb8 = new StringBuilder();
                    sb8.append("Waxed Oxidized ");
                    sb8.append(material.getLocalizedName());
                    this.add((Block)EERegistrar.waxedOxidizedBlockMap.get(material.getId()).get(), sb8.toString());
                }
            }
            if (processedType.contains("ingot")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Ingot");
                this.add((Item)EERegistrar.ingotMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("gem")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Gem");
                this.add((Item)EERegistrar.gemMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("nugget")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Nugget");
                this.add((Item)EERegistrar.nuggetMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("dust")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Dust");
                this.add((Item)EERegistrar.dustMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("plate")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Plate");
                this.add((Item)EERegistrar.plateMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("gear")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Gear");
                this.add((Item)EERegistrar.gearMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("rod")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Rod");
                this.add((Item)EERegistrar.rodMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("sword")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Sword");
                this.add((Item)EERegistrar.swordMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("pickaxe")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Pickaxe");
                this.add((Item)EERegistrar.pickaxeMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("axe")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Axe");
                this.add((Item)EERegistrar.axeMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("shovel")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Shovel");
                this.add((Item)EERegistrar.shovelMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("hoe")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Hoe");
                this.add((Item)EERegistrar.hoeMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("paxel")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Paxel");
                this.add((Item)EERegistrar.paxelMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("helmet")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Helmet");
                this.add((Item)EERegistrar.helmetMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("chestplate")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Chestplate");
                this.add((Item)EERegistrar.chestplateMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("leggings")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Leggings");
                this.add((Item)EERegistrar.leggingsMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("boots")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Boots");
                this.add((Item)EERegistrar.bootsMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("shield")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Shield");
                this.add((Item)EERegistrar.shieldMap.get(material.getId()).get(), sb.toString());
            }
            if (processedType.contains("raw")) {
                sb = new StringBuilder();
                sb.append("Raw ");
                sb.append(material.getLocalizedName());
                this.add((Item)EERegistrar.rawMap.get(material.getId()).get(), sb.toString());
                sb2 = new StringBuilder();
                sb2.append("Block of Raw ");
                sb2.append(material.getLocalizedName());
                this.add((Block)EERegistrar.rawBlockMap.get(material.getId()).get(), sb2.toString());
            }
            if (processedType.contains("cluster")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                sb.append(" Cluster Shard");
                this.add((Item)EERegistrar.clusterShardMap.get(material.getId()).get(), sb.toString());
                sb2 = new StringBuilder();
                sb2.append("Budding ");
                sb2.append(material.getLocalizedName());
                this.add((Block)EERegistrar.buddingBlockMap.get(material.getId()).get(), sb2.toString());
                sb3 = new StringBuilder();
                sb3.append("Small ");
                sb3.append(material.getLocalizedName());
                sb3.append(" Bud");
                this.add((Block)EERegistrar.smallBudBlockMap.get(material.getId()).get(), sb3.toString());
                sb4 = new StringBuilder();
                sb4.append("Medium ");
                sb4.append(material.getLocalizedName());
                sb4.append(" Bud");
                this.add((Block)EERegistrar.mediumBudBlockMap.get(material.getId()).get(), sb4.toString());
                sb5 = new StringBuilder();
                sb5.append("Large ");
                sb5.append(material.getLocalizedName());
                sb5.append(" Bud");
                this.add((Block)EERegistrar.largeBudBlockMap.get(material.getId()).get(), sb5.toString());
                sb6 = new StringBuilder();
                sb6.append(material.getLocalizedName());
                sb6.append(" Cluster");
                this.add((Block)EERegistrar.clusterBlockMap.get(material.getId()).get(), sb6.toString());
                sb7 = new StringBuilder();
                sb7.append("Block of ");
                sb7.append(material.getLocalizedName());
                sb7.append(" Cluster Shard");
                this.add((Block)EERegistrar.clusterShardBlockMap.get(material.getId()).get(), sb7.toString());
            }
            if (processedType.contains("fluid")) {
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                this.add(((FluidType)EERegistrar.fluidTypeMap.get(material.getId()).get()).getDescriptionId(), sb.toString());
                sb2 = new StringBuilder();
                sb2.append(material.getLocalizedName());
                sb2.append(" Bucket");
                this.add((Item)EERegistrar.fluidBucketMap.get(material.getId()).get(), sb2.toString());
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                StringBuilder sb8;
                if (processedType.contains("ore")) {
                    sb8 = new StringBuilder();
                    sb8.append(material.getLocalizedName());
                    sb8.append(" Ore");
                    if (!stratum.getId().equals("minecraft_stone")) {
                        sb8.append(" - ");
                        sb8.append(stratum.getLocalizedName());
                    }
                    this.add((Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), sb8.toString());
                }
                if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                sb8 = new StringBuilder();
                sb8.append(material.getLocalizedName());
                sb8.append(" Rich ");
                sb8.append(stratum.getLocalizedName());
                this.add((Block)((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material.getId())).get(), sb8.toString());
            }
        }
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Languages: en_us";
    }
}

