/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.google.common.collect.Lists;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EETagProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.datagen.base.TagBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;

public class ItemTagsGen
extends EETagProvider {
    private final EmendatusDataRegistry registry;
    private final List<String> forgeBlocks = Lists.newArrayList();
    private final List<String> forgeIngots = Lists.newArrayList();
    private final List<String> forgeGems = Lists.newArrayList();
    private final List<String> forgeNuggets = Lists.newArrayList();
    private final List<String> forgeDusts = Lists.newArrayList();
    private final List<String> forgePlates = Lists.newArrayList();
    private final List<String> forgeGears = Lists.newArrayList();
    private final List<String> forgeRods = Lists.newArrayList();
    private final List<String> forgeRaw = Lists.newArrayList();
    private final List<String> forgeBuckets = Lists.newArrayList();
    private final List<String> forgeOres = Lists.newArrayList();
    private final List<String> forgeTools = Lists.newArrayList();
    private final List<String> forgeSwords = Lists.newArrayList();
    private final List<String> forgePickaxes = Lists.newArrayList();
    private final List<String> forgeAxes = Lists.newArrayList();
    private final List<String> forgeShovels = Lists.newArrayList();
    private final List<String> forgeHoes = Lists.newArrayList();
    private final List<String> forgePaxels = Lists.newArrayList();
    private final List<String> forgeShields = Lists.newArrayList();
    private final List<String> forgeHelmets = Lists.newArrayList();
    private final List<String> forgeChestplates = Lists.newArrayList();
    private final List<String> forgeLeggings = Lists.newArrayList();
    private final List<String> forgeBoots = Lists.newArrayList();
    private final Map<String, List<String>> oresPerMaterial = new HashMap<String, List<String>>();
    private final Map<String, List<String>> oresInGround = new HashMap<String, List<String>>();
    private final List<String> beaconIngots = Lists.newArrayList();

    public ItemTagsGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen);
        this.registry = registry;
    }

    @Override
    protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
        for (MaterialModel material2 : this.registry.getMaterials()) {
            List<String> processedType = material2.getProcessedTypes();
            if (processedType.contains("storage_block")) {
                ResourceLocation block = EERegistrar.storageBlockItemMap.get(material2.getId()).getId();
                if (!this.forgeBlocks.contains("#forge:storage_blocks/" + material2.getId())) {
                    this.forgeBlocks.add("#forge:storage_blocks/" + material2.getId());
                }
                new TagBuilder().tag(block.toString()).save(consumer, new ResourceLocation("forge", "/items/storage_blocks/" + material2.getId()));
            }
            if (processedType.contains("ingot")) {
                ResourceLocation ingot = EERegistrar.ingotMap.get(material2.getId()).getId();
                if (!this.forgeIngots.contains("#forge:ingots/" + material2.getId())) {
                    this.forgeIngots.add("#forge:ingots/" + material2.getId());
                }
                this.beaconIngots.add(ingot.toString());
                new TagBuilder().tag(ingot.toString()).save(consumer, new ResourceLocation("forge", "/items/ingots/" + material2.getId()));
            }
            if (processedType.contains("gem")) {
                ResourceLocation gem = EERegistrar.gemMap.get(material2.getId()).getId();
                if (!this.forgeGems.contains("#forge:gems/" + material2.getId())) {
                    this.forgeGems.add("#forge:gems/" + material2.getId());
                }
                new TagBuilder().tag(gem.toString()).save(consumer, new ResourceLocation("forge", "/items/gems/" + material2.getId()));
            }
            if (processedType.contains("nugget")) {
                ResourceLocation nugget = EERegistrar.nuggetMap.get(material2.getId()).getId();
                if (!this.forgeNuggets.contains("#forge:nuggets/" + material2.getId())) {
                    this.forgeNuggets.add("#forge:nuggets/" + material2.getId());
                }
                new TagBuilder().tag(nugget.toString()).save(consumer, new ResourceLocation("forge", "/items/nuggets/" + material2.getId()));
            }
            if (processedType.contains("dust")) {
                ResourceLocation dust = EERegistrar.dustMap.get(material2.getId()).getId();
                if (!this.forgeDusts.contains("#forge:dusts/" + material2.getId())) {
                    this.forgeDusts.add("#forge:dusts/" + material2.getId());
                }
                new TagBuilder().tag(dust.toString()).save(consumer, new ResourceLocation("forge", "/items/dusts/" + material2.getId()));
            }
            if (processedType.contains("plate")) {
                ResourceLocation plate = EERegistrar.plateMap.get(material2.getId()).getId();
                if (!this.forgePlates.contains("#forge:plates/" + material2.getId())) {
                    this.forgePlates.add("#forge:plates/" + material2.getId());
                }
                new TagBuilder().tag(plate.toString()).save(consumer, new ResourceLocation("forge", "/items/plates/" + material2.getId()));
            }
            if (processedType.contains("gear")) {
                ResourceLocation gear = EERegistrar.gearMap.get(material2.getId()).getId();
                if (!this.forgeGears.contains("#forge:gears/" + material2.getId())) {
                    this.forgeGears.add("#forge:gears/" + material2.getId());
                }
                new TagBuilder().tag(gear.toString()).save(consumer, new ResourceLocation("forge", "/items/gears/" + material2.getId()));
            }
            if (processedType.contains("rod")) {
                ResourceLocation rod = EERegistrar.rodMap.get(material2.getId()).getId();
                if (!this.forgeRods.contains("#forge:rods/" + material2.getId())) {
                    this.forgeRods.add("#forge:rods/" + material2.getId());
                }
                new TagBuilder().tag(rod.toString()).save(consumer, new ResourceLocation("forge", "/items/rods/" + material2.getId()));
            }
            if (processedType.contains("raw")) {
                ResourceLocation raw = EERegistrar.rawMap.get(material2.getId()).getId();
                ResourceLocation rawBlock = EERegistrar.rawBlockItemMap.get(material2.getId()).getId();
                if (!this.forgeRaw.contains("#forge:raw_materials/" + material2.getId())) {
                    this.forgeRaw.add("#forge:raw_materials/" + material2.getId());
                }
                if (!this.forgeBlocks.contains("#forge:storage_blocks/raw_" + material2.getId())) {
                    this.forgeBlocks.add("#forge:storage_blocks/raw_" + material2.getId());
                }
                new TagBuilder().tag(raw.toString()).save(consumer, new ResourceLocation("forge", "/items/raw_materials/" + material2.getId()));
                new TagBuilder().tag(rawBlock.toString()).save(consumer, new ResourceLocation("forge", "/items/storage_blocks/raw_" + material2.getId()));
            }
            if (processedType.contains("sword")) {
                ResourceLocation sword = EERegistrar.swordMap.get(material2.getId()).getId();
                if (!this.forgeSwords.contains("#forge:tools/swords/" + material2.getId())) {
                    this.forgeSwords.add("#forge:tools/swords/" + material2.getId());
                }
                new TagBuilder().tag(sword.toString()).save(consumer, new ResourceLocation("forge", "/items/tools/swords/" + material2.getId()));
            }
            if (processedType.contains("pickaxe")) {
                ResourceLocation pickaxe = EERegistrar.pickaxeMap.get(material2.getId()).getId();
                if (!this.forgePickaxes.contains("#forge:tools/pickaxes/" + material2.getId())) {
                    this.forgePickaxes.add("#forge:tools/pickaxes/" + material2.getId());
                }
                new TagBuilder().tag(pickaxe.toString()).save(consumer, new ResourceLocation("forge", "/items/tools/pickaxes/" + material2.getId()));
            }
            if (processedType.contains("axe")) {
                ResourceLocation axe = EERegistrar.axeMap.get(material2.getId()).getId();
                if (!this.forgeAxes.contains("#forge:tools/axes/" + material2.getId())) {
                    this.forgeAxes.add("#forge:tools/axes/" + material2.getId());
                }
                new TagBuilder().tag(axe.toString()).save(consumer, new ResourceLocation("forge", "/items/tools/axes/" + material2.getId()));
            }
            if (processedType.contains("shovel")) {
                ResourceLocation shovel = EERegistrar.shovelMap.get(material2.getId()).getId();
                if (!this.forgeShovels.contains("#forge:tools/shovels/" + material2.getId())) {
                    this.forgeShovels.add("#forge:tools/shovels/" + material2.getId());
                }
                new TagBuilder().tag(shovel.toString()).save(consumer, new ResourceLocation("forge", "/items/tools/shovels/" + material2.getId()));
            }
            if (processedType.contains("hoe")) {
                ResourceLocation hoe = EERegistrar.hoeMap.get(material2.getId()).getId();
                if (!this.forgeHoes.contains("#forge:tools/hoes/" + material2.getId())) {
                    this.forgeHoes.add("#forge:tools/hoes/" + material2.getId());
                }
                new TagBuilder().tag(hoe.toString()).save(consumer, new ResourceLocation("forge", "/items/tools/hoes/" + material2.getId()));
            }
            if (processedType.contains("paxel")) {
                ResourceLocation paxel = EERegistrar.paxelMap.get(material2.getId()).getId();
                if (!this.forgeTools.contains("#forge:tools/paxels")) {
                    this.forgeTools.add("#forge:tools/paxels");
                }
                if (!this.forgePaxels.contains("#forge:tools/paxels/" + material2.getId())) {
                    this.forgePaxels.add("#forge:tools/paxels/" + material2.getId());
                }
                new TagBuilder().tag(paxel.toString()).save(consumer, new ResourceLocation("forge", "/items/tools/paxels/" + material2.getId()));
            }
            if (processedType.contains("shield")) {
                ResourceLocation shield = EERegistrar.shieldMap.get(material2.getId()).getId();
                if (!this.forgeShields.contains("#forge:tools/shields/" + material2.getId())) {
                    this.forgeShields.add("#forge:tools/shields/" + material2.getId());
                }
                new TagBuilder().tag(shield.toString()).save(consumer, new ResourceLocation("forge", "/items/tools/shields/" + material2.getId()));
            }
            if (processedType.contains("helmet")) {
                ResourceLocation helmet = EERegistrar.helmetMap.get(material2.getId()).getId();
                if (!this.forgeHelmets.contains("#forge:armors/helmets/" + material2.getId())) {
                    this.forgeHelmets.add("#forge:armors/helmets/" + material2.getId());
                }
                new TagBuilder().tag(helmet.toString()).save(consumer, new ResourceLocation("forge", "/items/armors/helmets/" + material2.getId()));
            }
            if (processedType.contains("chestplate")) {
                ResourceLocation chestplate = EERegistrar.chestplateMap.get(material2.getId()).getId();
                if (!this.forgeChestplates.contains("#forge:armors/chestplates/" + material2.getId())) {
                    this.forgeChestplates.add("#forge:armors/chestplates/" + material2.getId());
                }
                new TagBuilder().tag(chestplate.toString()).save(consumer, new ResourceLocation("forge", "/items/armors/chestplates/" + material2.getId()));
            }
            if (processedType.contains("leggings")) {
                ResourceLocation leggings = EERegistrar.leggingsMap.get(material2.getId()).getId();
                if (!this.forgeLeggings.contains("#forge:armors/leggings/" + material2.getId())) {
                    this.forgeLeggings.add("#forge:armors/leggings/" + material2.getId());
                }
                new TagBuilder().tag(leggings.toString()).save(consumer, new ResourceLocation("forge", "/items/armors/leggings/" + material2.getId()));
            }
            if (processedType.contains("boots")) {
                ResourceLocation boots = EERegistrar.bootsMap.get(material2.getId()).getId();
                if (!this.forgeBoots.contains("#forge:armors/boots/" + material2.getId())) {
                    this.forgeBoots.add("#forge:armors/boots/" + material2.getId());
                }
                new TagBuilder().tag(boots.toString()).save(consumer, new ResourceLocation("forge", "/items/armors/boots/" + material2.getId()));
            }
            if (processedType.contains("fluid")) {
                ResourceLocation bucket = EERegistrar.fluidBucketMap.get(material2.getId()).getId();
                if (!this.forgeBuckets.contains("#forge:buckets/" + material2.getId())) {
                    this.forgeBuckets.add("#forge:buckets/" + material2.getId());
                }
                new TagBuilder().tag(bucket.toString()).save(consumer, new ResourceLocation("forge", "/items/buckets/" + material2.getId()));
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                if (processedType.contains("ore")) {
                    ResourceLocation ore = ((RegistryObject)EERegistrar.oreBlockItemTable.get((Object)stratum.getId(), (Object)material2.getId())).getId();
                    if (!this.forgeOres.contains("#forge:ores/" + material2.getId())) {
                        this.forgeOres.add("#forge:ores/" + material2.getId());
                    }
                    this.oresPerMaterial.computeIfAbsent(material2.getId(), s -> new ArrayList()).add(ore.toString());
                    this.oresInGround.computeIfAbsent(stratum.getSuffix(), s -> new ArrayList()).add(ore.toString());
                }
                if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                ResourceLocation oreSample = ((RegistryObject)EERegistrar.oreSampleBlockItemTable.get((Object)stratum.getId(), (Object)material2.getId())).getId();
                if (!this.forgeOres.contains("#forge:ores/" + material2.getId())) {
                    this.forgeOres.add("#forge:ores/" + material2.getId());
                }
                this.oresPerMaterial.computeIfAbsent(material2.getId(), s -> new ArrayList()).add(oreSample.toString());
                this.oresInGround.computeIfAbsent(stratum.getSuffix(), s -> new ArrayList()).add(oreSample.toString());
            }
        }
        if (!this.oresPerMaterial.isEmpty()) {
            this.oresPerMaterial.forEach((material, oreList) -> new TagBuilder().tags((List<String>)oreList).save(consumer, new ResourceLocation("forge", "/items/ores/" + material)));
        }
        if (!this.oresInGround.isEmpty()) {
            this.oresInGround.forEach((strataPrefix, oreType) -> new TagBuilder().tags((List<String>)oreType).save(consumer, new ResourceLocation("forge", "/items/ores_in_ground/" + strataPrefix)));
        }
        if (!this.forgeBlocks.isEmpty()) {
            new TagBuilder().tags(this.forgeBlocks).save(consumer, new ResourceLocation("forge", "/items/storage_blocks"));
        }
        if (!this.forgeIngots.isEmpty()) {
            new TagBuilder().tags(this.forgeIngots).save(consumer, new ResourceLocation("forge", "/items/ingots"));
        }
        if (!this.forgeGems.isEmpty()) {
            new TagBuilder().tags(this.forgeGems).save(consumer, new ResourceLocation("forge", "/items/gems"));
        }
        if (!this.forgeNuggets.isEmpty()) {
            new TagBuilder().tags(this.forgeNuggets).save(consumer, new ResourceLocation("forge", "/items/nuggets"));
        }
        if (!this.forgeDusts.isEmpty()) {
            new TagBuilder().tags(this.forgeDusts).save(consumer, new ResourceLocation("forge", "/items/dusts"));
        }
        if (!this.forgePlates.isEmpty()) {
            new TagBuilder().tags(this.forgePlates).save(consumer, new ResourceLocation("forge", "/items/plates"));
        }
        if (!this.forgeGears.isEmpty()) {
            new TagBuilder().tags(this.forgeGears).save(consumer, new ResourceLocation("forge", "/items/gears"));
        }
        if (!this.forgeRods.isEmpty()) {
            new TagBuilder().tags(this.forgeRods).save(consumer, new ResourceLocation("forge", "/items/rods"));
        }
        if (!this.forgeRaw.isEmpty()) {
            new TagBuilder().tags(this.forgeRaw).save(consumer, new ResourceLocation("forge", "/items/raw_materials"));
        }
        if (!this.forgeSwords.isEmpty()) {
            new TagBuilder().tags(this.forgeSwords).save(consumer, new ResourceLocation("forge", "/items/tools/swords"));
        }
        if (!this.forgePickaxes.isEmpty()) {
            new TagBuilder().tags(this.forgePickaxes).save(consumer, new ResourceLocation("forge", "/items/tools/pickaxes"));
        }
        if (!this.forgeAxes.isEmpty()) {
            new TagBuilder().tags(this.forgeAxes).save(consumer, new ResourceLocation("forge", "/items/tools/axes"));
        }
        if (!this.forgeShovels.isEmpty()) {
            new TagBuilder().tags(this.forgeShovels).save(consumer, new ResourceLocation("forge", "/items/tools/shovels"));
        }
        if (!this.forgeHoes.isEmpty()) {
            new TagBuilder().tags(this.forgeHoes).save(consumer, new ResourceLocation("forge", "/items/tools/hoes"));
        }
        if (!this.forgePaxels.isEmpty()) {
            new TagBuilder().tags(this.forgePaxels).save(consumer, new ResourceLocation("forge", "/items/tools/paxels"));
        }
        if (!this.forgeTools.isEmpty()) {
            new TagBuilder().tags(this.forgeTools).save(consumer, new ResourceLocation("forge", "/items/tools"));
        }
        if (!this.forgeHelmets.isEmpty()) {
            new TagBuilder().tags(this.forgeHelmets).save(consumer, new ResourceLocation("forge", "/items/armors/helmets"));
        }
        if (!this.forgeChestplates.isEmpty()) {
            new TagBuilder().tags(this.forgeChestplates).save(consumer, new ResourceLocation("forge", "/items/armors/chestplates"));
        }
        if (!this.forgeLeggings.isEmpty()) {
            new TagBuilder().tags(this.forgeLeggings).save(consumer, new ResourceLocation("forge", "/items/armors/leggings"));
        }
        if (!this.forgeBoots.isEmpty()) {
            new TagBuilder().tags(this.forgeBoots).save(consumer, new ResourceLocation("forge", "/items/armors/boots"));
        }
        if (!this.forgeBuckets.isEmpty()) {
            new TagBuilder().tags(this.forgeBuckets).save(consumer, new ResourceLocation("forge", "/items/buckets"));
        }
        if (!this.forgeOres.isEmpty()) {
            new TagBuilder().tags(this.forgeOres).save(consumer, new ResourceLocation("forge", "/items/ores"));
        }
        if (!this.beaconIngots.isEmpty()) {
            new TagBuilder().tags(this.beaconIngots).save(consumer, new ResourceLocation("minecraft", "/items/beacon_payment_items"));
        }
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Item Tags";
    }
}

