/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EEItemModelProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.datagen.base.ItemModelBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;

public class ItemModelsGen
extends EEItemModelProvider {
    private final EmendatusDataRegistry registry;

    public ItemModelsGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen);
        this.registry = registry;
    }

    @Override
    protected void buildItemModels(Consumer<IFinishedGenericJSON> consumer) {
        for (MaterialModel material : this.registry.getMaterials()) {
            List<String> processedType = material.getProcessedTypes();
            if (processedType.contains("storage_block")) {
                if (material.getProperties().hasOxidization()) {
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/exposed_" + material.getId()).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "exposed_" + material.getId()));
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/weathered_" + material.getId()).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "weathered_" + material.getId()));
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/oxidized_" + material.getId()).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "oxidized_" + material.getId()));
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/waxed_" + material.getId() + "_block").toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_" + material.getId() + "_block"));
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/waxed_exposed_" + material.getId()).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_exposed_" + material.getId()));
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/waxed_weathered_" + material.getId()).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_weathered_" + material.getId()));
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/waxed_oxidized_" + material.getId()).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_oxidized_" + material.getId()));
                }
                new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_block").toString()).save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_block"));
            }
            if (processedType.contains("cluster")) {
                new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster_shard_block").toString()).save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_cluster_shard_block"));
                new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/budding_" + material.getId()).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "budding_" + material.getId()));
                ItemModelBuilder smallBudBuilder = new ItemModelBuilder("emendatusenigmatica:item/bud");
                if (material.getColors().getMaterialColor() == -1) {
                    smallBudBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/small_" + material.getId() + "_bud").toString());
                } else {
                    smallBudBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/small_bud/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/small_bud/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/small_bud/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/small_bud/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/small_bud/04").toString());
                }
                smallBudBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", "small_" + material.getId() + "_bud"));
                ItemModelBuilder mediumBudBuilder = new ItemModelBuilder("emendatusenigmatica:item/bud");
                if (material.getColors().getMaterialColor() == -1) {
                    mediumBudBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/medium_" + material.getId() + "_bud").toString());
                } else {
                    mediumBudBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/medium_bud/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/medium_bud/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/medium_bud/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/medium_bud/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/medium_bud/04").toString());
                }
                mediumBudBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", "medium_" + material.getId() + "_bud"));
                ItemModelBuilder largeBudBuilder = new ItemModelBuilder("emendatusenigmatica:item/bud");
                if (material.getColors().getMaterialColor() == -1) {
                    largeBudBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/large_" + material.getId() + "_bud").toString());
                } else {
                    largeBudBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/large_bud/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/large_bud/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/large_bud/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/large_bud/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/large_bud/04").toString());
                }
                largeBudBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", "large_" + material.getId() + "_bud"));
                ItemModelBuilder clusterBuilder = new ItemModelBuilder("emendatusenigmatica:item/bud");
                if (material.getColors().getMaterialColor() == -1) {
                    clusterBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/" + material.getId() + "_cluster").toString());
                } else {
                    clusterBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/cluster/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/cluster/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/cluster/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/cluster/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "blocks/templates/clusters/cluster/04").toString());
                }
                clusterBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_cluster"));
                ItemModelBuilder clusterShardBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    clusterShardBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_cluster_shard").toString());
                } else {
                    clusterShardBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/cluster_shard/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/cluster_shard/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/cluster_shard/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/cluster_shard/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/cluster_shard/04").toString());
                }
                clusterShardBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_cluster_shard"));
            }
            if (processedType.contains("ingot")) {
                ItemModelBuilder ingotBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    ingotBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_ingot").toString());
                } else {
                    ingotBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/ingot/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/ingot/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/ingot/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/ingot/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/ingot/04").toString());
                }
                ingotBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_ingot"));
            }
            if (processedType.contains("nugget")) {
                ItemModelBuilder nuggetBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    nuggetBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_nugget").toString());
                } else {
                    nuggetBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/nugget/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/nugget/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/nugget/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/nugget/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/nugget/04").toString());
                }
                nuggetBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_nugget"));
            }
            if (processedType.contains("gem")) {
                ItemModelBuilder gemBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    gemBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_gem").toString());
                } else {
                    gemBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/gem/template_" + material.getProperties().getGemTexture() + "/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/gem/template_" + material.getProperties().getGemTexture() + "/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/gem/template_" + material.getProperties().getGemTexture() + "/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/gem/template_" + material.getProperties().getGemTexture() + "/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/gem/template_" + material.getProperties().getGemTexture() + "/04").toString());
                }
                gemBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_gem"));
            }
            if (processedType.contains("dust")) {
                ItemModelBuilder dustBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    dustBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_dust").toString());
                } else {
                    dustBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/dust/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/dust/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/dust/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/dust/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/dust/04").toString());
                }
                dustBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_dust"));
            }
            if (processedType.contains("plate")) {
                ItemModelBuilder plateBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    plateBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_plate").toString());
                } else {
                    plateBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/plate/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/plate/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/plate/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/plate/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/plate/04").toString());
                }
                plateBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_plate"));
            }
            if (processedType.contains("gear")) {
                ItemModelBuilder gearBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    gearBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_gear").toString());
                } else {
                    gearBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/gear/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/gear/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/gear/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/gear/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/gear/04").toString());
                }
                gearBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_gear"));
            }
            if (processedType.contains("rod")) {
                ItemModelBuilder rodBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    rodBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_rod").toString());
                } else {
                    rodBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/rod/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/rod/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/rod/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/rod/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/rod/04").toString());
                }
                rodBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_rod"));
            }
            if (processedType.contains("raw")) {
                ItemModelBuilder rawBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    rawBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/raw_" + material.getId()).toString());
                } else {
                    rawBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/raw/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/raw/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/raw/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/raw/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/raw/04").toString());
                }
                rawBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", "raw_" + material.getId()));
                new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/raw_" + material.getId() + "_block").toString()).save(consumer, new ResourceLocation("emendatusenigmatica", "raw_" + material.getId() + "_block"));
            }
            if (processedType.contains("sword")) {
                ItemModelBuilder swordBuilder = new ItemModelBuilder("minecraft:item/handheld");
                if (material.getColors().getMaterialColor() == -1) {
                    swordBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_sword").toString());
                } else {
                    swordBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/sword/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/sword/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/sword/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/sword/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/sword/grip").toString());
                }
                swordBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_sword"));
            }
            if (processedType.contains("pickaxe")) {
                ItemModelBuilder pickaxeBuilder = new ItemModelBuilder("minecraft:item/handheld");
                if (material.getColors().getMaterialColor() == -1) {
                    pickaxeBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_pickaxe").toString());
                } else {
                    pickaxeBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/pickaxe/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/pickaxe/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/pickaxe/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/pickaxe/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/pickaxe/grip").toString());
                }
                pickaxeBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_pickaxe"));
            }
            if (processedType.contains("axe")) {
                ItemModelBuilder axeBuilder = new ItemModelBuilder("minecraft:item/handheld");
                if (material.getColors().getMaterialColor() == -1) {
                    axeBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_axe").toString());
                } else {
                    axeBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/axe/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/axe/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/axe/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/axe/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/axe/grip").toString());
                }
                axeBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_axe"));
            }
            if (processedType.contains("shovel")) {
                ItemModelBuilder shovelBuilder = new ItemModelBuilder("minecraft:item/handheld");
                if (material.getColors().getMaterialColor() == -1) {
                    shovelBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_shovel").toString());
                } else {
                    shovelBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/shovel/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/shovel/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/shovel/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/shovel/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/shovel/grip").toString());
                }
                shovelBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_shovel"));
            }
            if (processedType.contains("hoe")) {
                ItemModelBuilder hoeBuilder = new ItemModelBuilder("minecraft:item/handheld");
                if (material.getColors().getMaterialColor() == -1) {
                    hoeBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_hoe").toString());
                } else {
                    hoeBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/hoe/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/hoe/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/hoe/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/hoe/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/hoe/grip").toString());
                }
                hoeBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_hoe"));
            }
            if (processedType.contains("paxel")) {
                ItemModelBuilder paxelBuilder = new ItemModelBuilder("minecraft:item/handheld");
                if (material.getColors().getMaterialColor() == -1) {
                    paxelBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_paxel").toString());
                } else {
                    paxelBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/paxel/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/paxel/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/paxel/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/paxel/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/paxel/grip").toString());
                }
                paxelBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_paxel"));
            }
            if (processedType.contains("helmet")) {
                ItemModelBuilder helmetBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    helmetBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_helmet").toString());
                } else {
                    helmetBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/helmet/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/helmet/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/helmet/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/helmet/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/helmet/04").toString());
                }
                helmetBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_helmet"));
            }
            if (processedType.contains("chestplate")) {
                ItemModelBuilder chestplateBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    chestplateBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_chestplate").toString());
                } else {
                    chestplateBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/chestplate/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/chestplate/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/chestplate/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/chestplate/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/chestplate/04").toString());
                }
                chestplateBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_chestplate"));
            }
            if (processedType.contains("leggings")) {
                ItemModelBuilder leggingsBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    leggingsBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_leggings").toString());
                } else {
                    leggingsBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/leggings/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/leggings/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/leggings/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/leggings/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/leggings/04").toString());
                }
                leggingsBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_leggings"));
            }
            if (processedType.contains("boots")) {
                ItemModelBuilder bootsBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    bootsBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_boots").toString());
                } else {
                    bootsBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/boots/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/boots/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/boots/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/boots/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/boots/04").toString());
                }
                bootsBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_boots"));
            }
            if (processedType.contains("shield")) {
                ItemModelBuilder shieldBlockingBuilder = new ItemModelBuilder("minecraft:item/shield_blocking").texture("particle", new ResourceLocation("minecraft", "block/dark_oak_planks").toString());
                shieldBlockingBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_shield_blocking"));
                ItemModelBuilder shieldBuilder = new ItemModelBuilder("minecraft:item/shield").texture("particle", new ResourceLocation("minecraft", "block/dark_oak_planks").toString()).override().predicate(new ResourceLocation("emendatusenigmatica", "blocking"), 1.0f).model(new ResourceLocation("emendatusenigmatica", "item/" + material.getId() + "_shield_blocking")).end();
                shieldBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_shield"));
            }
            if (processedType.contains("fluid")) {
                new ItemModelBuilder("forge:item/bucket_drip").applyTint(true).fluid(EERegistrar.fluidSourceMap.get(material.getId()).getId().toString()).loader("forge:fluid_container").save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_bucket"));
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                if (processedType.contains("ore")) {
                    new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/" + ItemModelsGen.getOreModelName(stratum, material)).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", ItemModelsGen.getOreModelName(stratum, material)));
                }
                if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                new ItemModelBuilder(new ResourceLocation("emendatusenigmatica", "block/" + ItemModelsGen.getOreSampleModelName(stratum, material)).toString()).save(consumer, new ResourceLocation("emendatusenigmatica", ItemModelsGen.getOreSampleModelName(stratum, material)));
            }
        }
    }

    public static String getOreModelName(StrataModel stratum, MaterialModel material) {
        return material.getId() + (String)(!stratum.getId().equals("minecraft_stone") ? "_" + stratum.getSuffix() : "") + "_ore";
    }

    public static String getOreSampleModelName(StrataModel stratum, MaterialModel material) {
        return material.getId() + "_" + stratum.getSuffix() + "_ore_sample";
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Item Models";
    }
}

