/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EETagProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.datagen.base.TagBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;

public class FluidTagsGen
extends EETagProvider {
    private final EmendatusDataRegistry registry;

    public FluidTagsGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen);
        this.registry = registry;
    }

    @Override
    protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
        for (MaterialModel material : this.registry.getMaterials()) {
            List<String> processedType = material.getProcessedTypes();
            if (!processedType.contains("fluid")) continue;
            ResourceLocation fluidSource = EERegistrar.fluidSourceMap.get(material.getId()).getId();
            ResourceLocation fluidFlowing = EERegistrar.fluidFlowingMap.get(material.getId()).getId();
            new TagBuilder().tag(fluidSource.toString()).tag(fluidFlowing.toString()).save(consumer, new ResourceLocation("forge", "/fluids/" + material.getId()));
        }
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Fluid Tags";
    }
}

