/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.google.common.collect.Lists;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EETagProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.datagen.base.TagBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;

public class BlockTagsGen
extends EETagProvider {
    private final EmendatusDataRegistry registry;
    private final List<String> forgeBlocks = Lists.newArrayList();
    private final List<String> forgeOres = Lists.newArrayList();
    private final Map<String, List<String>> oresPerMaterial = new HashMap<String, List<String>>();
    private final Map<String, List<String>> oresInGround = new HashMap<String, List<String>>();

    public BlockTagsGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen);
        this.registry = registry;
    }

    @Override
    protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
        for (MaterialModel material2 : this.registry.getMaterials()) {
            List<String> processedType = material2.getProcessedTypes();
            if (processedType.contains("storage_block")) {
                ResourceLocation block = EERegistrar.storageBlockMap.get(material2.getId()).getId();
                if (!this.forgeBlocks.contains("#forge:storage_blocks/" + material2.getId())) {
                    this.forgeBlocks.add("#forge:storage_blocks/" + material2.getId());
                }
                new TagBuilder().tag(block.toString()).save(consumer, new ResourceLocation("forge", "/blocks/storage_blocks/" + material2.getId()));
            }
            if (processedType.contains("raw")) {
                ResourceLocation raw = EERegistrar.rawBlockMap.get(material2.getId()).getId();
                if (!this.forgeBlocks.contains("#forge:storage_blocks/raw_" + material2.getId())) {
                    this.forgeBlocks.add("#forge:storage_blocks/raw_" + material2.getId());
                }
                new TagBuilder().tag(raw.toString()).save(consumer, new ResourceLocation("forge", "/blocks/storage_blocks/raw_" + material2.getId()));
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                ResourceLocation ore;
                if (processedType.contains("ore")) {
                    ore = ((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material2.getId())).getId();
                    if (!this.forgeOres.contains("#forge:ores/" + material2.getId())) {
                        this.forgeOres.add("#forge:ores/" + material2.getId());
                    }
                    this.oresPerMaterial.computeIfAbsent(material2.getId(), s -> new ArrayList()).add(ore.toString());
                    this.oresInGround.computeIfAbsent(stratum.getSuffix(), s -> new ArrayList()).add(ore.toString());
                }
                if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                ore = ((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material2.getId())).getId();
                if (!this.forgeOres.contains("#forge:ores/" + material2.getId())) {
                    this.forgeOres.add("#forge:ores/" + material2.getId());
                }
                this.oresPerMaterial.computeIfAbsent(material2.getId(), s -> new ArrayList()).add(ore.toString());
                this.oresInGround.computeIfAbsent(stratum.getSuffix(), s -> new ArrayList()).add(ore.toString());
            }
        }
        if (!this.oresPerMaterial.isEmpty()) {
            this.oresPerMaterial.forEach((material, oreList) -> new TagBuilder().tags((List<String>)oreList).save(consumer, new ResourceLocation("forge", "/blocks/ores/" + material)));
        }
        if (!this.oresInGround.isEmpty()) {
            this.oresInGround.forEach((strataPrefix, oreType) -> new TagBuilder().tags((List<String>)oreType).save(consumer, new ResourceLocation("forge", "/blocks/ores_in_ground/" + strataPrefix)));
        }
        if (!this.forgeBlocks.isEmpty()) {
            new TagBuilder().tags(this.forgeBlocks).save(consumer, new ResourceLocation("forge", "/blocks/storage_blocks"));
        }
        if (!this.forgeOres.isEmpty()) {
            new TagBuilder().tags(this.forgeOres).save(consumer, new ResourceLocation("forge", "/blocks/ores"));
        }
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Block Tags";
    }
}

