/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.BlockStateBuilder;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EEBlockStateProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;

public class BlockStatesGen
extends EEBlockStateProvider {
    private final EmendatusDataRegistry registry;

    public BlockStatesGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen);
        this.registry = registry;
    }

    @Override
    protected void buildBlockState(Consumer<IFinishedGenericJSON> consumer) {
        for (MaterialModel material : this.registry.getMaterials()) {
            List<String> processedType = material.getProcessedTypes();
            if (processedType.contains("storage_block")) {
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_block").toString())).save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_block"));
                if (material.getProperties().hasOxidization()) {
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/exposed_" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "exposed_" + material.getId()));
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/weathered_" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "weathered_" + material.getId()));
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/oxidized_" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "oxidized_" + material.getId()));
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/waxed_" + material.getId() + "_block").toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_" + material.getId() + "_block"));
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/waxed_exposed_" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_exposed_" + material.getId()));
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/waxed_weathered_" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_weathered_" + material.getId()));
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/waxed_oxidized_" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "waxed_oxidized_" + material.getId()));
                }
            }
            if (processedType.contains("cluster")) {
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster_shard_block").toString())).save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_cluster_shard_block"));
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("facing=down").setModel(new ResourceLocation("emendatusenigmatica", "block/small_" + material.getId() + "_bud").toString()).setX(180)).variant(new BlockStateBuilder.VariantBuilder("facing=east").setModel(new ResourceLocation("emendatusenigmatica", "block/small_" + material.getId() + "_bud").toString()).setX(90).setY(90)).variant(new BlockStateBuilder.VariantBuilder("facing=north").setModel(new ResourceLocation("emendatusenigmatica", "block/small_" + material.getId() + "_bud").toString()).setX(90)).variant(new BlockStateBuilder.VariantBuilder("facing=south").setModel(new ResourceLocation("emendatusenigmatica", "block/small_" + material.getId() + "_bud").toString()).setX(90).setY(180)).variant(new BlockStateBuilder.VariantBuilder("facing=up").setModel(new ResourceLocation("emendatusenigmatica", "block/small_" + material.getId() + "_bud").toString())).variant(new BlockStateBuilder.VariantBuilder("facing=west").setModel(new ResourceLocation("emendatusenigmatica", "block/small_" + material.getId() + "_bud").toString()).setX(90).setY(270)).save(consumer, new ResourceLocation("emendatusenigmatica", "small_" + material.getId() + "_bud"));
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("facing=down").setModel(new ResourceLocation("emendatusenigmatica", "block/medium_" + material.getId() + "_bud").toString()).setX(180)).variant(new BlockStateBuilder.VariantBuilder("facing=east").setModel(new ResourceLocation("emendatusenigmatica", "block/medium_" + material.getId() + "_bud").toString()).setX(90).setY(90)).variant(new BlockStateBuilder.VariantBuilder("facing=north").setModel(new ResourceLocation("emendatusenigmatica", "block/medium_" + material.getId() + "_bud").toString()).setX(90)).variant(new BlockStateBuilder.VariantBuilder("facing=south").setModel(new ResourceLocation("emendatusenigmatica", "block/medium_" + material.getId() + "_bud").toString()).setX(90).setY(180)).variant(new BlockStateBuilder.VariantBuilder("facing=up").setModel(new ResourceLocation("emendatusenigmatica", "block/medium_" + material.getId() + "_bud").toString())).variant(new BlockStateBuilder.VariantBuilder("facing=west").setModel(new ResourceLocation("emendatusenigmatica", "block/medium_" + material.getId() + "_bud").toString()).setX(90).setY(270)).save(consumer, new ResourceLocation("emendatusenigmatica", "medium_" + material.getId() + "_bud"));
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("facing=down").setModel(new ResourceLocation("emendatusenigmatica", "block/large_" + material.getId() + "_bud").toString()).setX(180)).variant(new BlockStateBuilder.VariantBuilder("facing=east").setModel(new ResourceLocation("emendatusenigmatica", "block/large_" + material.getId() + "_bud").toString()).setX(90).setY(90)).variant(new BlockStateBuilder.VariantBuilder("facing=north").setModel(new ResourceLocation("emendatusenigmatica", "block/large_" + material.getId() + "_bud").toString()).setX(90)).variant(new BlockStateBuilder.VariantBuilder("facing=south").setModel(new ResourceLocation("emendatusenigmatica", "block/large_" + material.getId() + "_bud").toString()).setX(90).setY(180)).variant(new BlockStateBuilder.VariantBuilder("facing=up").setModel(new ResourceLocation("emendatusenigmatica", "block/large_" + material.getId() + "_bud").toString())).variant(new BlockStateBuilder.VariantBuilder("facing=west").setModel(new ResourceLocation("emendatusenigmatica", "block/large_" + material.getId() + "_bud").toString()).setX(90).setY(270)).save(consumer, new ResourceLocation("emendatusenigmatica", "large_" + material.getId() + "_bud"));
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("facing=down").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster").toString()).setX(180)).variant(new BlockStateBuilder.VariantBuilder("facing=east").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster").toString()).setX(90).setY(90)).variant(new BlockStateBuilder.VariantBuilder("facing=north").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster").toString()).setX(90)).variant(new BlockStateBuilder.VariantBuilder("facing=south").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster").toString()).setX(90).setY(180)).variant(new BlockStateBuilder.VariantBuilder("facing=up").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster").toString())).variant(new BlockStateBuilder.VariantBuilder("facing=west").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId() + "_cluster").toString()).setX(90).setY(270)).save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_cluster"));
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/budding_" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "budding_" + material.getId()));
            }
            if (processedType.contains("raw")) {
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/raw_" + material.getId() + "_block").toString())).save(consumer, new ResourceLocation("emendatusenigmatica", "raw_" + material.getId() + "_block"));
            }
            if (processedType.contains("fluid")) {
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/" + material.getId()).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", material.getId()));
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                if (processedType.contains("ore")) {
                    new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/" + BlockStatesGen.getOreModelName(stratum, material)).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", BlockStatesGen.getOreModelName(stratum, material)));
                }
                if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                new BlockStateBuilder().variant(new BlockStateBuilder.VariantBuilder("").setModel(new ResourceLocation("emendatusenigmatica", "block/" + BlockStatesGen.getOreSampleModelName(stratum, material)).toString())).save(consumer, new ResourceLocation("emendatusenigmatica", BlockStatesGen.getOreSampleModelName(stratum, material)));
            }
        }
    }

    public static String getOreModelName(StrataModel stratum, MaterialModel material) {
        return material.getId() + (String)(!stratum.getId().equals("minecraft_stone") ? "_" + stratum.getSuffix() : "") + "_ore";
    }

    public static String getOreSampleModelName(StrataModel stratum, MaterialModel material) {
        return material.getId() + "_" + stratum.getSuffix() + "_ore_sample";
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Blockstates";
    }
}

