/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.BlockModelBuilder;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EEBlockModelProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;

public class BlockModelsGen
extends EEBlockModelProvider {
    private final EmendatusDataRegistry registry;

    public BlockModelsGen(DataGenerator gen, EmendatusDataRegistry registry) {
        super(gen);
        this.registry = registry;
    }

    @Override
    protected void buildBlockModel(Consumer<IFinishedGenericJSON> consumer) {
        for (MaterialModel material : this.registry.getMaterials()) {
            List<String> processedType = material.getProcessedTypes();
            if (processedType.contains("storage_block")) {
                if (material.getColors().getMaterialColor() == -1) {
                    if (material.getProperties().hasOxidization()) {
                        if (material.getProperties().getMaterialType().equals("gem")) {
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "exposed", "gem", "exposed_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "weathered", "gem", "weathered_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "oxidized", "gem", "oxidized_" + material.getId());
                            this.storageBlock(consumer, "blocks/" + material.getId() + "_block", "waxed_" + material.getId() + "_block");
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "exposed", "gem", "waxed_exposed_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "weathered", "gem", "waxed_weathered_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "oxidized", "gem", "waxed_oxidized_" + material.getId());
                        } else {
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "exposed", "metal", "exposed_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "weathered", "metal", "weathered_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "oxidized", "metal", "oxidized_" + material.getId());
                            this.storageBlock(consumer, "blocks/" + material.getId() + "_block", "waxed_" + material.getId() + "_block");
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "exposed", "metal", "waxed_exposed_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "weathered", "metal", "waxed_weathered_" + material.getId());
                            this.oxidizationBlock(consumer, "blocks/" + material.getId() + "_block", "oxidized", "metal", "waxed_oxidized_" + material.getId());
                        }
                    }
                    this.storageBlock(consumer, "blocks/" + material.getId() + "_block", material.getId() + "_block");
                } else if (material.getProperties().getMaterialType().equals("gem")) {
                    if (material.getProperties().hasOxidization()) {
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", "exposed", "gem", "exposed_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", "weathered", "gem", "weathered_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", "oxidized", "gem", "oxidized_" + material.getId());
                        this.storageTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", "waxed_" + material.getId() + "_block");
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", "exposed", "gem", "waxed_exposed_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", "weathered", "gem", "waxed_weathered_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", "oxidized", "gem", "waxed_oxidized_" + material.getId());
                    }
                    this.storageTintBlock(consumer, "blocks/templates/block/gem/00", "blocks/templates/block/gem/01", "blocks/templates/block/gem/02", "blocks/templates/block/gem/03", "blocks/templates/block/gem/04", material.getId() + "_block");
                } else {
                    if (material.getProperties().hasOxidization()) {
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", "exposed", "metal", "exposed_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", "weathered", "metal", "weathered_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", "oxidized", "metal", "oxidized_" + material.getId());
                        this.storageTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", "waxed_" + material.getId() + "_block");
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", "exposed", "metal", "waxed_exposed_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", "weathered", "metal", "waxed_weathered_" + material.getId());
                        this.oxidizationTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", "oxidized", "metal", "waxed_oxidized_" + material.getId());
                    }
                    this.storageTintBlock(consumer, "blocks/templates/block/metal/00", "blocks/templates/block/metal/01", "blocks/templates/block/metal/02", "blocks/templates/block/metal/03", "blocks/templates/block/metal/04", material.getId() + "_block");
                }
            }
            if (processedType.contains("cluster")) {
                if (material.getColors().getMaterialColor() == -1) {
                    this.storageBlock(consumer, "blocks/" + material.getId() + "_cluster_shard_block", material.getId() + "_cluster_shard_block");
                    this.storageBlock(consumer, "blocks/budding_" + material.getId(), "budding_" + material.getId());
                    this.clusterBlock(consumer, "blocks/small_" + material.getId() + "_bud", "small_" + material.getId() + "_bud");
                    this.clusterBlock(consumer, "blocks/medium_" + material.getId() + "_bud", "medium_" + material.getId() + "_bud");
                    this.clusterBlock(consumer, "blocks/large_" + material.getId() + "_bud", "large_" + material.getId() + "_bud");
                    this.clusterBlock(consumer, "blocks/" + material.getId() + "_cluster", material.getId() + "_cluster");
                } else {
                    this.storageTintBlock(consumer, "blocks/templates/clusters/block/00", "blocks/templates/clusters/block/01", "blocks/templates/clusters/block/02", "blocks/templates/clusters/block/03", "blocks/templates/clusters/block/04", material.getId() + "_cluster_shard_block");
                    this.storageTintBlock(consumer, "blocks/templates/clusters/budding/00", "blocks/templates/clusters/budding/01", "blocks/templates/clusters/budding/02", "blocks/templates/clusters/budding/03", "blocks/templates/clusters/budding/04", "budding_" + material.getId());
                    this.clusterTintBlock(consumer, "blocks/templates/clusters/small_bud/00", "blocks/templates/clusters/small_bud/01", "blocks/templates/clusters/small_bud/02", "blocks/templates/clusters/small_bud/03", "blocks/templates/clusters/small_bud/04", "small_" + material.getId() + "_bud");
                    this.clusterTintBlock(consumer, "blocks/templates/clusters/medium_bud/00", "blocks/templates/clusters/medium_bud/01", "blocks/templates/clusters/medium_bud/02", "blocks/templates/clusters/medium_bud/03", "blocks/templates/clusters/medium_bud/04", "medium_" + material.getId() + "_bud");
                    this.clusterTintBlock(consumer, "blocks/templates/clusters/large_bud/00", "blocks/templates/clusters/large_bud/01", "blocks/templates/clusters/large_bud/02", "blocks/templates/clusters/large_bud/03", "blocks/templates/clusters/large_bud/04", "large_" + material.getId() + "_bud");
                    this.clusterTintBlock(consumer, "blocks/templates/clusters/cluster/00", "blocks/templates/clusters/cluster/01", "blocks/templates/clusters/cluster/02", "blocks/templates/clusters/cluster/03", "blocks/templates/clusters/cluster/04", material.getId() + "_cluster");
                }
            }
            if (processedType.contains("raw")) {
                if (material.getColors().getMaterialColor() == -1) {
                    this.storageBlock(consumer, "blocks/raw_" + material.getId() + "_block", "raw_" + material.getId() + "_block");
                } else {
                    this.storageTintBlock(consumer, "blocks/templates/raw_block/00", "blocks/templates/raw_block/01", "blocks/templates/raw_block/02", "blocks/templates/raw_block/03", "blocks/templates/raw_block/04", "raw_" + material.getId() + "_block");
                }
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                if (processedType.contains("ore")) {
                    if (material.getColors().getMaterialColor() == -1) {
                        if (material.getProperties().isEmissive()) {
                            this.oreEmissiveBlock(consumer, stratum.getBaseTexture().toString(), "blocks/overlays/" + material.getId(), BlockModelsGen.getOreModelName(stratum, material));
                        } else {
                            this.oreBlock(consumer, stratum.getBaseTexture().toString(), "blocks/overlays/" + material.getId(), BlockModelsGen.getOreModelName(stratum, material));
                        }
                    } else if (material.getProperties().getMaterialType().equals("gem")) {
                        if (material.getProperties().isEmissive()) {
                            this.oreEmissiveTintBlock(consumer, stratum.getBaseTexture().toString(), "blocks/templates/ore/gem/00", "blocks/templates/ore/gem/01", "blocks/templates/ore/gem/02", "blocks/templates/ore/gem/03", "blocks/templates/ore/gem/04", "blocks/templates/ore/gem/shadow_drop", BlockModelsGen.getOreModelName(stratum, material));
                        } else {
                            this.oreTintBlock(consumer, stratum.getBaseTexture().toString(), "blocks/templates/ore/gem/00", "blocks/templates/ore/gem/01", "blocks/templates/ore/gem/02", "blocks/templates/ore/gem/03", "blocks/templates/ore/gem/04", "blocks/templates/ore/gem/shadow_drop", BlockModelsGen.getOreModelName(stratum, material));
                        }
                    } else if (material.getProperties().isEmissive()) {
                        this.oreEmissiveTintBlock(consumer, stratum.getBaseTexture().toString(), "blocks/templates/ore/metal/00", "blocks/templates/ore/metal/01", "blocks/templates/ore/metal/02", "blocks/templates/ore/metal/03", "blocks/templates/ore/metal/04", "blocks/templates/ore/metal/shadow_drop", BlockModelsGen.getOreModelName(stratum, material));
                    } else {
                        this.oreTintBlock(consumer, stratum.getBaseTexture().toString(), "blocks/templates/ore/metal/00", "blocks/templates/ore/metal/01", "blocks/templates/ore/metal/02", "blocks/templates/ore/metal/03", "blocks/templates/ore/metal/04", "blocks/templates/ore/metal/shadow_drop", BlockModelsGen.getOreModelName(stratum, material));
                    }
                }
                if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                if (material.getColors().getMaterialColor() == -1) {
                    if (material.getProperties().isEmissive()) {
                        this.oreEmissiveBlock(consumer, stratum.getBaseTexture().toString(), "blocks/overlays/" + material.getId() + "_sample", BlockModelsGen.getOreSampleModelName(stratum, material));
                        continue;
                    }
                    this.oreBlock(consumer, stratum.getBaseTexture().toString(), "blocks/overlays/" + material.getId() + "_sample", BlockModelsGen.getOreSampleModelName(stratum, material));
                    continue;
                }
                if (material.getProperties().isEmissive()) {
                    this.oreEmissiveTintBlock(consumer, stratum.getBaseTexture().toString(), "blocks/templates/sample/00", "blocks/templates/sample/01", "blocks/templates/sample/02", "blocks/templates/sample//03", "blocks/templates/sample/04", "blocks/templates/sample/shadow_drop", BlockModelsGen.getOreSampleModelName(stratum, material));
                    continue;
                }
                this.oreTintBlock(consumer, stratum.getBaseTexture().toString(), "blocks/templates/sample/00", "blocks/templates/sample/01", "blocks/templates/sample/02", "blocks/templates/sample//03", "blocks/templates/sample/04", "blocks/templates/sample/shadow_drop", BlockModelsGen.getOreSampleModelName(stratum, material));
            }
        }
    }

    private void oxidizationBlock(Consumer<IFinishedGenericJSON> consumer, String base, String age, String type, String path) {
        new BlockModelBuilder("minecraft:block/block").setLoader("forge:composite").texture("particle", new ResourceLocation("emendatusenigmatica", base)).child("solid", new BlockModelBuilder("minecraft:block/block").texture("base", new ResourceLocation("emendatusenigmatica", base)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#base").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("solid")).child("translucent", new BlockModelBuilder("minecraft:block/block").texture(age, new ResourceLocation("emendatusenigmatica", "blocks/templates/block/" + type + "/oxidization/" + age)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#" + age).allFaces((dir, uv) -> uv.tintindex(9)).end().renderType("translucent")).save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    private void oxidizationTintBlock(Consumer<IFinishedGenericJSON> consumer, String highlight2, String highlight1, String base, String shadow1, String shadow2, String age, String type, String path) {
        new BlockModelBuilder("minecraft:block/block").setLoader("forge:composite").texture("particle", new ResourceLocation("emendatusenigmatica", base)).child("cutout", new BlockModelBuilder("minecraft:block/block").texture("highlight2", new ResourceLocation("emendatusenigmatica", highlight2)).texture("highlight1", new ResourceLocation("emendatusenigmatica", highlight1)).texture("base", new ResourceLocation("emendatusenigmatica", base)).texture("shadow1", new ResourceLocation("emendatusenigmatica", shadow1)).texture("shadow2", new ResourceLocation("emendatusenigmatica", shadow2)).element().cube("#highlight2").allFaces((d, u) -> u.tintindex(0)).end().element().cube("#highlight1").allFaces((d, u) -> u.tintindex(1)).end().element().cube("#base").allFaces((d, u) -> u.tintindex(2)).end().element().cube("#shadow1").allFaces((d, u) -> u.tintindex(3)).end().element().cube("#shadow2").allFaces((d, u) -> u.tintindex(4)).end().renderType("cutout")).child("translucent", new BlockModelBuilder("minecraft:block/block").texture(age, new ResourceLocation("emendatusenigmatica", "blocks/templates/block/" + type + "/oxidization/" + age)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#" + age).allFaces((dir, uv) -> uv.tintindex(9)).end().renderType("translucent")).save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    private void clusterBlock(Consumer<IFinishedGenericJSON> consumer, String base, String path) {
        new BlockModelBuilder("minecraft:block/cross").texture("cross", new ResourceLocation("emendatusenigmatica", base)).texture("particle", new ResourceLocation("emendatusenigmatica", base)).renderType("cutout").save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    private void clusterTintBlock(Consumer<IFinishedGenericJSON> consumer, String highlight2, String highlight1, String base, String shadow1, String shadow2, String path) {
        new BlockModelBuilder("emendatusenigmatica:block/bud").renderType("cutout").texture("highlight2", new ResourceLocation("emendatusenigmatica", highlight2)).texture("highlight1", new ResourceLocation("emendatusenigmatica", highlight1)).texture("base", new ResourceLocation("emendatusenigmatica", base)).texture("shadow1", new ResourceLocation("emendatusenigmatica", shadow1)).texture("shadow2", new ResourceLocation("emendatusenigmatica", shadow2)).texture("particle", new ResourceLocation("emendatusenigmatica", base)).save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    private void storageBlock(Consumer<IFinishedGenericJSON> consumer, String base, String path) {
        new BlockModelBuilder("minecraft:block/block").texture("base", new ResourceLocation("emendatusenigmatica", base)).texture("particle", new ResourceLocation("emendatusenigmatica", base)).element().cube("#base").allFaces((d, u) -> u.tintindex(-1)).end().save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    private void storageTintBlock(Consumer<IFinishedGenericJSON> consumer, String highlight2, String highlight1, String base, String shadow1, String shadow2, String path) {
        new BlockModelBuilder("minecraft:block/block").renderType("cutout").texture("highlight2", new ResourceLocation("emendatusenigmatica", highlight2)).texture("highlight1", new ResourceLocation("emendatusenigmatica", highlight1)).texture("base", new ResourceLocation("emendatusenigmatica", base)).texture("shadow1", new ResourceLocation("emendatusenigmatica", shadow1)).texture("shadow2", new ResourceLocation("emendatusenigmatica", shadow2)).texture("particle", new ResourceLocation("emendatusenigmatica", base)).element().cube("#highlight2").allFaces((d, u) -> u.tintindex(0)).end().element().cube("#highlight1").allFaces((d, u) -> u.tintindex(1)).end().element().cube("#base").allFaces((d, u) -> u.tintindex(2)).end().element().cube("#shadow1").allFaces((d, u) -> u.tintindex(3)).end().element().cube("#shadow2").allFaces((d, u) -> u.tintindex(4)).end().save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    public void oreBlock(Consumer<IFinishedGenericJSON> consumer, String strata, String overlayTexture, String path) {
        new BlockModelBuilder("minecraft:block/block").texture("particle", strata).setLoader("forge:composite").child("solid", new BlockModelBuilder("minecraft:block/block").texture("strata", strata).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#strata").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("solid")).child("translucent", new BlockModelBuilder("minecraft:block/block").texture("overlay", new ResourceLocation("emendatusenigmatica", overlayTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#overlay").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("translucent")).save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    public void oreEmissiveBlock(Consumer<IFinishedGenericJSON> consumer, String strata, String overlayTexture, String path) {
        new BlockModelBuilder("minecraft:block/block").texture("particle", strata).setLoader("forge:composite").child("solid", new BlockModelBuilder("minecraft:block/block").texture("strata", strata).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#strata").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("solid")).child("translucent", new BlockModelBuilder("minecraft:block/block").texture("overlay", new ResourceLocation("emendatusenigmatica", overlayTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#overlay").allFaces((dir, uv) -> uv.tintindex(-1).emissive()).end().renderType("translucent")).save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    public void oreTintBlock(Consumer<IFinishedGenericJSON> consumer, String strata, String highlight2, String highlight1, String base, String shadow1, String shadow2, String drop, String path) {
        new BlockModelBuilder("minecraft:block/block").texture("particle", strata).setLoader("forge:composite").child("solid", new BlockModelBuilder("minecraft:block/block").texture("strata", strata).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#strata").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("solid")).child("cutout", new BlockModelBuilder("minecraft:block/block").texture("highlight2", new ResourceLocation("emendatusenigmatica", highlight2)).texture("highlight1", new ResourceLocation("emendatusenigmatica", highlight1)).texture("base", new ResourceLocation("emendatusenigmatica", base)).texture("shadow1", new ResourceLocation("emendatusenigmatica", shadow1)).texture("shadow2", new ResourceLocation("emendatusenigmatica", shadow2)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#highlight2").allFaces((dir, uv) -> uv.tintindex(0)).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#highlight1").allFaces((dir, uv) -> uv.tintindex(1)).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#base").allFaces((dir, uv) -> uv.tintindex(2)).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#shadow1").allFaces((dir, uv) -> uv.tintindex(3)).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#shadow2").allFaces((dir, uv) -> uv.tintindex(4)).end().renderType("cutout")).child("translucent", new BlockModelBuilder("minecraft:block/block").texture("drop", new ResourceLocation("emendatusenigmatica", drop)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#drop").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("translucent")).save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    public void oreEmissiveTintBlock(Consumer<IFinishedGenericJSON> consumer, String strata, String highlight2, String highlight1, String base, String shadow1, String shadow2, String drop, String path) {
        new BlockModelBuilder("minecraft:block/block").texture("particle", strata).setLoader("forge:composite").child("solid", new BlockModelBuilder("minecraft:block/block").texture("strata", strata).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#strata").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("solid")).child("cutout", new BlockModelBuilder("minecraft:block/block").texture("highlight2", new ResourceLocation("emendatusenigmatica", highlight2)).texture("highlight1", new ResourceLocation("emendatusenigmatica", highlight1)).texture("base", new ResourceLocation("emendatusenigmatica", base)).texture("shadow1", new ResourceLocation("emendatusenigmatica", shadow1)).texture("shadow2", new ResourceLocation("emendatusenigmatica", shadow2)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#highlight2").allFaces((dir, uv) -> uv.tintindex(0).emissive()).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#highlight1").allFaces((dir, uv) -> uv.tintindex(1).emissive()).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#base").allFaces((dir, uv) -> uv.tintindex(2).emissive()).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#shadow1").allFaces((dir, uv) -> uv.tintindex(3).emissive()).end().element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#shadow2").allFaces((dir, uv) -> uv.tintindex(4).emissive()).end().renderType("cutout")).child("translucent", new BlockModelBuilder("minecraft:block/block").texture("drop", new ResourceLocation("emendatusenigmatica", drop)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#drop").allFaces((dir, uv) -> uv.tintindex(-1)).end().renderType("translucent")).save(consumer, new ResourceLocation("emendatusenigmatica", path));
    }

    public static String getOreModelName(StrataModel stratum, MaterialModel material) {
        return material.getId() + (String)(!stratum.getId().equals("minecraft_stone") ? "_" + stratum.getSuffix() : "") + "_ore";
    }

    public static String getOreSampleModelName(StrataModel stratum, MaterialModel material) {
        return material.getId() + "_" + stratum.getSuffix() + "_ore_sample";
    }

    @Override
    public String m_6055_() {
        return "Emendatus Enigmatica Block Models";
    }
}

