/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen;

import com.google.common.collect.Lists;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EETagProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.datagen.base.TagBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;

public class BlockHarvestTagsGen {

    public static class BlockHarvestToolTagsGen
    extends EETagProvider {
        private final EmendatusDataRegistry registry;
        private final List<String> shovel = Lists.newArrayList();
        private final List<String> hoe = Lists.newArrayList();
        private final List<String> axe = Lists.newArrayList();
        private final List<String> pickaxe = Lists.newArrayList();
        private final List<String> paxel = Lists.newArrayList();

        public BlockHarvestToolTagsGen(DataGenerator gen, EmendatusDataRegistry registry) {
            super(gen);
            this.registry = registry;
        }

        @Override
        protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
            for (MaterialModel material : this.registry.getMaterials()) {
                List<String> processedType = material.getProcessedTypes();
                if (processedType.contains("storage_block")) {
                    ResourceLocation block = EERegistrar.storageBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(block.toString());
                    if (material.getProperties().hasOxidization()) {
                        ResourceLocation exposedBlock = EERegistrar.exposedBlockMap.get(material.getId()).getId();
                        this.pickaxe.add(exposedBlock.toString());
                        ResourceLocation weatheredBlock = EERegistrar.weatheredBlockMap.get(material.getId()).getId();
                        this.pickaxe.add(weatheredBlock.toString());
                        ResourceLocation oxidizedBlock = EERegistrar.oxidizedBlockMap.get(material.getId()).getId();
                        this.pickaxe.add(oxidizedBlock.toString());
                        ResourceLocation waxedBlock = EERegistrar.waxedStorageBlockMap.get(material.getId()).getId();
                        this.pickaxe.add(waxedBlock.toString());
                        ResourceLocation waxedExposedBlock = EERegistrar.waxedExposedBlockMap.get(material.getId()).getId();
                        this.pickaxe.add(waxedExposedBlock.toString());
                        ResourceLocation waxedWeatheredBlock = EERegistrar.waxedWeatheredBlockMap.get(material.getId()).getId();
                        this.pickaxe.add(waxedWeatheredBlock.toString());
                        ResourceLocation waxedOxidizedBlock = EERegistrar.waxedOxidizedBlockMap.get(material.getId()).getId();
                        this.pickaxe.add(waxedOxidizedBlock.toString());
                    }
                }
                if (processedType.contains("raw")) {
                    ResourceLocation raw = EERegistrar.rawBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(raw.toString());
                }
                if (processedType.contains("cluster")) {
                    ResourceLocation budding = EERegistrar.buddingBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(budding.toString());
                    ResourceLocation smallBud = EERegistrar.smallBudBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(smallBud.toString());
                    ResourceLocation mediumBud = EERegistrar.mediumBudBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(mediumBud.toString());
                    ResourceLocation largeBud = EERegistrar.largeBudBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(largeBud.toString());
                    ResourceLocation clusterBlock = EERegistrar.clusterBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(clusterBlock.toString());
                    ResourceLocation clusterShardBlock = EERegistrar.clusterShardBlockMap.get(material.getId()).getId();
                    this.pickaxe.add(clusterShardBlock.toString());
                }
                block25: for (StrataModel stratum : this.registry.getStrata()) {
                    if (processedType.contains("ore")) {
                        ResourceLocation ore = ((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).getId();
                        switch (stratum.getHarvestTool()) {
                            case "shovel": {
                                this.shovel.add(ore.toString());
                                break;
                            }
                            case "hoe": {
                                this.hoe.add(ore.toString());
                                break;
                            }
                            case "axe": {
                                this.axe.add(ore.toString());
                                break;
                            }
                            case "pickaxe": {
                                this.pickaxe.add(ore.toString());
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Harvest tool " + stratum.getHarvestTool() + " for " + stratum.getId() + " is out of Vanilla tool system bounds, and the tag should be added manually");
                            }
                        }
                    }
                    if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                    ResourceLocation oreSample = ((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material.getId())).getId();
                    switch (stratum.getHarvestTool()) {
                        case "shovel": {
                            this.shovel.add(oreSample.toString());
                            continue block25;
                        }
                        case "hoe": {
                            this.hoe.add(oreSample.toString());
                            continue block25;
                        }
                        case "axe": {
                            this.axe.add(oreSample.toString());
                            continue block25;
                        }
                        case "pickaxe": {
                            this.pickaxe.add(oreSample.toString());
                            continue block25;
                        }
                    }
                    throw new IllegalStateException("Harvest tool " + stratum.getHarvestTool() + " for " + stratum.getId() + " is out of Vanilla tool system bounds, and the tag should be added manually");
                }
            }
            if (!this.shovel.isEmpty()) {
                new TagBuilder().tags(this.shovel).save(consumer, new ResourceLocation("minecraft", "/blocks/mineable/shovel"));
            }
            if (!this.hoe.isEmpty()) {
                new TagBuilder().tags(this.hoe).save(consumer, new ResourceLocation("minecraft", "/blocks/mineable/hoe"));
            }
            if (!this.axe.isEmpty()) {
                new TagBuilder().tags(this.axe).save(consumer, new ResourceLocation("minecraft", "/blocks/mineable/axe"));
            }
            if (!this.pickaxe.isEmpty()) {
                new TagBuilder().tags(this.pickaxe).save(consumer, new ResourceLocation("minecraft", "/blocks/mineable/pickaxe"));
            }
            this.paxel.add("#minecraft:mineable/axe");
            this.paxel.add("#minecraft:mineable/pickaxe");
            this.paxel.add("#minecraft:mineable/shovel");
            new TagBuilder().tags(this.paxel).save(consumer, new ResourceLocation("forge", "/blocks/mineable/paxel"));
        }

        @Override
        public String m_6055_() {
            return "Emendatus Enigmatica Block Harvest Tool Tags";
        }
    }

    public static class BlockHarvestLevelTagsGen
    extends EETagProvider {
        private final EmendatusDataRegistry registry;
        private final List<String> woodTool = Lists.newArrayList();
        private final List<String> stoneTool = Lists.newArrayList();
        private final List<String> ironTool = Lists.newArrayList();
        private final List<String> diamondTool = Lists.newArrayList();
        private final List<String> netheriteTool = Lists.newArrayList();

        public BlockHarvestLevelTagsGen(DataGenerator gen, EmendatusDataRegistry registry) {
            super(gen);
            this.registry = registry;
        }

        @Override
        protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
            for (MaterialModel material : this.registry.getMaterials()) {
                List<String> processedType = material.getProcessedTypes();
                if (processedType.contains("storage_block")) {
                    ResourceLocation block = EERegistrar.storageBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, block);
                    if (material.getProperties().hasOxidization()) {
                        ResourceLocation exposedBlock = EERegistrar.exposedBlockMap.get(material.getId()).getId();
                        this.harvestLevelSwitch(material, exposedBlock);
                        ResourceLocation weatheredBlock = EERegistrar.weatheredBlockMap.get(material.getId()).getId();
                        this.harvestLevelSwitch(material, weatheredBlock);
                        ResourceLocation oxidizedBlock = EERegistrar.oxidizedBlockMap.get(material.getId()).getId();
                        this.harvestLevelSwitch(material, oxidizedBlock);
                        ResourceLocation waxedBlock = EERegistrar.waxedStorageBlockMap.get(material.getId()).getId();
                        this.harvestLevelSwitch(material, waxedBlock);
                        ResourceLocation waxedExposedBlock = EERegistrar.waxedExposedBlockMap.get(material.getId()).getId();
                        this.harvestLevelSwitch(material, waxedExposedBlock);
                        ResourceLocation waxedWeatheredBlock = EERegistrar.waxedWeatheredBlockMap.get(material.getId()).getId();
                        this.harvestLevelSwitch(material, waxedWeatheredBlock);
                        ResourceLocation waxedOxidizedBlock = EERegistrar.waxedOxidizedBlockMap.get(material.getId()).getId();
                        this.harvestLevelSwitch(material, waxedOxidizedBlock);
                    }
                }
                if (processedType.contains("raw")) {
                    ResourceLocation raw = EERegistrar.rawBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, raw);
                }
                if (processedType.contains("cluster")) {
                    ResourceLocation budding = EERegistrar.buddingBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, budding);
                    ResourceLocation smallBud = EERegistrar.smallBudBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, smallBud);
                    ResourceLocation mediumBud = EERegistrar.mediumBudBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, mediumBud);
                    ResourceLocation largeBud = EERegistrar.largeBudBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, largeBud);
                    ResourceLocation clusterBlock = EERegistrar.clusterBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, clusterBlock);
                    ResourceLocation clusterShardBlock = EERegistrar.clusterShardBlockMap.get(material.getId()).getId();
                    this.harvestLevelSwitch(material, clusterShardBlock);
                }
                for (StrataModel stratum : this.registry.getStrata()) {
                    if (processedType.contains("ore")) {
                        ResourceLocation ore = ((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId())).getId();
                        this.harvestLevelSwitch(material, ore);
                    }
                    if (!processedType.contains("ore") || !stratum.getSampleStrata()) continue;
                    ResourceLocation oreSample = ((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)stratum.getId(), (Object)material.getId())).getId();
                    this.harvestLevelSwitch(material, oreSample);
                }
            }
            if (!this.woodTool.isEmpty()) {
                new TagBuilder().tags(this.woodTool).save(consumer, new ResourceLocation("forge", "/blocks/needs_wood_tool"));
            }
            if (!this.stoneTool.isEmpty()) {
                new TagBuilder().tags(this.stoneTool).save(consumer, new ResourceLocation("minecraft", "/blocks/needs_stone_tool"));
            }
            if (!this.ironTool.isEmpty()) {
                new TagBuilder().tags(this.ironTool).save(consumer, new ResourceLocation("minecraft", "/blocks/needs_iron_tool"));
            }
            if (!this.diamondTool.isEmpty()) {
                new TagBuilder().tags(this.diamondTool).save(consumer, new ResourceLocation("minecraft", "/blocks/needs_diamond_tool"));
            }
            if (!this.netheriteTool.isEmpty()) {
                new TagBuilder().tags(this.netheriteTool).save(consumer, new ResourceLocation("forge", "/blocks/needs_netherite_tool"));
            }
        }

        private void harvestLevelSwitch(MaterialModel material, ResourceLocation loc) {
            switch (material.getProperties().getHarvestLevel()) {
                case 0: {
                    this.woodTool.add(loc.toString());
                    break;
                }
                case 1: {
                    this.stoneTool.add(loc.toString());
                    break;
                }
                case 2: {
                    this.ironTool.add(loc.toString());
                    break;
                }
                case 3: {
                    this.diamondTool.add(loc.toString());
                    break;
                }
                case 4: {
                    this.netheriteTool.add(loc.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("Harvest level " + material.getProperties().getHarvestLevel() + " for " + material.getId() + " is out of Vanilla tier system bounds, and the tag should be added manually");
                }
            }
        }

        @Override
        public String m_6055_() {
            return "Emendatus Enigmatica Block Harvest Level Tags";
        }
    }
}

