/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.blocks;

import com.mojang.math.Vector3f;
import com.ridanisaurus.emendatusenigmatica.blocks.IColorable;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class MetalOreBlockWithParticles
extends Block
implements IColorable {
    private final String localisedName;
    private final int particleColor;
    public final int highlight2;
    public final int highlight1;
    public final int base;
    public final int shadow1;
    public final int shadow2;

    public MetalOreBlockWithParticles(StrataModel strata, MaterialModel material) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(strata.getHardness(), strata.getResistance()).m_60999_());
        this.localisedName = material.getLocalizedName();
        this.particleColor = material.getColors().getParticlesColor();
        this.highlight2 = material.getColors().getHighlightColor(3);
        this.highlight1 = material.getColors().getHighlightColor(1);
        this.base = material.getColors().getMaterialColor();
        this.shadow1 = material.getColors().getShadowColor(1);
        this.shadow2 = material.getColors().getShadowColor(2);
    }

    public MutableComponent m_49954_() {
        return Component.m_237115_((String)this.localisedName);
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.m_214162_(stateIn, worldIn, pos, rand);
        if (rand.m_188503_(10) == 0) {
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = pos.m_121945_(direction);
                if (worldIn.m_8055_(blockpos).m_60804_((BlockGetter)worldIn, blockpos)) continue;
                Direction.Axis direction$axis = direction.m_122434_();
                double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)rand.m_188501_();
                double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)rand.m_188501_();
                double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)rand.m_188501_();
                worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)this.particleColor)), 1.0f), (double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getHighlight2() {
        return this.highlight2;
    }

    @Override
    public int getHighlight1() {
        return this.highlight1;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getShadow1() {
        return this.shadow1;
    }

    @Override
    public int getShadow2() {
        return this.shadow2;
    }
}

