/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.blocks;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.ridanisaurus.emendatusenigmatica.blocks.IColorable;
import com.ridanisaurus.emendatusenigmatica.items.PaxelItem;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public class BasicWeatheringBlock
extends Block
implements ChangeOverTimeBlock<WeatherState>,
IColorable {
    private final WeatherState weatherState;
    private final Supplier<BiMap<Block, Block>> nextByBlock;
    private final Supplier<BiMap<Block, Block>> previousByBlock;
    private final Supplier<BiMap<Block, Block>> waxableBlockMap;
    private final String localisedName;
    public final int highlight2;
    public final int highlight1;
    public final int base;
    public final int shadow1;
    public final int shadow2;
    public final int oxidizationColor;

    public BasicWeatheringBlock(MaterialModel material, WeatherState weatherState, Supplier<BiMap<Block, Block>> nextByBlock, Supplier<BiMap<Block, Block>> waxableBlockMap) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 3.0f).m_60999_());
        this.weatherState = weatherState;
        this.nextByBlock = nextByBlock;
        this.previousByBlock = Suppliers.memoize(() -> ((BiMap)nextByBlock.get()).inverse());
        this.waxableBlockMap = waxableBlockMap;
        this.localisedName = material.getLocalizedName();
        this.highlight2 = material.getColors().getHighlightColor(3);
        this.highlight1 = material.getColors().getHighlightColor(1);
        this.base = material.getColors().getMaterialColor();
        this.shadow1 = material.getColors().getShadowColor(1);
        this.shadow2 = material.getColors().getShadowColor(2);
        this.oxidizationColor = material.getColors().getOxidizationColor();
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        this.m_220947_(blockState, level, pos, rand);
    }

    public boolean m_6724_(BlockState blockState) {
        return this.getNext(blockState.m_60734_()).isPresent();
    }

    public WeatherState getAge() {
        return this.weatherState;
    }

    public Optional<Block> getPrevious(Block block) {
        return Optional.ofNullable((Block)this.previousByBlock.get().get((Object)block));
    }

    public Block getFirst(Block block) {
        Block block1 = block;
        Block block2 = (Block)this.previousByBlock.get().get((Object)block);
        while (block2 != null) {
            block1 = block2;
            block2 = (Block)this.previousByBlock.get().get((Object)block2);
        }
        return block1;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional<Block> block;
        ItemStack stack = player.m_21120_(hand);
        if ((stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof PaxelItem) && (block = this.getPrevious(blockState.m_60734_())).isPresent()) {
            level.m_7731_(pos, block.map(b -> b.m_152465_(blockState)).get(), 11);
            level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, pos, 0);
            stack.m_41774_(0);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42784_ && (block = this.getWaxed(blockState.m_60734_())).isPresent()) {
            level.m_7731_(pos, block.map(b -> b.m_152465_(blockState)).get(), 11);
            level.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3003, pos, 0);
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)this.nextByBlock.get().get((Object)block));
    }

    public BlockState getFirst(BlockState blockState) {
        return this.getFirst(blockState.m_60734_()).m_152465_(blockState);
    }

    private Optional<Block> getWaxed(Block block) {
        return Optional.ofNullable((Block)this.waxableBlockMap.get().get((Object)block));
    }

    public Optional<BlockState> m_142123_(BlockState blockState) {
        return this.getNext(blockState.m_60734_()).map(block -> block.m_152465_(blockState));
    }

    public Optional<BlockState> getPrevious(BlockState blockState) {
        return this.getPrevious(blockState.m_60734_()).map(block -> block.m_152465_(blockState));
    }

    public float m_142377_() {
        return this.getAge() == WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public MutableComponent m_49954_() {
        return Component.m_237115_((String)this.localisedName);
    }

    @Override
    public int getHighlight2() {
        return this.highlight2;
    }

    @Override
    public int getHighlight1() {
        return this.highlight1;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getShadow1() {
        return this.shadow1;
    }

    @Override
    public int getShadow2() {
        return this.shadow2;
    }

    public int getOxidizationColor() {
        return this.oxidizationColor;
    }

    public static enum WeatherState {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

