/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.blocks;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.ridanisaurus.emendatusenigmatica.blocks.IColorable;
import com.ridanisaurus.emendatusenigmatica.items.PaxelItem;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public class BasicWaxedBlock
extends Block
implements IColorable {
    private final Supplier<BiMap<Block, Block>> waxableBlockMap;
    private final Supplier<BiMap<Block, Block>> reverseWaxableBlockMap;
    private final String localisedName;
    public final int highlight2;
    public final int highlight1;
    public final int base;
    public final int shadow1;
    public final int shadow2;
    public final int oxidizationColor;

    public BasicWaxedBlock(MaterialModel material, Supplier<BiMap<Block, Block>> waxableBlockMap) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 3.0f).m_60999_());
        this.waxableBlockMap = waxableBlockMap;
        this.reverseWaxableBlockMap = Suppliers.memoize(() -> ((BiMap)waxableBlockMap.get()).inverse());
        this.localisedName = material.getLocalizedName();
        this.highlight2 = material.getColors().getHighlightColor(3);
        this.highlight1 = material.getColors().getHighlightColor(1);
        this.base = material.getColors().getMaterialColor();
        this.shadow1 = material.getColors().getShadowColor(1);
        this.shadow2 = material.getColors().getShadowColor(2);
        this.oxidizationColor = material.getColors().getOxidizationColor();
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional<Block> block;
        ItemStack stack = player.m_21120_(hand);
        if ((stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof PaxelItem) && (block = this.getUnwaxed(blockState.m_60734_())).isPresent()) {
            level.m_7731_(pos, block.map(b -> b.m_152465_(blockState)).get(), 11);
            level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, pos, 0);
            stack.m_41774_(0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Optional<Block> getUnwaxed(Block block) {
        return Optional.ofNullable((Block)this.reverseWaxableBlockMap.get().get((Object)block));
    }

    public Supplier<BiMap<Block, Block>> getWaxable() {
        return this.waxableBlockMap;
    }

    public MutableComponent m_49954_() {
        return Component.m_237115_((String)this.localisedName);
    }

    @Override
    public int getHighlight2() {
        return this.highlight2;
    }

    @Override
    public int getHighlight1() {
        return this.highlight1;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getShadow1() {
        return this.shadow1;
    }

    @Override
    public int getShadow2() {
        return this.shadow2;
    }

    public int getOxidizationColor() {
        return this.oxidizationColor;
    }
}

