/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.blocks;

import com.ridanisaurus.emendatusenigmatica.blocks.IColorable;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;

public class BasicBuddingBlock
extends BuddingAmethystBlock
implements IColorable {
    private static final Direction[] DIRECTIONS = Direction.values();
    private final String localisedName;
    public final int highlight2;
    public final int highlight1;
    public final int base;
    public final int shadow1;
    public final int shadow2;
    private final Supplier<Block> small_bud;
    private final Supplier<Block> medium_bud;
    private final Supplier<Block> large_bud;
    private final Supplier<Block> cluster;

    public BasicBuddingBlock(MaterialModel material, Supplier<Block> small_bud, Supplier<Block> medium_bud, Supplier<Block> large_bud, Supplier<Block> cluster) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_164531_).m_60913_(1.5f, 1.5f).m_60977_().m_60999_());
        this.localisedName = material.getLocalizedName();
        this.highlight2 = material.getColors().getHighlightColor(3);
        this.highlight1 = material.getColors().getHighlightColor(1);
        this.base = material.getColors().getMaterialColor();
        this.shadow1 = material.getColors().getShadowColor(1);
        this.shadow2 = material.getColors().getShadowColor(2);
        this.small_bud = small_bud;
        this.medium_bud = medium_bud;
        this.large_bud = large_bud;
        this.cluster = cluster;
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(5) == 0) {
            Direction direction = DIRECTIONS[rand.m_188503_(DIRECTIONS.length)];
            BlockPos blockpos = pos.m_121945_(direction);
            BlockState blockstate = level.m_8055_(blockpos);
            Block block = null;
            if (BasicBuddingBlock.m_152734_((BlockState)blockstate)) {
                block = this.small_bud.get();
            } else if (blockstate.m_60713_(this.small_bud.get()) && blockstate.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
                block = this.medium_bud.get();
            } else if (blockstate.m_60713_(this.medium_bud.get()) && blockstate.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
                block = this.large_bud.get();
            } else if (blockstate.m_60713_(this.large_bud.get()) && blockstate.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
                block = this.cluster.get();
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)AmethystClusterBlock.f_152006_, (Comparable)direction)).m_61124_((Property)AmethystClusterBlock.f_152005_, (Comparable)Boolean.valueOf(blockstate.m_60819_().m_76152_() == Fluids.f_76193_));
                level.m_46597_(blockpos, blockstate1);
            }
        }
    }

    public MutableComponent m_49954_() {
        return Component.m_237115_((String)this.localisedName);
    }

    @Override
    public int getHighlight2() {
        return this.highlight2;
    }

    @Override
    public int getHighlight1() {
        return this.highlight1;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getShadow1() {
        return this.shadow1;
    }

    @Override
    public int getShadow2() {
        return this.shadow2;
    }
}

