/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.api;

import com.google.common.collect.ImmutableList;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.CompatModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmendatusDataRegistry {
    private final Map<String, MaterialModel> materials = new HashMap<String, MaterialModel>();
    private final List<StrataModel> strata = new ArrayList<StrataModel>();
    private final List<CompatModel> compat = new ArrayList<CompatModel>();
    private final Map<String, Integer> strataByIndex = new HashMap<String, Integer>();

    public MaterialModel getMaterialOrRegister(String material, MaterialModel defaultModel) {
        return this.materials.computeIfAbsent(material, s -> defaultModel);
    }

    public void registerStrata(StrataModel strataModel) {
        this.strata.add(strataModel);
        this.strataByIndex.put(strataModel.getFillerType().toString(), this.strata.size() - 1);
    }

    public void registerCompat(CompatModel compatModel) {
        this.compat.add(compatModel);
    }

    public List<MaterialModel> getMaterials() {
        return ImmutableList.copyOf(this.materials.values());
    }

    public List<StrataModel> getStrata() {
        return ImmutableList.copyOf(this.strata);
    }

    public List<CompatModel> getCompat() {
        return ImmutableList.copyOf(this.compat);
    }

    public Map<String, Integer> getStrataByIndex() {
        return this.strataByIndex;
    }
}

