/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica;

import com.ridanisaurus.emendatusenigmatica.config.EEConfig;
import com.ridanisaurus.emendatusenigmatica.datagen.base.DataGeneratorFactory;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EEPackFinder;
import com.ridanisaurus.emendatusenigmatica.loader.EELoader;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.EEDeposits;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.rule.MultiStrataRuleTest;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.data.DataGenerator;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="emendatusenigmatica")
public class EmendatusEnigmatica {
    public static final Logger LOGGER = LogManager.getLogger();
    private static DataGenerator generator;
    private static boolean hasGenerated;
    private static EmendatusEnigmatica instance;
    private final EELoader loader;
    private final EEDeposits deposits;
    public static final CreativeModeTab TAB;

    public static EmendatusEnigmatica getInstance() {
        return instance;
    }

    public EmendatusEnigmatica() {
        instance = this;
        EEConfig.registerClient();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        DataGeneratorFactory.init();
        this.loader = new EELoader();
        this.loader.load();
        EERegistrar.finalize(modEventBus);
        this.deposits = new EEDeposits(this.loader);
        this.deposits.load();
        this.deposits.setup();
        this.deposits.finalize(modEventBus);
        modEventBus.addListener(this::commonEvents);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91099_().addPackFinder((RepositorySource)new EEPackFinder(PackType.CLIENT_RESOURCES)));
        this.loader.finish();
    }

    private void commonEvents(FMLCommonSetupEvent event) {
        MultiStrataRuleTest.register();
    }

    private static void registerDataGen() {
        generator = DataGeneratorFactory.createEEDataGenerator();
        EmendatusEnigmatica.getInstance().getLoader().datagen(generator);
    }

    public static void generate() {
        if (!hasGenerated) {
            try {
                if (generator == null) {
                    EmendatusEnigmatica.registerDataGen();
                }
                generator.m_123917_();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            hasGenerated = true;
        }
    }

    public static void injectDatapackFinder(PackRepository resourcePacks) {
        DistExecutor.unsafeRunForDist(() -> () -> {
            if (resourcePacks != Minecraft.m_91087_().m_91099_()) {
                resourcePacks.addPackFinder((RepositorySource)new EEPackFinder(PackType.CLIENT_RESOURCES));
                LOGGER.info("Injecting data pack finder.");
            }
            return false;
        }, () -> () -> {
            resourcePacks.addPackFinder((RepositorySource)new EEPackFinder(PackType.SERVER_DATA));
            LOGGER.info("Injecting server data pack finder.");
            return false;
        });
    }

    public EELoader getLoader() {
        return this.loader;
    }

    static {
        hasGenerated = false;
        TAB = new CreativeModeTab("emendatusenigmatica"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)EERegistrar.ENIGMATIC_HAMMER.get());
            }
        };
    }
}

