/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.shape;

import dev.ftb.mods.ftbultimine.EntityDistanceComparator;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class ShapelessShape
implements Shape {
    private static final List<BlockPos> NEIGHBOR_POSITIONS;
    private static final List<BlockPos> NEIGHBOR_POSITIONS_PLANT;

    @Override
    public String getName() {
        return "shapeless";
    }

    @Override
    public BlockMatcher getTagMatcher() {
        return BlockMatcher.TAGS_MATCH_SHAPELESS;
    }

    @Override
    public List<BlockPos> getBlocks(ShapeContext context) {
        HashSet<BlockPos> known = new HashSet<BlockPos>();
        this.walk(context, known, context.matcher() == BlockMatcher.BUSH);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(known);
        list.sort(new EntityDistanceComparator(context.pos()));
        if (list.size() > context.maxBlocks()) {
            list.subList(context.maxBlocks(), list.size()).clear();
        }
        return list;
    }

    private void walk(ShapeContext context, HashSet<BlockPos> known, boolean plant) {
        HashSet<BlockPos> traversed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> openSet = new ArrayDeque<BlockPos>();
        openSet.add(context.pos());
        traversed.add(context.pos());
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.pop();
            if (!context.check(ptr) || !known.add(ptr)) continue;
            if (known.size() >= context.maxBlocks()) {
                return;
            }
            for (BlockPos side : plant ? NEIGHBOR_POSITIONS_PLANT : NEIGHBOR_POSITIONS) {
                BlockPos offset = ptr.m_121955_((Vec3i)side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    static {
        int x;
        NEIGHBOR_POSITIONS = new ArrayList<BlockPos>(26);
        NEIGHBOR_POSITIONS_PLANT = new ArrayList<BlockPos>(24);
        for (x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    NEIGHBOR_POSITIONS.add(new BlockPos(x, y, z));
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                NEIGHBOR_POSITIONS_PLANT.add(new BlockPos(x, 0, z));
            }
        }
    }
}

