/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbultimine.FTBUltimineCommands;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.RightClickHandlers;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineCommonConfig;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.integration.FTBUltiminePlugins;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.net.SyncConfigFromServerPacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.LargeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final String MOD_ID = "ftbultimine";
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    public static boolean ranksMod;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;
    public static final TagKey<Item> DENY_TAG;
    public static final TagKey<Item> STRICT_DENY_TAG;
    public static final TagKey<Item> ALLOW_TAG;
    public static final TagKey<Block> EXCLUDED_BLOCKS;
    public static final TagKey<Block> TILLABLE_TAG;
    public static final TagKey<Block> FLATTENABLE_TAG;
    private static Predicate<Player> permissionOverride;

    public static void setPermissionOverride(Predicate<Player> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        FTBUltimineNet.init();
        if (Platform.isModLoaded((String)"ftbranks")) {
            ranksMod = true;
        }
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        FTBUltimineCommonConfig.load();
        FTBUltiminePlugins.init();
        ShapeRegistry.register(new ShapelessShape(), true);
        ShapeRegistry.register(new SmallTunnelShape());
        ShapeRegistry.register(new SmallSquareShape());
        ShapeRegistry.register(new LargeTunnelShape());
        ShapeRegistry.register(new MiningTunnelShape());
        ShapeRegistry.register(new EscapeTunnelShape());
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverStarting);
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
        CommandRegistrationEvent.EVENT.register(FTBUltimineCommands::registerCommands);
    }

    public FTBUltiminePlayerData get(Player player) {
        return this.cachedDataMap.computeIfAbsent(player.m_20148_(), FTBUltiminePlayerData::new);
    }

    private void playerJoined(ServerPlayer serverPlayer) {
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBUltimineServerConfig.CONFIG.write(config);
        new SyncConfigFromServerPacket(config).sendTo(serverPlayer);
    }

    private void serverStarting(MinecraftServer server) {
        ShapeRegistry.freeze();
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        FTBUltimineServerConfig.load(server);
    }

    public void setKeyPressed(ServerPlayer player, boolean pressed) {
        FTBUltiminePlayerData data = this.get((Player)player);
        data.setPressed(pressed);
        data.clearCache();
        if (!data.isPressed()) {
            new SendShapePacket(data.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
        }
    }

    public void modeChanged(ServerPlayer player, boolean next) {
        FTBUltiminePlayerData data = this.get((Player)player);
        data.cycleShape(next);
        data.clearCache();
        new SendShapePacket(data.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
    }

    public static boolean isValidTool(ItemStack mainHand, ItemStack offHand) {
        if (mainHand.m_204117_(STRICT_DENY_TAG) || offHand.m_204117_(STRICT_DENY_TAG) || mainHand.m_204117_(DENY_TAG)) {
            return false;
        }
        if (((Boolean)FTBUltimineServerConfig.REQUIRE_TOOL.get()).booleanValue()) {
            if (mainHand.m_41619_()) {
                return false;
            }
            return mainHand.m_41720_() instanceof TieredItem || mainHand.m_41776_() > 0 || mainHand.m_204117_(ALLOW_TAG);
        }
        return true;
    }

    public boolean canUltimine(Player player) {
        ItemStack offHand;
        if (PlayerHooks.isFake((Player)player) || player.m_20148_() == null) {
            return false;
        }
        if (player.m_36324_().m_38702_() <= 0 && !player.m_7500_()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        ItemStack mainHand = player.m_21205_();
        return FTBUltimine.isValidTool(mainHand, offHand = player.m_21206_()) && FTBUltiminePlugins.canUltimine(player);
    }

    public EventResult blockBroken(Level world, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        if (this.isBreakingBlock || !this.canUltimine((Player)player)) {
            return EventResult.pass();
        }
        FTBUltiminePlayerData data = this.get((Player)player);
        if (!data.isPressed()) {
            return EventResult.pass();
        }
        HitResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockHitResult) || result.m_6662_() != HitResult.Type.BLOCK) {
            return EventResult.pass();
        }
        data.clearCache();
        data.updateBlocks(player, pos, ((BlockHitResult)result).m_82434_(), false, FTBUltimineServerConfig.getMaxBlocks(player));
        if (data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return EventResult.pass();
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.m_21205_().m_41619_();
        float baseSpeed = state.m_60800_((BlockGetter)world, pos);
        for (BlockPos p : data.cachedBlocks) {
            float destroySpeed = world.m_8055_(p).m_60800_((BlockGetter)world, p);
            if (!player.m_7500_() && (destroySpeed < 0.0f || destroySpeed > baseSpeed)) continue;
            if (!player.f_8941_.m_9280_(p) && ((Boolean)FTBUltimineServerConfig.CANCEL_ON_BLOCK_BREAK_FAIL.get()).booleanValue()) break;
            if (!player.m_7500_()) {
                player.m_36399_((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
                if (FTBUltimine.isTooExhausted(player)) break;
            }
            ItemStack stack = player.m_21205_();
            if (!(hadItem && stack.m_41619_() || hadItem && stack.m_41782_() && stack.m_41783_().m_128471_("tic_broken")) && (!hadItem || (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get() <= 0 || !stack.m_41763_() || stack.m_41773_() < stack.m_41776_() - (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get())) continue;
            break;
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.f_19853_, pos);
        if (this.tempBlockDroppedXp > 0) {
            player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        new SendShapePacket(data.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
        return EventResult.interruptFalse();
    }

    public EventResult blockRightClick(Player player, InteractionHand hand, BlockPos clickPos, Direction face) {
        BlockHitResult blockHitResult;
        FTBUltiminePlayerData data;
        ServerPlayer serverPlayer;
        block20: {
            block19: {
                block18: {
                    block17: {
                        if (!(player instanceof ServerPlayer)) break block17;
                        serverPlayer = (ServerPlayer)player;
                        if (!PlayerHooks.isFake((Player)player) && player.m_20148_() != null) break block18;
                    }
                    return EventResult.pass();
                }
                data = this.get(player);
                if (!data.isPressed()) {
                    return EventResult.pass();
                }
                if (player.m_36324_().m_38702_() <= 0 && !player.m_7500_()) {
                    return EventResult.pass();
                }
                HitResult result = FTBUltiminePlayerData.rayTrace(serverPlayer);
                if (!(result instanceof BlockHitResult)) break block19;
                blockHitResult = (BlockHitResult)result;
                if (result.m_6662_() == HitResult.Type.BLOCK) break block20;
            }
            return EventResult.pass();
        }
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, blockHitResult.m_82434_(), false, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
        if (shapeContext == null || !data.isPressed() || data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return EventResult.pass();
        }
        boolean didWork = false;
        if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_HARVESTING.get()).booleanValue() && shapeContext.matcher() == BlockMatcher.BUSH) {
            didWork = RightClickHandlers.cropHarvesting(serverPlayer, hand, clickPos, face, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_HOE.get()).booleanValue() && serverPlayer.m_21120_(hand).m_41720_() instanceof HoeItem) {
            didWork = RightClickHandlers.farmlandConversion(serverPlayer, hand, clickPos, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_AXE.get()).booleanValue() && serverPlayer.m_21120_(hand).m_41720_() instanceof AxeItem) {
            didWork = RightClickHandlers.axeStripping(serverPlayer, hand, clickPos, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_SHOVEL.get()).booleanValue() && serverPlayer.m_21120_(hand).m_41720_() instanceof ShovelItem) {
            didWork = RightClickHandlers.shovelFlattening(serverPlayer, hand, clickPos, data);
        }
        if (didWork) {
            player.m_6674_(hand);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void playerTick(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.get(player).checkBlocks(serverPlayer, true, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
        }
    }

    public EventResult entityJoinedWorld(Entity entity, Level level) {
        if (entity.m_6084_()) {
            if (this.isBreakingBlock && entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                if (!item.m_32055_().m_41619_()) {
                    this.tempBlockDropsList.add(item.m_32055_());
                    item.m_32045_(ItemStack.f_41583_);
                }
                return EventResult.interruptFalse();
            }
            if (this.isBreakingBlock && entity instanceof ExperienceOrb) {
                ExperienceOrb orb = (ExperienceOrb)entity;
                this.tempBlockDroppedXp += orb.m_20801_();
                entity.m_6074_();
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static boolean isTooExhausted(ServerPlayer player) {
        FoodData data = player.m_36324_();
        return data.m_150380_() / 4.0f > data.m_38722_() + (float)data.m_38702_();
    }

    static {
        LOGGER = LogManager.getLogger();
        ranksMod = false;
        DENY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MOD_ID, "excluded_tools"));
        STRICT_DENY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MOD_ID, "excluded_tools/strict"));
        ALLOW_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MOD_ID, "included_tools"));
        EXCLUDED_BLOCKS = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(MOD_ID, "excluded_blocks"));
        TILLABLE_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(MOD_ID, "farmland_tillable"));
        FLATTENABLE_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(MOD_ID, "shovel_flattenable"));
        permissionOverride = player -> true;
    }
}

