/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RepeatingPlacement;

public class Random3DClusterPlacement
extends RepeatingPlacement {
    private final IntProvider count;
    private final boolean allowUnderwater;
    public static final Codec<Random3DClusterPlacement> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)IntProvider.m_146545_((int)0, (int)100000).fieldOf("count").forGetter(nbtFeatureConfig -> nbtFeatureConfig.count), (App)Codec.BOOL.fieldOf("allow_underwater").forGetter(nbtFeatureConfig -> nbtFeatureConfig.allowUnderwater)).apply((Applicative)configInstance, Random3DClusterPlacement::new));

    private Random3DClusterPlacement(IntProvider intProvider, boolean allowUnderwater) {
        this.count = intProvider;
        this.allowUnderwater = allowUnderwater;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)BzPlacements.RANDOM_3D_CLUSTER_PLACEMENT.get();
    }

    protected int m_213944_(RandomSource random, BlockPos blockPos) {
        return this.count.m_214085_(random);
    }

    public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int chunkNum = 0; chunkNum <= this.m_213944_(random, blockPos); ++chunkNum) {
            int attempts;
            for (attempts = 0; attempts < 8; ++attempts) {
                mutableBlockPos.m_122178_(blockPos.m_123341_(), 0, blockPos.m_123343_()).m_122184_(random.m_188503_(4) + 8, random.m_188503_(253) + 1, random.m_188503_(4) + 8);
                BlockState state = placementContext.m_191828_((BlockPos)mutableBlockPos);
                if (!state.m_60795_() && (!this.allowUnderwater || state.m_60819_().m_205070_(FluidTags.f_13131_))) continue;
                mutableBlockPos.m_122178_(blockPos.m_123341_(), mutableBlockPos.m_123342_(), blockPos.m_123343_());
                break;
            }
            if (attempts == 8) continue;
            int maxRadius = 8;
            for (int x = 0; x <= maxRadius; ++x) {
                for (int z = 0; z <= maxRadius; ++z) {
                    for (int y = 0; y <= maxRadius; ++y) {
                        float manhattenDistance = Math.abs(x) + Math.abs(y) + Math.abs(z);
                        if (!(manhattenDistance <= 12.0f) || !(random.m_188501_() <= ((float)maxRadius - manhattenDistance / 1.5f) / (float)maxRadius)) continue;
                        blockPosList.add(mutableBlockPos.m_7918_(x + 8, y + 8, z + 8));
                    }
                }
            }
        }
        return blockPosList.stream();
    }
}

