/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseChunkAccessor;
import com.telepathicgrunt.the_bumblezone.world.dimension.BiomeInfluencedNoiseSampler;
import com.telepathicgrunt.the_bumblezone.world.dimension.BiomeRegistryHolder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.mutable.MutableObject;

public class BzChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<BzChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(bzChunkGenerator -> bzChunkGenerator.f_207955_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(bzChunkGenerator -> bzChunkGenerator.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(bzChunkGenerator -> bzChunkGenerator.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(bzChunkGenerator -> bzChunkGenerator.settings)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    protected final BlockState f_64316_;
    protected final BlockState defaultFluid;
    private final Registry<NormalNoise.NoiseParameters> noises;
    private final Holder<NoiseGeneratorSettings> settings;
    private final Aquifer.FluidPicker globalFluidPicker;

    public BzChunkGenerator(Registry<StructureSet> structureSetRegistry, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, Holder<NoiseGeneratorSettings> supplier) {
        super(structureSetRegistry, noises, biomeSource, supplier);
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)supplier.m_203334_();
        this.f_64316_ = noiseGeneratorSettings.f_64440_();
        this.defaultFluid = noiseGeneratorSettings.f_64441_();
        NoiseRouter noiseRouter = noiseGeneratorSettings.f_209353_();
        this.noises = noises;
        BiomeNoise.biomeSource = this.m_62218_();
        BiomeNoise.sampler = new Climate.Sampler(noiseRouter.f_209384_(), noiseRouter.f_224392_(), noiseRouter.f_209386_(), noiseRouter.f_209387_(), noiseRouter.f_209388_(), noiseRouter.f_209389_(), noiseGeneratorSettings.f_224370_());
        this.settings = supplier;
        int seaLevel = noiseGeneratorSettings.f_64444_();
        Aquifer.FluidStatus sea = new Aquifer.FluidStatus(seaLevel, noiseGeneratorSettings.f_64441_());
        this.globalFluidPicker = (x, y, z) -> sea;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public CompletableFuture<ChunkAccess> m_213908_(Registry<Biome> biomeRegistry, Executor executor, RandomState randomState, Blender blender, StructureManager structureManager, ChunkAccess chunkAccess) {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"init_biomes", () -> {
            this.doCreateBiomes(blender, randomState, structureManager, chunkAccess);
            return chunkAccess;
        }), Util.m_183991_());
    }

    private void doCreateBiomes(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        NoiseChunk noisechunk = chunkAccess.m_223012_(p_224340_ -> this.createNoiseChunk((ChunkAccess)p_224340_, structureManager, blender, randomState));
        BiomeResolver biomeresolver = BelowZeroRetrogen.m_204531_((BiomeResolver)blender.m_183383_((BiomeResolver)this.f_62137_), (ChunkAccess)chunkAccess);
        chunkAccess.m_183442_(biomeresolver, ((NoiseChunkAccessor)noisechunk).callCachedClimateSampler(randomState.m_224578_(), ((NoiseGeneratorSettings)this.settings.get()).f_224370_()));
    }

    private NoiseChunk createNoiseChunk(ChunkAccess chunkAccess, StructureManager structureManager, Blender blender, RandomState randomState) {
        return NoiseChunk.m_224352_((ChunkAccess)chunkAccess, (RandomState)randomState, (DensityFunctions.BeardifierOrMarker)Beardifier.m_223937_((StructureManager)structureManager, (ChunkPos)chunkAccess.m_7697_()), (NoiseGeneratorSettings)((NoiseGeneratorSettings)this.settings.get()), (Aquifer.FluidPicker)this.globalFluidPicker, (Blender)blender);
    }

    public int m_214096_(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return this.m_224239_(levelHeightAccessor, randomState, x, z, null, types.m_64299_()).orElse(levelHeightAccessor.m_141937_());
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        MutableObject mutableobject = new MutableObject();
        this.m_224239_(levelHeightAccessor, randomState, x, z, (MutableObject<NoiseColumn>)mutableobject, null);
        return (NoiseColumn)mutableobject.getValue();
    }

    public void m_213600_(List<String> strings, RandomState randomState, BlockPos blockPos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        NoiseRouter noiserouter = randomState.m_224578_();
        DensityFunction.SinglePointContext densityfunction$singlepointcontext = new DensityFunction.SinglePointContext(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        double d0 = noiserouter.f_209389_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext);
        strings.add("NoiseRouter T: " + decimalformat.format(noiserouter.f_209384_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " V: " + decimalformat.format(noiserouter.f_224392_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " C: " + decimalformat.format(noiserouter.f_209386_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " E: " + decimalformat.format(noiserouter.f_209387_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " D: " + decimalformat.format(noiserouter.f_209388_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(NoiseRouterData.m_224435_((float)((float)d0))) + " AS: " + decimalformat.format(noiserouter.f_209390_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " N: " + decimalformat.format(noiserouter.f_209391_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)));
    }

    protected OptionalInt m_224239_(LevelHeightAccessor levelHeightAccessor, RandomState randomState, int x, int z, MutableObject<NoiseColumn> mutableObject, Predicate<BlockState> blockStatePredicate) {
        NoiseSettings noisesettings = ((NoiseGeneratorSettings)this.settings.get()).f_64439_().m_224530_(levelHeightAccessor);
        int i = noisesettings.m_189212_();
        int j = noisesettings.f_158688_();
        int k = Mth.m_14042_((int)j, (int)i);
        int l = Mth.m_14042_((int)noisesettings.f_64508_(), (int)i);
        if (l > 0) {
            BlockState[] ablockstate;
            if (mutableObject == null) {
                ablockstate = null;
            } else {
                ablockstate = new BlockState[noisesettings.f_64508_()];
                mutableObject.setValue((Object)new NoiseColumn(j, ablockstate));
            }
            int i1 = noisesettings.m_189213_();
            int j1 = Math.floorDiv(x, i1);
            int k1 = Math.floorDiv(z, i1);
            int l1 = Math.floorMod(x, i1);
            int i2 = Math.floorMod(z, i1);
            int j2 = j1 * i1;
            int k2 = k1 * i1;
            double d0 = (double)l1 / (double)i1;
            double d1 = (double)i2 / (double)i1;
            NoiseChunk noiseChunk = new NoiseChunk(1, randomState, j2, k2, noisesettings, (DensityFunctions.BeardifierOrMarker)DensityFunctions.BeardifierMarker.INSTANCE, (NoiseGeneratorSettings)this.settings.get(), this.globalFluidPicker, Blender.m_190153_());
            noiseChunk.m_188791_();
            noiseChunk.m_188749_(0);
            for (int l2 = l - 1; l2 >= 0; --l2) {
                noiseChunk.m_188810_(l2, 0);
                for (int i3 = i - 1; i3 >= 0; --i3) {
                    BlockState blockstate1;
                    int j3 = (k + l2) * i + i3;
                    double d2 = (double)i3 / (double)i;
                    noiseChunk.m_209191_(j3, d2);
                    noiseChunk.m_209230_(x, d0);
                    noiseChunk.m_209241_(z, d1);
                    BlockState blockstate = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                    BlockState blockState = blockstate1 = blockstate == null ? this.f_64316_ : blockstate;
                    if (ablockstate != null) {
                        int k3 = l2 * i + i3;
                        ablockstate[k3] = blockstate1;
                    }
                    if (blockStatePredicate == null || !blockStatePredicate.test(blockstate1)) continue;
                    noiseChunk.m_209248_();
                    return OptionalInt.of(j3 + 1);
                }
            }
            noiseChunk.m_209248_();
        }
        return OptionalInt.empty();
    }

    public void m_214194_(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess) {
        BiomeManager biomeManager;
        WorldGenerationContext worldgenerationcontext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)worldGenRegion);
        BiomeSource biomeSource = this.f_62137_;
        if (biomeSource instanceof BiomeManager.NoiseBiomeSource) {
            BiomeManager.NoiseBiomeSource noiseBiomeSource = (BiomeManager.NoiseBiomeSource)biomeSource;
            biomeManager = new BiomeManager(noiseBiomeSource, worldGenRegion.m_7328_());
        } else {
            biomeManager = worldGenRegion.m_7062_();
        }
        this.m_224261_(chunkAccess, worldgenerationcontext, randomState, structureManager, biomeManager, (Registry<Biome>)worldGenRegion.m_5962_().m_175515_(Registry.f_122885_), Blender.m_190202_((WorldGenRegion)worldGenRegion));
    }

    public void m_224261_(ChunkAccess chunkAccess, WorldGenerationContext worldGenerationContext, RandomState randomState, StructureManager structureManager, BiomeManager biomeManager, Registry<Biome> biomeRegistry, Blender blender) {
        NoiseChunk noisechunk = chunkAccess.m_223012_(noiseChunk -> this.createNoiseChunk((ChunkAccess)noiseChunk, structureManager, blender, randomState));
        NoiseGeneratorSettings noisegeneratorsettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        randomState.m_224580_().m_224648_(randomState, biomeManager, biomeRegistry, noisegeneratorsettings.f_209354_(), worldGenerationContext, chunkAccess, noisechunk, noisegeneratorsettings.f_188871_());
    }

    public void m_213679_(WorldGenRegion worldGenRegion, long seed, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        NoiseSettings noisesettings = ((NoiseGeneratorSettings)this.settings.get()).f_64439_().m_224530_(chunkAccess.m_183618_());
        int i = noisesettings.f_158688_();
        int j = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int k = Mth.m_14042_((int)noisesettings.f_64508_(), (int)noisesettings.m_189212_());
        if (k <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int l = chunkAccess.m_151564_(k * noisesettings.m_189212_() - 1 + i);
        int i1 = chunkAccess.m_151564_(i);
        HashSet set = Sets.newHashSet();
        for (int j1 = l; j1 >= i1; --j1) {
            LevelChunkSection levelchunksection = chunkAccess.m_183278_(j1);
            levelchunksection.m_62981_();
            set.add(levelchunksection);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"wgen_fill_noise", () -> this.doFill(blender, structureManager, randomState, chunkAccess, j, k)), Util.m_183991_()).whenCompleteAsync((p_224309_, p_224310_) -> {
            for (LevelChunkSection levelchunksection1 : set) {
                levelchunksection1.m_63006_();
            }
        }, executor);
    }

    private ChunkAccess doFill(Blender blender, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess, int x, int z) {
        NoiseChunk noiseChunk = chunkAccess.m_223012_(chunkAccess1 -> this.createNoiseChunk((ChunkAccess)chunkAccess1, structureManager, blender, randomState));
        Heightmap heightmap = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = chunkAccess.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        Aquifer aquifer = noiseChunk.m_188817_();
        noiseChunk.m_188791_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = ((NoiseGeneratorSettings)this.settings.get()).f_64439_().m_189213_();
        int l = ((NoiseGeneratorSettings)this.settings.get()).f_64439_().m_189212_();
        int i1 = 16 / k;
        int j1 = 16 / k;
        for (int k1 = 0; k1 < i1; ++k1) {
            noiseChunk.m_188749_(k1);
            for (int l1 = 0; l1 < j1; ++l1) {
                LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151559_() - 1);
                for (int i2 = z - 1; i2 >= 0; --i2) {
                    noiseChunk.m_188810_(i2, l1);
                    for (int j2 = l - 1; j2 >= 0; --j2) {
                        int k2 = (x + i2) * l + j2;
                        int l2 = k2 & 0xF;
                        int i3 = chunkAccess.m_151564_(k2);
                        if (chunkAccess.m_151564_(levelchunksection.m_63017_()) != i3) {
                            levelchunksection = chunkAccess.m_183278_(i3);
                        }
                        double d0 = (double)j2 / (double)l;
                        noiseChunk.m_209191_(k2, d0);
                        for (int j3 = 0; j3 < k; ++j3) {
                            int k3 = i + k1 * k + j3;
                            int l3 = k3 & 0xF;
                            double d1 = (double)j3 / (double)k;
                            noiseChunk.m_209230_(k3, d1);
                            for (int i4 = 0; i4 < k; ++i4) {
                                int j4 = j + l1 * k + i4;
                                int k4 = j4 & 0xF;
                                double d2 = (double)i4 / (double)k;
                                noiseChunk.m_209241_(j4, d2);
                                BlockState blockstate = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                                if (blockstate == null) {
                                    blockstate = this.f_64316_;
                                }
                                if (blockstate == Blocks.f_50016_.m_49966_()) continue;
                                if (blockstate.m_60791_() != 0 && chunkAccess instanceof ProtoChunk) {
                                    blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                    ((ProtoChunk)chunkAccess).m_63277_((BlockPos)blockpos$mutableblockpos);
                                }
                                levelchunksection.m_62991_(l3, l2, k4, blockstate, false);
                                heightmap.m_64249_(l3, k2, k4, blockstate);
                                heightmap1.m_64249_(l3, k2, k4, blockstate);
                                if (!aquifer.m_142203_() || blockstate.m_60819_().m_76178_()) continue;
                                blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                chunkAccess.m_8113_((BlockPos)blockpos$mutableblockpos);
                            }
                        }
                    }
                }
            }
            noiseChunk.m_188804_();
        }
        noiseChunk.m_209248_();
        return chunkAccess;
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.settings.get()).f_64439_().f_64508_();
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.settings.get()).f_64444_();
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.settings.get()).f_64439_().f_158688_();
    }

    public Holder<NoiseGeneratorSettings> m_224341_() {
        return this.settings;
    }

    public void m_6929_(WorldGenRegion region) {
        if (!((NoiseGeneratorSettings)this.settings.m_203334_()).f_64445_()) {
            ChunkPos chunkpos = region.m_143488_();
            Holder holder = region.m_204166_(chunkpos.m_45615_().m_175288_(region.m_151558_() - 1));
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_224599_()));
            worldgenrandom.m_64690_(region.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
            BzChunkGenerator.spawnNonBeeMobsForChunkGeneration((ServerLevelAccessor)region, (Holder<Biome>)holder, chunkpos, (RandomSource)worldgenrandom);
        }
    }

    public static void spawnNonBeeMobsForChunkGeneration(ServerLevelAccessor serverLevelAccessor, Holder<Biome> biomeHolder, ChunkPos chunkPos, RandomSource randomSource) {
        MobSpawnSettings mobspawnsettings = ((Biome)biomeHolder.m_203334_()).m_47518_();
        WeightedRandomList weightedrandomlist = mobspawnsettings.m_151798_(MobCategory.CREATURE);
        if (!(weightedrandomlist = WeightedRandomList.m_146328_(weightedrandomlist.m_146338_().stream().filter(e -> e.f_48404_ != EntityType.f_20550_).toList())).m_146337_()) {
            int i = chunkPos.m_45604_();
            int j = chunkPos.m_45605_();
            int seaLevel = ((ServerChunkCache)serverLevelAccessor.m_7726_()).m_8481_().m_6337_();
            while ((double)randomSource.m_188501_() < (double)mobspawnsettings.m_48344_() * 0.5) {
                Optional optional = weightedrandomlist.m_216829_(randomSource);
                if (!optional.isPresent()) continue;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = (MobSpawnSettings.SpawnerData)optional.get();
                int k = mobspawnsettings$spawnerdata.f_48405_ + randomSource.m_188503_(1 + mobspawnsettings$spawnerdata.f_48406_ - mobspawnsettings$spawnerdata.f_48405_);
                SpawnGroupData spawngroupdata = null;
                int x = i + randomSource.m_188503_(16);
                int z = j + randomSource.m_188503_(16);
                int j1 = x;
                int k1 = z;
                for (int l1 = 0; l1 < k; ++l1) {
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, randomSource.m_188503_(250 - seaLevel) + seaLevel, z);
                    if (serverLevelAccessor.m_6042_().f_63856_()) {
                        do {
                            mutableBlockPos.m_122173_(Direction.DOWN);
                        } while (!serverLevelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60795_());
                        do {
                            mutableBlockPos.m_122173_(Direction.DOWN);
                        } while (serverLevelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60795_() && mutableBlockPos.m_123342_() > serverLevelAccessor.m_141937_());
                    }
                    if (mobspawnsettings$spawnerdata.f_48404_.m_20654_()) {
                        Entity entity;
                        float f = mobspawnsettings$spawnerdata.f_48404_.m_20678_();
                        double finalX = Math.floor(Mth.m_14008_((double)x, (double)((double)i + (double)f), (double)((double)i + 16.0 - (double)f))) + 0.5;
                        double finalZ = Math.floor(Mth.m_14008_((double)z, (double)((double)j + (double)f), (double)((double)j + 16.0 - (double)f))) + 0.5;
                        if (!serverLevelAccessor.m_6857_().m_156093_(finalX, finalZ) || mutableBlockPos.m_123342_() < serverLevelAccessor.m_141937_() || mutableBlockPos.m_123342_() >= serverLevelAccessor.m_151558_()) continue;
                        try {
                            entity = mobspawnsettings$spawnerdata.f_48404_.m_20615_((Level)serverLevelAccessor.m_6018_());
                        }
                        catch (Exception exception) {
                            Bumblezone.LOGGER.warn("Failed to create mob", (Throwable)exception);
                            continue;
                        }
                        entity.m_7678_(finalX, (double)mutableBlockPos.m_123342_(), finalZ, randomSource.m_188501_() * 360.0f, 0.0f);
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            if (ForgeHooks.canEntitySpawn((Mob)mob, (LevelAccessor)serverLevelAccessor, (double)finalX, (double)mutableBlockPos.m_123342_(), (double)finalZ, null, (MobSpawnType)MobSpawnType.CHUNK_GENERATION) == -1) continue;
                            if (mob.m_6914_((LevelReader)serverLevelAccessor)) {
                                spawngroupdata = mob.m_6518_(serverLevelAccessor, serverLevelAccessor.m_6436_(mob.m_20183_()), MobSpawnType.CHUNK_GENERATION, spawngroupdata, null);
                                mob.m_6027_(mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_());
                                serverLevelAccessor.m_47205_((Entity)mob);
                            }
                        }
                    }
                    x += randomSource.m_188503_(5) - randomSource.m_188503_(5);
                    z += randomSource.m_188503_(5) - randomSource.m_188503_(5);
                    while (x < i || x >= i + 16 || z < j || z >= j + 16) {
                        x = j1 + randomSource.m_188503_(5) - randomSource.m_188503_(5);
                        z = k1 + randomSource.m_188503_(5) - randomSource.m_188503_(5);
                    }
                }
            }
        }
    }

    public record BiomeNoise() implements DensityFunction.SimpleFunction
    {
        public static final KeyDispatchDataCodec<BiomeNoise> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)new BiomeNoise()));
        public static Climate.Sampler sampler;
        public static BiomeSource biomeSource;

        public double m_207386_(DensityFunction.FunctionContext functionContext) {
            return BiomeInfluencedNoiseSampler.calculateBaseNoise(functionContext.m_207115_(), functionContext.m_207113_(), sampler, biomeSource, BiomeRegistryHolder.BIOME_REGISTRY);
        }

        public double m_207402_() {
            return -10.0;
        }

        public double m_207401_() {
            return 10.0;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC;
        }
    }
}

