/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.items.functions.PrefillMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;

public class ThreadExecutor {
    private static ExecutorService LOCATING_EXECUTOR_SERVICE = null;
    private static final AtomicInteger runningSearches = new AtomicInteger(0);
    private static final AtomicInteger queuedSearches = new AtomicInteger(0);

    public static void setupExecutorService() {
        ThreadExecutor.shutdownExecutorService();
        LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(3, new ThreadFactory(){
            private static final AtomicInteger poolNum = new AtomicInteger(1);
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "bumblezone_locator_and_teleportation-" + poolNum.getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(Runnable r) {
                return new Thread((ThreadGroup)SidedThreadGroups.SERVER, r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    private static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    public static void handleServerStoppingEvent(ServerStoppingEvent ignoredEvent) {
        ThreadExecutor.shutdownExecutorService();
    }

    public static boolean isRunningASearch() {
        return runningSearches.get() > 0;
    }

    public static boolean hasQueuedSearch() {
        return queuedSearches.get() > 0;
    }

    public static LocateTask<BlockPos> locate(ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        queuedSearches.getAndIncrement();
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                runningSearches.getAndIncrement();
                queuedSearches.getAndDecrement();
                ThreadExecutor.doLocateLevel(completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread structure locating crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<BlockPos>(level.m_7654_(), completableFuture, future);
    }

    public static LocateTask<Optional<Vec3>> dimensionDestinationSearch(MinecraftServer minecraftServer, Supplier<Optional<Vec3>> searchFunction) {
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                completableFuture.complete((Optional)searchFunction.get());
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread teleport destination search crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<Optional<Vec3>>(minecraftServer, completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<BlockPos> completableFuture, ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        BlockPos foundPos = level.m_215011_(structureTag, pos, searchRadius, skipExistingChunks);
        completableFuture.complete(foundPos);
        runningSearches.getAndDecrement();
    }

    public static void mapFilling(ServerLevel level, BlockPos pos, MapItemSavedData data) {
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                PrefillMap.update((Level)level, pos, data);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread map filling crashed. Exception is: ", (Throwable)e);
            }
        });
        new LocateTask(level.m_7654_(), completableFuture, future);
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.m_18707_(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

