/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GeneralUtils {
    private static int ACTIVE_ENTITIES = 0;
    private static final Set<Bee> BEE_SET = new HashSet<Bee>();
    public static final List<BlockState> VANILLA_CANDLES = ImmutableList.of((Object)Blocks.f_152482_.m_49966_(), (Object)Blocks.f_152518_.m_49966_(), (Object)Blocks.f_152524_.m_49966_(), (Object)Blocks.f_152520_.m_49966_(), (Object)Blocks.f_152521_.m_49966_(), (Object)Blocks.f_152516_.m_49966_(), (Object)Blocks.f_152522_.m_49966_(), (Object)Blocks.f_152512_.m_49966_(), (Object)Blocks.f_152517_.m_49966_(), (Object)Blocks.f_152514_.m_49966_(), (Object)Blocks.f_152511_.m_49966_(), (Object)Blocks.f_152484_.m_49966_(), (Object[])new BlockState[]{Blocks.f_152515_.m_49966_(), Blocks.f_152519_.m_49966_(), Blocks.f_152523_.m_49966_(), Blocks.f_152483_.m_49966_(), Blocks.f_152513_.m_49966_()});

    public static void updateEntityCount(ServerLevel world) {
        BEE_SET.clear();
        int counter = 0;
        for (Entity entity : world.m_8583_()) {
            if (entity.m_6084_() && entity instanceof LivingEntity) {
                ++counter;
            }
            if (!(entity instanceof Bee)) continue;
            BEE_SET.add((Bee)entity);
        }
        ACTIVE_ENTITIES = counter;
        BEE_SET.removeIf(bee -> bee.m_21532_() || bee.m_27854_() || bee.m_8077_() || bee.m_21523_() || bee.m_20160_());
    }

    public static int getNearbyActiveEntitiesInDimension(ServerLevel level, BlockPos position) {
        if (level.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            return ACTIVE_ENTITIES;
        }
        return level.m_45976_(Bee.class, new AABB(position.m_7918_(-16, -16, -16), position.m_7918_(16, 16, 16))).size();
    }

    public static void adjustEntityCountInBz(int adjust) {
        ACTIVE_ENTITIES += adjust;
    }

    public static Set<Bee> getAllWildBees() {
        return BEE_SET;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, RandomSource random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.m_188501_() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static BlockPos getRandomBlockposWithinRange(LivingEntity entity, int maxRadius, int minRadius) {
        BlockPos newBeePos = new BlockPos(entity.m_20185_() + (double)((entity.m_217043_().m_188503_(maxRadius) + minRadius) * (entity.m_217043_().m_188499_() ? 1 : -1)), Doubles.constrainToRange((double)(entity.m_20186_() + (double)((entity.m_217043_().m_188503_(maxRadius) + minRadius) * (entity.m_217043_().m_188499_() ? 1 : -1))), (double)1.0, (double)254.0), entity.m_20189_() + (double)((entity.m_217043_().m_188503_(maxRadius) + minRadius) * (entity.m_217043_().m_188499_() ? 1 : -1)));
        return newBeePos;
    }

    public static void givePlayerItem(Player playerEntity, InteractionHand hand, ItemStack itemstackToGive, boolean giveContainerItem, boolean shrinkCurrentItem) {
        ItemStack playerItem = playerEntity.m_21120_(hand);
        ItemStack copiedPlayerItem = playerItem.m_41777_();
        if (shrinkCurrentItem) {
            playerItem.m_41774_(1);
        }
        if (!itemstackToGive.m_41619_()) {
            if (playerItem.m_41619_()) {
                playerEntity.m_21008_(hand, itemstackToGive);
            } else if (!playerEntity.m_150109_().m_36054_(itemstackToGive)) {
                playerEntity.m_36176_(itemstackToGive, false);
            }
        }
        if (giveContainerItem && copiedPlayerItem.hasCraftingRemainingItem()) {
            ItemStack containerItem = copiedPlayerItem.getCraftingRemainingItem();
            if (playerEntity.m_21120_(hand).m_41619_()) {
                playerEntity.m_21008_(hand, containerItem);
            } else if (!playerEntity.m_150109_().m_36054_(containerItem)) {
                playerEntity.m_36176_(containerItem, false);
            }
        }
    }

    public static boolean canJigsawsAttach(StructureTemplate.StructureBlockInfo jigsaw1, StructureTemplate.StructureBlockInfo jigsaw2) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.f_74676_.m_61143_((Property)JigsawBlock.f_54222_);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.f_74676_.m_61143_((Property)JigsawBlock.f_54222_);
        String joint = jigsaw1.f_74677_.m_128461_("joint");
        if (joint.isEmpty()) {
            joint = prop1.m_122625_().m_122434_().m_122479_() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.m_122625_() == prop2.m_122625_().m_122424_() && (isRollable || prop1.m_122629_() == prop2.m_122629_()) && jigsaw1.f_74677_.m_128461_("target").equals(jigsaw2.f_74677_.m_128461_("name"));
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        ChunkAccess currentChunk = worldView.m_46865_((BlockPos)mutable);
        BlockState currentState = currentChunk.m_8055_((BlockPos)mutable);
        while (mutable.m_123342_() >= worldView.m_141937_() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.m_122173_(Direction.DOWN);
            currentState = currentChunk.m_8055_((BlockPos)mutable);
        }
        return mutable.m_123342_();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60767_().m_76332_() || blockState.m_60767_().m_76336_() || blockState.m_60713_((Block)BzBlocks.HONEY_CRYSTAL.get());
    }

    public static BlockPos getLowestLand(ChunkGenerator chunkGenerator, RandomState randomState, BlockPos centerPos, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid, boolean canBeInLiquid) {
        BlockState currentBlockstate;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(centerPos.m_123341_(), 1, centerPos.m_123343_());
        NoiseColumn blockView = chunkGenerator.m_214184_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView, randomState);
        BlockState pastBlockstate = currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        while (mutable.m_123342_() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator)) {
            if (canBeInLiquid && !currentBlockstate.m_60819_().m_76178_()) {
                mutable.m_122173_(Direction.UP);
                return mutable;
            }
            if ((canBeOnLiquid || !pastBlockstate.m_60819_().m_76178_()) && currentBlockstate.m_60795_()) {
                mutable.m_122173_(Direction.UP);
                return mutable;
            }
            mutable.m_122173_(Direction.UP);
            pastBlockstate = currentBlockstate;
            currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        }
        return mutable;
    }

    public static int getMaxTerrainLimit(ChunkGenerator chunkGenerator) {
        return chunkGenerator.m_142062_() + chunkGenerator.m_6331_();
    }

    public static void spawnItemEntity(ServerLevel serverLevel, BlockPos blockPos, ItemStack itemToSpawn, double randomXZSpeed, double ySpeed) {
        if (!itemToSpawn.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.5, itemToSpawn);
            itemEntity.m_20256_(new Vec3(serverLevel.f_46441_.m_188583_() * randomXZSpeed, ySpeed, serverLevel.f_46441_.m_188583_() * randomXZSpeed));
            itemEntity.m_32060_();
            serverLevel.m_7967_((Entity)itemEntity);
        }
    }

    public static void centerAllPieces(BlockPos targetPos, List<? extends StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        BlockPos structureCenter = pieces.get(0).m_73547_().m_162394_();
        int xOffset = targetPos.m_123341_() - structureCenter.m_123341_();
        int zOffset = targetPos.m_123343_() - structureCenter.m_123343_();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.m_6324_(xOffset, 0, zOffset);
        }
    }

    public static List<Block> getListOfNonDummyBlocks(Optional<HolderSet.Named<Block>> blockTagResult) {
        return blockTagResult.map(holders -> holders.m_203614_().map(Holder::m_203334_).filter(block -> !block.m_49966_().m_60795_() && !block.getClass().getName().endsWith("BlockDummyAir")).toList()).orElseGet(ArrayList::new);
    }

    public static int split(int value, boolean upper) {
        return upper ? value >> 16 : value & 0xFFFF;
    }

    public static int merge(int upper, int lower) {
        return (upper << 16) + (lower & 0xFFFF);
    }

    public static class BasicItemTrade
    implements VillagerTrades.ItemListing {
        private final Item itemToTrade;
        private final Item itemToReceive;
        private final int amountToGive;
        private final int amountToReceive;
        protected final int maxUses;
        protected final int experience;
        protected final float multiplier;

        public BasicItemTrade(Item itemToTrade, Item itemToReceive, int amountToGive, int amountToReceive) {
            this(itemToReceive, itemToTrade, amountToGive, amountToReceive, 20, 2, 0.05f);
        }

        public BasicItemTrade(Item itemToTrade, Item itemToReceive, int amountToGive, int amountToReceive, int maxUses, int experience, float multiplier) {
            this.itemToTrade = itemToTrade;
            this.itemToReceive = itemToReceive;
            this.amountToGive = amountToGive;
            this.amountToReceive = amountToReceive;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack in = new ItemStack((ItemLike)this.itemToTrade, this.amountToGive);
            ItemStack out = new ItemStack((ItemLike)this.itemToReceive, this.amountToReceive);
            return new MerchantOffer(in, out, this.maxUses, this.experience, this.multiplier);
        }
    }

    public static final class Lazy<T> {
        private volatile T value;

        public T getOrCompute(Supplier<T> supplier) {
            T result = this.value;
            return result == null ? this.maybeCompute(supplier) : result;
        }

        private synchronized T maybeCompute(Supplier<T> supplier) {
            if (this.value == null) {
                this.value = Objects.requireNonNull(supplier.get());
            }
            return this.value;
        }
    }
}

