/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerMenu;
import com.telepathicgrunt.the_bumblezone.screens.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class CrystallineFlowerScreen
extends AbstractContainerScreen<CrystallineFlowerMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("the_bumblezone", "textures/gui/container/crystallized_flower.png");
    private static final Pattern SPLIT_WITH_COMBINING_CHARS = Pattern.compile("(\\p{M}+|\\P{M}\\p{M}*)");
    private static final int MENU_HEIGHT = 126;
    private static final int INVENTORY_LABEL_Y_OFFSET = -60;
    private static final int TITLE_LABEL_Y_OFFSET = -1;
    private static final int ENCHANTMENT_AREA_X_OFFSET = 76;
    private static final int ENCHANTMENT_AREA_Y_OFFSET = 52;
    private static final int ENCHANTMENT_SECTION_WIDTH = 88;
    private static final int ENCHANTMENT_SECTION_HEIGHT = 19;
    private static final int ENCHANTMENT_SCROLLBAR_X_OFFSET = 164;
    private static final int ENCHANTMENT_SCROLLBAR_Y_OFFSET = 50;
    private static final int ENCHANTMENT_SCROLLBAR_Y_RANGE = 50;
    private static final float ENCHANTMENT_SCROLLBAR_U_TEXTURE = 230.0f;
    private static final float ENCHANTMENT_SCROLLBAR_V_TEXTURE = 182.0f;
    private static final float ENCHANTMENT_SELECTED_U_TEXTURE = 0.0f;
    private static final float ENCHANTMENT_SELECTED_V_TEXTURE = 197.0f;
    private static final float ENCHANTMENT_UNSELECTED_U_TEXTURE = 0.0f;
    private static final float ENCHANTMENT_UNSELECTED_V_TEXTURE = 216.0f;
    private static final float ENCHANTMENT_HIGHLIGHTED_U_TEXTURE = 0.0f;
    private static final float ENCHANTMENT_HIGHLIGHTED_V_TEXTURE = 235.0f;
    private static final int XP_BAR_X_OFFSET = 11;
    private static final int XP_BAR_Y_OFFSET = 99;
    private static final float XP_BAR_U_TEXTURE = 176.0f;
    private static final float XP_BAR_V_TEXTURE = 187.0f;
    private static final int XP_CONSUME_1_X_OFFSET = 46;
    private static final int XP_CONSUME_1_Y_OFFSET = 14;
    private static final int XP_CONSUME_2_X_OFFSET = 46;
    private static final int XP_CONSUME_2_Y_OFFSET = 34;
    private static final int XP_CONSUME_3_X_OFFSET = 46;
    private static final int XP_CONSUME_3_Y_OFFSET = 54;
    private static final float XP_CONSUME_1_U_OFFSET = 108.0f;
    private static final float XP_CONSUME_1_V_OFFSET = 197.0f;
    private static final float XP_CONSUME_2_U_OFFSET = 126.0f;
    private static final float XP_CONSUME_2_V_OFFSET = 197.0f;
    private static final float XP_CONSUME_3_U_OFFSET = 144.0f;
    private static final float XP_CONSUME_3_V_OFFSET = 197.0f;
    private static final int CONSUME_CONFIRMATION_X_OFFSET = 25;
    private static final int CONSUME_CONFIRMATION_Y_OFFSET = 62;
    private static final float CONSUME_CONFIRMATION_U_OFFSET = 162.0f;
    private static final float CONSUME_CONFIRMATION_V_OFFSET = 197.0f;
    private static final int CONSUME_ARROW_X_OFFSET = 26;
    private static final int CONSUME_ARROW_Y_OFFSET = 82;
    private static final float CONSUME_ARROW_U_OFFSET = 180.0f;
    private static final float CONSUME_ARROW_V_OFFSET = 197.0f;
    private static final int TIER_X_OFFSET = 11;
    private static final int TIER_Y_OFFSET = 15;
    private static final float TIER_FLOWER_U_TEXTURE = 195.0f;
    private static final float TIER_FLOWER_V_TEXTURE = 197.0f;
    private static final float TIER_BODY_U_TEXTURE = 195.0f;
    private static final float TIER_BODY_V_TEXTURE = 207.0f;
    private static final float TIER_BLOCK_U_TEXTURE = 195.0f;
    private static final float TIER_BLOCK_V_TEXTURE = 217.0f;
    private static final int BUTTON_PRESSED_TIMER_VISUAL = 25;
    private float scrollOff;
    private boolean scrolling;
    private int startIndex;
    private int pressedXp1Timer = 0;
    private int pressedXp2Timer = 0;
    private int pressedXp3Timer = 0;
    private int pressedConsumeTimer = 0;
    private List<Boolean> cachedObstructions = new ArrayList<Boolean>();
    private int cachedObstructionsTimer = 0;
    private int prevXpTier = 0;
    private boolean prevBookSlotEmpty = true;
    public static List<EnchantmentSkeleton> enchantmentsAvailable = new ArrayList<EnchantmentSkeleton>();

    public CrystallineFlowerScreen(CrystallineFlowerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_96546_ = false;
        this.f_97731_ = this.f_97727_ + -60;
        this.f_97729_ += -1;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        RenderSystem.m_69482_();
        ItemStack book = ((CrystallineFlowerMenu)this.f_97732_).bookSlot.m_7993_();
        if (book.m_41619_() != this.prevBookSlotEmpty || ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() != this.prevXpTier) {
            this.populateAvailableEnchants();
            this.prevXpTier = ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_();
            this.prevBookSlotEmpty = book.m_41619_();
        }
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        int rowStartX = startX + 76;
        int rowStartY = startY + 52;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
        this.renderScroller(poseStack, startX + 164, startY + 50);
        this.handleEnchantmentAreaRow(mouseX, mouseY, sectionId -> {
            if (sectionId >= enchantmentsAvailable.size()) {
                return false;
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
            EnchantmentSkeleton enchantmentEntry = enchantmentsAvailable.get((int)sectionId);
            boolean isCurse = enchantmentEntry.isCurse;
            boolean isTreasure = enchantmentEntry.isTreasure;
            int row = sectionId - this.startIndex;
            if (sectionId.intValue() == ((CrystallineFlowerMenu)this.f_97732_).selectedEnchantmentIndex.m_6501_()) {
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(rowStartX - 2), (int)(rowStartY - 2 + row * 19), (int)this.m_93252_(), (float)0.0f, (float)197.0f, (int)89, (int)19, (int)256, (int)256);
                this.drawEnchantmentText(poseStack, rowStartX, rowStartY + row * 19, enchantmentEntry, isCurse ? 0x990000 : (isTreasure ? 0xFFF000 : 0xFFD000), 0xC0FF00);
            } else {
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(rowStartX - 2), (int)(rowStartY - 2 + row * 19), (int)this.m_93252_(), (float)0.0f, (float)235.0f, (int)89, (int)19, (int)256, (int)256);
                this.drawEnchantmentText(poseStack, rowStartX, rowStartY + row * 19, enchantmentEntry, isCurse ? 0x800000 : (isTreasure ? 0xFFFF50 : 0x402020), 0x304000);
            }
            return true;
        }, sectionId -> {
            if (sectionId >= enchantmentsAvailable.size()) {
                return;
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
            EnchantmentSkeleton enchantmentEntry = enchantmentsAvailable.get((int)sectionId);
            boolean isCurse = enchantmentEntry.isCurse;
            boolean isTreasure = enchantmentEntry.isTreasure;
            int row = sectionId - this.startIndex;
            if (sectionId.intValue() == ((CrystallineFlowerMenu)this.f_97732_).selectedEnchantmentIndex.m_6501_()) {
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(rowStartX - 2), (int)(rowStartY - 2 + row * 19), (int)this.m_93252_(), (float)0.0f, (float)197.0f, (int)89, (int)19, (int)256, (int)256);
                this.drawEnchantmentText(poseStack, rowStartX, rowStartY + row * 19, enchantmentEntry, isCurse ? 0x990000 : (isTreasure ? 0xFFF000 : 0xFFD000), 0xC0FF00);
            } else {
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(rowStartX - 2), (int)(rowStartY - 2 + row * 19), (int)this.m_93252_(), (float)0.0f, (float)216.0f, (int)89, (int)19, (int)256, (int)256);
                this.drawEnchantmentText(poseStack, rowStartX, rowStartY + row * 19, enchantmentEntry, isCurse ? 0xFF2000 : (isTreasure ? 0xFFF000 : 13676784), 56640);
            }
        });
        if (((CrystallineFlowerMenu)this.f_97732_).tooManyEnchantmentsOnInput.m_6501_() == 1) {
            MutableComponent mutableComponent = Component.m_237115_((String)"the_bumblezone.container.crystalline_flower.too_many_enchants").m_130940_(ChatFormatting.BOLD);
            Screen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)mutableComponent, (int)(rowStartX + 45), (int)(rowStartY - 36), (int)13643792);
        } else if (((CrystallineFlowerMenu)this.f_97732_).selectedEnchantmentIndex.m_6501_() != -1) {
            EnchantmentSkeleton enchantment = enchantmentsAvailable.get(((CrystallineFlowerMenu)this.f_97732_).selectedEnchantmentIndex.m_6501_());
            int tierCost = EnchantmentUtils.getEnchantmentTierCost(enchantment.level, enchantment.minCost, enchantment.isTreasure, enchantment.isCurse);
            MutableComponent mutableComponent = Component.m_237110_((String)"the_bumblezone.container.crystalline_flower.tier_cost_arrow", (Object[])new Object[]{tierCost}).m_130940_(ChatFormatting.BOLD);
            Screen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)mutableComponent, (int)(rowStartX + 45), (int)(rowStartY - 36), (int)13643792);
        }
        this.drawPushableButtons(poseStack, startX, startY, mouseX, mouseY);
        this.drawTierState(poseStack, startX, startY);
        this.renderXPBar(poseStack, startX, startY);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    private void drawTierState(PoseStack poseStack, int startX, int startY) {
        int xOffset = startX + 11;
        int yOffset = startY + 15;
        if (this.cachedObstructionsTimer <= 0) {
            BlockPos flowerPos = new BlockPos(GeneralUtils.merge(((CrystallineFlowerMenu)this.f_97732_).bottomBlockPosXUpper.m_6501_(), ((CrystallineFlowerMenu)this.f_97732_).bottomBlockPosXLower.m_6501_()), GeneralUtils.merge(((CrystallineFlowerMenu)this.f_97732_).bottomBlockPosYUpper.m_6501_(), ((CrystallineFlowerMenu)this.f_97732_).bottomBlockPosYLower.m_6501_()), GeneralUtils.merge(((CrystallineFlowerMenu)this.f_97732_).bottomBlockPosZUpper.m_6501_(), ((CrystallineFlowerMenu)this.f_97732_).bottomBlockPosZLower.m_6501_()));
            this.cachedObstructions = CrystallineFlower.getObstructions(7, this.f_96541_.f_91074_.m_9236_(), flowerPos);
            this.cachedObstructionsTimer = 100;
        }
        --this.cachedObstructionsTimer;
        for (int i = 0; i < 7; ++i) {
            if (i >= ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_()) {
                if (i >= this.cachedObstructions.size() || !this.cachedObstructions.get(i).booleanValue()) continue;
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)(yOffset + (72 - i * 12)), (int)this.m_93252_(), (float)195.0f, (float)217.0f, (int)10, (int)10, (int)256, (int)256);
                continue;
            }
            float textureU = 195.0f;
            float textureV = 207.0f;
            if (i + 1 == ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_()) {
                textureU = 195.0f;
                textureV = 197.0f;
            }
            RenderSystem.m_69482_();
            CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)(yOffset + (72 - i * 12)), (int)this.m_93252_(), (float)textureU, (float)textureV, (int)10, (int)10, (int)256, (int)256);
        }
    }

    private void drawPushableButtons(PoseStack poseStack, int startX, int startY, int mouseX, int mouseY) {
        int yOffset;
        int xOffset;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
        if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceUI.get()).booleanValue()) {
            if (this.pressedXp1Timer > 0 || ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() == 7 || this.isPathObstructed(1).booleanValue() || !this.canPlayerBuyTier(1).booleanValue()) {
                --this.pressedXp1Timer;
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 46), (int)(startY + 14), (int)this.m_93252_(), (float)108.0f, (float)215.0f, (int)18, (int)18, (int)256, (int)256);
            } else {
                xOffset = startX + 46;
                yOffset = startY + 14;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)108.0f, (float)233.0f, (int)18, (int)18, (int)256, (int)256);
                } else {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)108.0f, (float)197.0f, (int)18, (int)18, (int)256, (int)256);
                }
            }
        }
        if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceUI.get()).booleanValue()) {
            if (this.pressedXp2Timer > 0 || ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() == 7 || this.isPathObstructed(2).booleanValue() || !this.canPlayerBuyTier(2).booleanValue()) {
                --this.pressedXp2Timer;
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 46), (int)(startY + 34), (int)this.m_93252_(), (float)126.0f, (float)215.0f, (int)18, (int)18, (int)256, (int)256);
            } else {
                xOffset = startX + 46;
                yOffset = startY + 34;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)126.0f, (float)233.0f, (int)18, (int)18, (int)256, (int)256);
                } else {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)126.0f, (float)197.0f, (int)18, (int)18, (int)256, (int)256);
                }
            }
        }
        if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceUI.get()).booleanValue()) {
            if (this.pressedXp3Timer > 0 || ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() == 7 || this.isPathObstructed(3).booleanValue() || !this.canPlayerBuyTier(3).booleanValue()) {
                --this.pressedXp3Timer;
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 46), (int)(startY + 54), (int)this.m_93252_(), (float)144.0f, (float)215.0f, (int)18, (int)18, (int)256, (int)256);
            } else {
                xOffset = startX + 46;
                yOffset = startY + 54;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)144.0f, (float)233.0f, (int)18, (int)18, (int)256, (int)256);
                } else {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)144.0f, (float)197.0f, (int)18, (int)18, (int)256, (int)256);
                }
            }
        }
        if (!((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceUI.get()).booleanValue()) {
            xOffset = startX + 26;
            yOffset = startY + 14;
            RenderSystem.m_69482_();
            CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)176.0f, (float)0.0f, (int)48, (int)58, (int)256, (int)256);
        }
        if (this.pressedConsumeTimer > 0) {
            --this.pressedConsumeTimer;
        }
        if (((CrystallineFlowerMenu)this.f_97732_).consumeSlotFullyObstructed.m_6501_() != 1 && ((Boolean)BzGeneralConfigs.crystallineFlowerConsumeItemUI.get()).booleanValue()) {
            if (this.pressedConsumeTimer > 0) {
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 25), (int)(startY + 62), (int)this.m_93252_(), (float)162.0f, (float)215.0f, (int)18, (int)18, (int)256, (int)256);
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 26), (int)(startY + 82), (int)this.m_93252_(), (float)180.0f, (float)215.0f, (int)15, (int)11, (int)256, (int)256);
            } else if (((CrystallineFlowerMenu)this.f_97732_).consumeSlot.m_6657_() && ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() < 7) {
                xOffset = startX + 25;
                yOffset = startY + 62;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 25), (int)(startY + 62), (int)this.m_93252_(), (float)162.0f, (float)233.0f, (int)18, (int)18, (int)256, (int)256);
                } else {
                    RenderSystem.m_69482_();
                    CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 25), (int)(startY + 62), (int)this.m_93252_(), (float)162.0f, (float)197.0f, (int)18, (int)18, (int)256, (int)256);
                }
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 26), (int)(startY + 82), (int)this.m_93252_(), (float)180.0f, (float)197.0f, (int)15, (int)11, (int)256, (int)256);
            }
        }
        if (!((Boolean)BzGeneralConfigs.crystallineFlowerConsumeItemUI.get()).booleanValue()) {
            xOffset = startX + 26;
            yOffset = startY + 78;
            RenderSystem.m_69482_();
            CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)176.0f, (float)59.0f, (int)48, (int)19, (int)256, (int)256);
        }
    }

    private void drawEnchantmentText(PoseStack poseStack, int rowStartX, int currentRowStartY, EnchantmentSkeleton enchantmentEntry, int enchantmentNameColor, int enchantmentLevelColor) {
        String translatedEnchantmentName = this.getTruncatedString(enchantmentEntry.namespace, enchantmentEntry.path, 88);
        MutableComponent mutableComponent = Component.m_237113_((String)translatedEnchantmentName);
        MutableComponent mutableComponent2 = Component.m_237110_((String)"the_bumblezone.container.crystalline_flower.level", (Object[])new Object[]{enchantmentEntry.level});
        if (enchantmentEntry.isMaxLevel) {
            mutableComponent2.m_7220_((Component)Component.m_237115_((String)"the_bumblezone.container.crystalline_flower.level_star"));
        }
        this.f_96547_.m_92889_(poseStack, (Component)mutableComponent, (float)rowStartX, (float)currentRowStartY, enchantmentNameColor);
        this.f_96547_.m_92889_(poseStack, (Component)mutableComponent2, (float)(rowStartX + 5), (float)(currentRowStartY + 8), enchantmentLevelColor);
    }

    @NotNull
    private String getTruncatedString(String namespace, String path, int maxSize) {
        StringBuilder translatedEnchantmentName = new StringBuilder(Language.m_128107_().m_6834_("enchantment.%s.%s".formatted(namespace, path)));
        String originalNameOutput = translatedEnchantmentName.toString();
        if (originalNameOutput.contains("enchantment.")) {
            translatedEnchantmentName = new StringBuilder(Arrays.stream(path.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" ")));
        }
        boolean hasTruncated = false;
        while (this.f_96547_.m_92895_(translatedEnchantmentName.toString()) > maxSize) {
            int nameLength = translatedEnchantmentName.length();
            if (hasTruncated) {
                translatedEnchantmentName.delete(nameLength - 3, nameLength);
            }
            nameLength = translatedEnchantmentName.length();
            Matcher matcher = SPLIT_WITH_COMBINING_CHARS.matcher(translatedEnchantmentName);
            if (!matcher.find()) break;
            List<MatchResult> matchResults = matcher.results().toList();
            MatchResult match = matchResults.get(matchResults.size() - 1);
            String lastCharacter = match.group();
            if (translatedEnchantmentName.toString().endsWith(lastCharacter)) {
                translatedEnchantmentName.delete(nameLength - lastCharacter.length(), nameLength);
            }
            translatedEnchantmentName.append("...");
            hasTruncated = true;
        }
        return translatedEnchantmentName.toString();
    }

    private void populateAvailableEnchants() {
        ItemStack book = ((CrystallineFlowerMenu)this.f_97732_).bookSlot.m_7993_();
        if (!book.m_41619_() && ((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() > 1 && ((CrystallineFlowerMenu)this.f_97732_).tooManyEnchantmentsOnInput.m_6501_() != 1) {
            ItemStack tempBook = book.m_41777_();
            tempBook.m_41764_(1);
            CompoundTag compoundtag = book.m_41783_();
            if (compoundtag != null) {
                tempBook.m_41751_(compoundtag.m_6426_());
            }
        } else {
            enchantmentsAvailable.clear();
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialtick, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, startX, startY, 0, 0, this.f_97726_, 126);
        this.m_93228_(poseStack, startX, startY + 126, 0, 126, this.f_97726_, 71);
    }

    private void renderXPBar(PoseStack poseStack, int startX, int startY) {
        if (((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() == 7) {
            RenderSystem.m_69482_();
            CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 11), (int)(startY + 99), (int)this.m_93252_(), (float)176.0f, (float)182.0f, (int)54, (int)5, (int)256, (int)256);
        } else {
            RenderSystem.m_69482_();
            CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 11), (int)(startY + 99), (int)this.m_93252_(), (float)176.0f, (float)187.0f, (int)54, (int)5, (int)256, (int)256);
            if (((CrystallineFlowerMenu)this.f_97732_).xpBarPercent.m_6501_() > 0) {
                RenderSystem.m_69482_();
                CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)(startX + 11), (int)(startY + 99), (int)this.m_93252_(), (float)176.0f, (float)192.0f, (int)((int)(54.0f * ((float)((CrystallineFlowerMenu)this.f_97732_).xpBarPercent.m_6501_() / 100.0f))), (int)5, (int)256, (int)256);
            }
        }
    }

    private void renderScroller(PoseStack poseStack, int posX, int posY) {
        int rowCount = enchantmentsAvailable.size() + 1 - 3;
        if (rowCount > 1) {
            if (this.startIndex > rowCount) {
                this.scrollOff = 1.0f;
            }
            this.startIndex = (int)((double)(this.scrollOff * (float)this.getOffscreenRows()) + 0.5);
            int scrollPosition = (int)(this.scrollOff * 42.0f);
            RenderSystem.m_69482_();
            CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)posX, (int)(posY + scrollPosition), (int)this.m_93252_(), (float)230.0f, (float)182.0f, (int)6, (int)17, (int)256, (int)256);
        } else {
            RenderSystem.m_69482_();
            CrystallineFlowerScreen.m_93143_((PoseStack)poseStack, (int)posX, (int)posY, (int)this.m_93252_(), (float)236.0f, (float)182.0f, (int)6, (int)17, (int)256, (int)256);
        }
    }

    private boolean canScroll(int numOffers) {
        return numOffers > 3;
    }

    private boolean handleEnchantmentAreaRow(double mouseX, double mouseY, Function<Integer, Boolean> targetedSectionTask, Consumer<Integer> untargetedSectionTask) {
        int startX = this.f_97735_ + 76 - 2;
        int startY = this.f_97736_ + 52 - 2;
        int selectableSections = this.startIndex + Math.min(enchantmentsAvailable.size(), 3);
        boolean targetedSectionTaskSuccess = false;
        for (int currentSection = this.startIndex; currentSection < selectableSections; ++currentSection) {
            int sectionOffset = currentSection - this.startIndex;
            double sectionMouseX = mouseX - (double)startX;
            double sectionMouseY = mouseY - (double)(startY + sectionOffset * 19);
            if (sectionMouseX >= 0.0 && sectionMouseX < 88.0 && sectionMouseY >= 0.0 && sectionMouseY < 19.0) {
                targetedSectionTaskSuccess = targetedSectionTask.apply(currentSection);
                continue;
            }
            untargetedSectionTask.accept(currentSection);
        }
        return targetedSectionTaskSuccess;
    }

    protected void m_7025_(PoseStack poseStack, int x, int y) {
        super.m_7025_(poseStack, x, y);
        int startX = this.f_97735_ + 76 - 2;
        int startY = this.f_97736_ + 52 - 2;
        int selectableSections = this.startIndex + Math.min(enchantmentsAvailable.size(), 3);
        for (int currentSection = this.startIndex; currentSection < selectableSections; ++currentSection) {
            MutableComponent mutableComponent4;
            if (currentSection >= enchantmentsAvailable.size()) continue;
            int sectionOffset = currentSection - this.startIndex;
            double sectionMouseX = (double)x - (double)startX;
            double sectionMouseY = (double)y - (double)(startY + sectionOffset * 19);
            if (!(sectionMouseX >= 0.0) || !(sectionMouseX < 88.0) || !(sectionMouseY >= 0.0) || !(sectionMouseY < 19.0)) continue;
            EnchantmentSkeleton enchantment = enchantmentsAvailable.get(currentSection);
            int tierCost = EnchantmentUtils.getEnchantmentTierCost(enchantment.level, enchantment.minCost, enchantment.isTreasure, enchantment.isCurse);
            String translatedEnchantmentName = Language.m_128107_().m_6834_("enchantment.%s.%s".formatted(enchantment.namespace, enchantment.path));
            if (translatedEnchantmentName.contains("enchantment.")) {
                translatedEnchantmentName = Arrays.stream(enchantment.path.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
            }
            MutableComponent mutableComponent = Component.m_237113_((String)translatedEnchantmentName).m_130940_(ChatFormatting.GOLD);
            MutableComponent mutableComponent2 = Component.m_237110_((String)"the_bumblezone.container.crystalline_flower.level", (Object[])new Object[]{enchantment.level}).m_130940_(ChatFormatting.GREEN);
            if (enchantment.isMaxLevel) {
                mutableComponent2.m_7220_((Component)Component.m_237115_((String)"the_bumblezone.container.crystalline_flower.level_star"));
            }
            MutableComponent mutableComponent3 = Component.m_237110_((String)"the_bumblezone.container.crystalline_flower.tier_cost", (Object[])new Object[]{tierCost}).m_130940_(ChatFormatting.RED);
            if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92125_) {
                mutableComponent4 = Component.m_237113_((String)(enchantment.namespace + ":" + enchantment.path)).m_130940_(ChatFormatting.DARK_GRAY);
            } else {
                Optional modFileInfo = ModList.get().getModContainerById(enchantment.namespace);
                if (modFileInfo.isEmpty()) {
                    String formattedModid = Arrays.stream(enchantment.namespace.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                    mutableComponent4 = Component.m_237113_((String)formattedModid).m_130940_(ChatFormatting.BLUE);
                } else {
                    mutableComponent4 = Component.m_237113_((String)((ModContainer)modFileInfo.get()).getModInfo().getDisplayName()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC);
                }
            }
            this.renderTooltip(poseStack, List.of(mutableComponent, mutableComponent2, mutableComponent3, mutableComponent4), Optional.empty(), x, y, this.f_96547_);
            return;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.handleEnchantmentAreaRow(mouseX, mouseY, sectionId -> {
            if (((CrystallineFlowerMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, (int)sectionId)) {
                this.sendButtonPressToMenu((Integer)sectionId);
                return true;
            }
            return false;
        }, i -> {})) {
            return true;
        }
        int startX = this.f_97735_ + 164;
        int startY = this.f_97736_ + 50;
        if (mouseX >= (double)startX && mouseX < (double)(startX + 6) && mouseY >= (double)startY && mouseY < (double)(startY + 50)) {
            this.scrolling = true;
        }
        if (((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() != 7) {
            if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceUI.get()).booleanValue() && this.canPlayerBuyTier(1).booleanValue() && !this.isPathObstructed(1).booleanValue() && mouseX >= (double)(this.f_97735_ + 46) && mouseX < (double)(this.f_97735_ + 46 + 18) && mouseY >= (double)(this.f_97736_ + 14) && mouseY < (double)(this.f_97736_ + 14 + 18)) {
                this.pressedXp1Timer = 25;
                this.sendButtonPressToMenu(-2);
            } else if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceUI.get()).booleanValue() && this.canPlayerBuyTier(2).booleanValue() && !this.isPathObstructed(2).booleanValue() && mouseX >= (double)(this.f_97735_ + 46) && mouseX < (double)(this.f_97735_ + 46 + 18) && mouseY >= (double)(this.f_97736_ + 34) && mouseY < (double)(this.f_97736_ + 34 + 18)) {
                this.pressedXp2Timer = 25;
                this.sendButtonPressToMenu(-3);
            } else if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceUI.get()).booleanValue() && this.canPlayerBuyTier(3).booleanValue() && !this.isPathObstructed(3).booleanValue() && mouseX >= (double)(this.f_97735_ + 46) && mouseX < (double)(this.f_97735_ + 46 + 18) && mouseY >= (double)(this.f_97736_ + 54) && mouseY < (double)(this.f_97736_ + 54 + 18)) {
                this.pressedXp3Timer = 25;
                this.sendButtonPressToMenu(-4);
            } else if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeItemUI.get()).booleanValue() && ((CrystallineFlowerMenu)this.f_97732_).consumeSlotFullyObstructed.m_6501_() != 1 && mouseX >= (double)(this.f_97735_ + 25) && mouseX < (double)(this.f_97735_ + 25 + 18) && mouseY >= (double)(this.f_97736_ + 62) && mouseY < (double)(this.f_97736_ + 62 + 18)) {
                this.pressedConsumeTimer = 25;
                this.sendButtonPressToMenu(-5);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private Boolean canPlayerBuyTier(int xpTiersToCheck) {
        return xpTiersToCheck <= ((CrystallineFlowerMenu)this.f_97732_).playerHasXPForTier.m_6501_();
    }

    private Boolean isPathObstructed(int xpTiersToCheck) {
        for (int i = 0; i < xpTiersToCheck; ++i) {
            if (((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() + i >= this.cachedObstructions.size() || !this.cachedObstructions.get(((CrystallineFlowerMenu)this.f_97732_).xpTier.m_6501_() + i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void sendButtonPressToMenu(Integer sectionId) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
        this.f_96541_.f_91072_.m_105208_(((CrystallineFlowerMenu)this.f_97732_).f_38840_, sectionId.intValue());
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.canScroll(enchantmentsAvailable.size())) {
            int topY = this.f_97736_ + 50;
            int bottomY = topY + 50;
            this.scrollOff = ((float)mouseY - (float)topY - 7.5f) / ((float)(bottomY - topY) - 15.0f);
            this.scrollOff = Mth.m_14036_((float)this.scrollOff, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOff * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll(enchantmentsAvailable.size())) {
            int offscreenRows = this.getOffscreenRows();
            float percentage = (float)delta / (float)offscreenRows;
            this.scrollOff = Mth.m_14036_((float)(this.scrollOff - percentage), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOff * (float)offscreenRows) + 0.5);
        }
        return true;
    }

    protected int getOffscreenRows() {
        return Math.max(enchantmentsAvailable.size() - 3, 0);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        return mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.f_97726_) || mouseY >= (double)(top + this.f_97727_ + 32);
    }
}

