/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MobEffectClientSyncPacket {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;
    private final int entityId;
    private final byte effectId;
    private final byte effectAmplifier;
    private final int effectDurationTicks;
    private final byte flags;

    public MobEffectClientSyncPacket(int mobId, MobEffectInstance mobEffectInstance) {
        this.entityId = mobId;
        this.effectId = (byte)(MobEffect.m_19459_((MobEffect)mobEffectInstance.m_19544_()) & 0xFF);
        this.effectAmplifier = (byte)(mobEffectInstance.m_19564_() & 0xFF);
        this.effectDurationTicks = Math.min(mobEffectInstance.m_19557_(), Short.MAX_VALUE);
        byte flags = 0;
        if (mobEffectInstance.m_19571_()) {
            flags = (byte)(flags | 1);
        }
        if (mobEffectInstance.m_19572_()) {
            flags = (byte)(flags | 2);
        }
        if (mobEffectInstance.m_19575_()) {
            flags = (byte)(flags | 4);
        }
        this.flags = flags;
    }

    private MobEffectClientSyncPacket(int entityId, byte effectId, byte effectAmplifier, int effectDurationTicks, byte flags) {
        this.entityId = entityId;
        this.effectId = effectId;
        this.effectAmplifier = effectAmplifier;
        this.effectDurationTicks = effectDurationTicks;
        this.flags = flags;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public byte getEffectId() {
        return this.effectId;
    }

    public byte getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public int getEffectDurationTicks() {
        return this.effectDurationTicks;
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) == 4;
    }

    public boolean isSuperLongDuration() {
        return this.effectDurationTicks == Short.MAX_VALUE;
    }

    public static void sendToClient(Entity entity, MobEffectInstance mobEffectInstance) {
        MessageHandler.DEFAULT_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MobEffectClientSyncPacket(entity.m_19879_(), mobEffectInstance));
    }

    public static MobEffectClientSyncPacket parse(FriendlyByteBuf buf) {
        return new MobEffectClientSyncPacket(buf.m_130242_(), buf.readByte(), buf.readByte(), buf.m_130242_(), buf.readByte());
    }

    public static void compose(MobEffectClientSyncPacket pkt, FriendlyByteBuf buf) {
        buf.m_130130_(pkt.entityId);
        buf.writeByte((int)pkt.effectId);
        buf.writeByte((int)pkt.effectAmplifier);
        buf.m_130130_(pkt.effectDurationTicks);
        buf.writeByte((int)pkt.flags);
    }

    public static class Handler {
        public static void handle(MobEffectClientSyncPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                MobEffect mobeffect;
                if (Minecraft.m_91087_().f_91073_ == null) {
                    return;
                }
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(pkt.getEntityId());
                if (entity instanceof LivingEntity && (mobeffect = MobEffect.m_19453_((int)(pkt.getEffectId() & 0xFF))) != null) {
                    MobEffectInstance mobeffectinstance = new MobEffectInstance(mobeffect, pkt.getEffectDurationTicks(), (int)pkt.getEffectAmplifier(), pkt.isEffectAmbient(), pkt.isEffectVisible(), pkt.effectShowsIcon());
                    ((LivingEntity)entity).m_147215_(mobeffectinstance, null);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

