/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.modcompat.JEIIntegration;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.DrawableBuilder;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenTradesInfo;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class QueenTradesJEICategory
implements IRecipeCategory<JEIQueenTradesInfo> {
    public static final int RECIPE_WIDTH = 124;
    public static final int RECIPE_HEIGHT = 28;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public QueenTradesJEICategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("the_bumblezone", "textures/gui/queen_trades_jei.png"), 0, 0, 124, 28);
        this.localizedName = Component.m_237115_((String)"the_bumblezone.jei.bee_queen_trades");
        DrawableBuilder iconBuilder = new DrawableBuilder(new ResourceLocation("the_bumblezone", "textures/gui/bee_queen_trades.png"), 0, 0, 16, 16);
        iconBuilder.setTextureSize(16, 16);
        this.icon = iconBuilder.build();
    }

    public RecipeType<JEIQueenTradesInfo> getRecipeType() {
        return JEIIntegration.QUEEN_TRADES;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(JEIQueenTradesInfo recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)Component.m_237110_((String)"the_bumblezone.jei.queen_trade_xp", (Object[])new Object[]{recipe.xp()}), 100.0f, 10.0f, -8355712);
        double percentValue = (double)recipe.weight() / (double)recipe.totalGroupWeight() * 100.0;
        String percentRounded = String.valueOf(Math.max(Math.round(percentValue), 1L));
        Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)Component.m_237110_((String)"the_bumblezone.jei.queen_trade_chance_text", (Object[])new Object[]{percentRounded}), (float)(38 - percentRounded.length() * 3), 11.0f, -8355712);
    }

    public List<Component> getTooltipStrings(JEIQueenTradesInfo recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 32.0 && mouseX < 54.0 && mouseY > 4.0 && mouseY < 24.0) {
            String percent = String.valueOf((double)recipe.weight() / (double)recipe.totalGroupWeight() * 100.0);
            return List.of(Component.m_237110_((String)"the_bumblezone.jei.queen_trade_chance_tooltip", (Object[])new Object[]{percent.substring(0, Math.min(percent.length(), 5))}));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JEIQueenTradesInfo recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.wantItem());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 64, 6).addItemStacks(recipe.rewards());
    }
}

