/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.TradeEntryReducedObj;
import com.telepathicgrunt.the_bumblezone.items.recipes.IncenseCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakeIncenseCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.QueenRandomizerTradesREICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.QueenTradesREICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.REIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.REIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

@REIPluginClient
public class REICompat
implements REIClientPlugin {
    public static final CategoryIdentifier<REIQueenTradesInfo> QUEEN_TRADES = CategoryIdentifier.of((String)"the_bumblezone", (String)"queen_trades");
    public static final CategoryIdentifier<REIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = CategoryIdentifier.of((String)"the_bumblezone", (String)"queen_color_randomizer_trades");

    public void registerDisplays(DisplayRegistry registry) {
        BzItems.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> REICompat.addInfo((Item)item.get()));
        REICompat.addInfo((Item)BzItems.PILE_OF_POLLEN.get());
        REICompat.addInfo((Fluid)BzFluids.SUGAR_WATER_FLUID.get());
        REICompat.addInfo((Fluid)BzFluids.ROYAL_JELLY_FLUID.get());
        REICompat.addInfo((Fluid)BzFluids.HONEY_FLUID.get());
        registry.getRecipeManager().m_44043_(new ResourceLocation("the_bumblezone", "incense_candle_from_super_candles")).ifPresent(recipe -> REICompat.registerExtraRecipes(recipe, registry, true));
        registry.getRecipeManager().m_44043_(new ResourceLocation("the_bumblezone", "incense_candle")).ifPresent(recipe -> REICompat.registerExtraRecipes(recipe, registry, false));
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.tradeReduced.isEmpty()) {
            for (Map.Entry trade : QueensTradeManager.QUEENS_TRADE_MANAGER.tradeReduced.entrySet()) {
                for (TradeEntryReducedObj tradeResult : ((WeightedRandomList)trade.getValue()).m_146338_()) {
                    if (tradeResult.randomizerTrade()) continue;
                    List<ItemStack> rewardCollection = tradeResult.items().stream().map(e -> new ItemStack((ItemLike)e, tradeResult.count())).toList();
                    registry.add((Display)new REIQueenTradesInfo(List.of(EntryIngredients.of((ItemLike)((ItemLike)trade.getKey()))), List.of(EntryIngredients.ofItemStacks(rewardCollection)), tradeResult.xpReward(), tradeResult.weight(), tradeResult.totalGroupWeight()), QUEEN_TRADES);
                }
            }
        }
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.tradeReduced.isEmpty()) {
            for (TradeEntryReducedObj tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.tradeRandomizer) {
                List<ItemStack> randomizeStack = tradeEntry.items().stream().map(Item::m_7968_).toList();
                for (ItemStack input : randomizeStack) {
                    registry.add((Display)new REIQueenRandomizerTradesInfo(List.of(EntryIngredients.of((ItemStack)input)), List.of(EntryIngredients.ofItemStacks(randomizeStack)), 1, randomizeStack.size()), QUEEN_RANDOMIZE_TRADES);
                }
            }
        }
    }

    private static void addInfo(Item item) {
        BuiltinClientPlugin.getInstance().registerInformation(EntryStacks.of((ItemLike)item), (Component)Component.m_237115_((String)Registry.f_122827_.m_7981_((Object)item).toString()), text -> {
            text.add(Component.m_237115_((String)("the_bumblezone." + Registry.f_122827_.m_7981_((Object)item).m_135815_() + ".jei_description")));
            return text;
        });
    }

    private static void addInfo(Fluid fluid) {
        BuiltinClientPlugin.getInstance().registerInformation(EntryStacks.of((Fluid)fluid, (long)1L), (Component)Component.m_237115_((String)Registry.f_122822_.m_7981_((Object)fluid).toString()), text -> {
            text.add(Component.m_237115_((String)("the_bumblezone." + Registry.f_122822_.m_7981_((Object)fluid).m_135815_() + ".jei_description")));
            return text;
        });
    }

    private static void registerExtraRecipes(Recipe<?> baseRecipe, DisplayRegistry registry, boolean oneRecipeOnly) {
        if (baseRecipe instanceof IncenseCandleRecipe) {
            IncenseCandleRecipe incenseCandleRecipe = (IncenseCandleRecipe)baseRecipe;
            List<CraftingRecipe> extraRecipes = FakeIncenseCandleRecipeCreator.constructFakeRecipes(incenseCandleRecipe, oneRecipeOnly);
            extraRecipes.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        }
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new QueenTradesREICategory());
        registry.add((DisplayCategory)new QueenRandomizerTradesREICategory());
        registry.addWorkstations(QUEEN_TRADES, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)BzItems.BEE_QUEEN_SPAWN_EGG.get()))});
        registry.addWorkstations(QUEEN_RANDOMIZE_TRADES, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)BzItems.BEE_QUEEN_SPAWN_EGG.get()))});
    }
}

