/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import alexthw.ars_elemental.common.glyphs.MethodCurvedProjectile;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import com.google.common.collect.Sets;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.telepathicgrunt.the_bumblezone.modcompat.ArsNouveauCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class ArsElementalCompat {
    private static final ResourceLocation SPELL_HOMING_PROJ_RL = new ResourceLocation("ars_elemental", "homing_projectile");
    private static final ResourceLocation SPELL_CURVED_PROJ_RL = new ResourceLocation("ars_elemental", "curved_projectile");
    private static final Set<AbstractCastMethod> ALLOWED_ELEMENTAL_CAST_METHODS = Sets.newHashSet((Object[])new AbstractCastMethod[]{MethodHomingProjectile.INSTANCE, MethodCurvedProjectile.INSTANCE});

    public static void setupCompat() {
        ArsNouveauCompat.ALLOWED_CAST_METHODS.addAll(ALLOWED_ELEMENTAL_CAST_METHODS);
        ModChecker.arsElementalPresent = true;
    }

    protected static boolean isArsElementalSpellDisallowed(EffectResolveEvent.Post event) {
        if (event.spell.getCastMethod() == MethodHomingProjectile.INSTANCE && !((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(SPELL_HOMING_PROJ_RL)).m_204039_(BzTags.TELEPORT_PROJECTILES)) {
            return true;
        }
        return event.spell.getCastMethod() == MethodCurvedProjectile.INSTANCE && !((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(SPELL_CURVED_PROJ_RL)).m_204039_(BzTags.TELEPORT_PROJECTILES);
    }

    public static boolean isArsElementalSpellProjectile(ResourceLocation projectileRL) {
        return projectileRL.equals((Object)SPELL_HOMING_PROJ_RL) || projectileRL.equals((Object)SPELL_CURVED_PROJ_RL);
    }
}

