/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.mixin.entities;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ExperienceOrb.class})
public abstract class ExperienceOrbMixin
extends Entity {
    @Unique
    private BlockPos thebumblezone_trackedCrystalFlower = null;
    @Unique
    private int thebumblezone_trackedCrystalFlowerCooldown = 0;

    public ExperienceOrbMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V")}, require=0)
    private void thebumblezone_xpGoToClosestCrystalFlower(CallbackInfo ci) {
        if (!((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceOrbEntities.get()).booleanValue()) {
            return;
        }
        double distanceThreshold = 8.0;
        --this.thebumblezone_trackedCrystalFlowerCooldown;
        if (this.thebumblezone_trackedCrystalFlower == null && this.thebumblezone_trackedCrystalFlowerCooldown <= 0) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            HashSet<LevelChunk> chunksInRange = new HashSet<LevelChunk>();
            int x = (int)(-distanceThreshold);
            while ((double)x <= distanceThreshold) {
                int z = (int)(-distanceThreshold);
                while ((double)z <= distanceThreshold) {
                    mutableBlockPos.m_122169_(this.m_20185_() + (double)x, 0.0, this.m_20189_() + (double)z);
                    ChunkAccess chunk = this.f_19853_.m_46865_((BlockPos)mutableBlockPos);
                    if (chunk instanceof LevelChunk) {
                        chunksInRange.add((LevelChunk)chunk);
                    }
                    z = (int)((double)z + distanceThreshold);
                }
                x = (int)((double)x + distanceThreshold);
            }
            Optional<BlockEntity> closestCrystalFlower = chunksInRange.stream().flatMap(c -> c.m_62954_().values().stream()).filter(be -> {
                CrystallineFlowerBlockEntity crystallineFlowerBlockEntity;
                return be instanceof CrystallineFlowerBlockEntity && !(crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)((Object)be)).isMaxTier();
            }).min((a, b) -> a.m_58899_().m_123333_((Vec3i)this.m_20183_()) - b.m_58899_().m_123333_((Vec3i)this.m_20183_()));
            closestCrystalFlower.ifPresent(blockEntity -> {
                this.thebumblezone_trackedCrystalFlower = blockEntity.m_58899_();
            });
            this.thebumblezone_trackedCrystalFlowerCooldown = 60;
        }
        if (this.thebumblezone_trackedCrystalFlower != null) {
            Vec3 centerBlockPosition = Vec3.m_82512_((Vec3i)this.thebumblezone_trackedCrystalFlower);
            Vec3 vec3 = new Vec3(centerBlockPosition.m_7096_() - this.m_20185_(), centerBlockPosition.m_7098_() - 0.5 - this.m_20186_(), centerBlockPosition.m_7094_() - this.m_20189_());
            double sqrDistance = vec3.m_82556_();
            if (sqrDistance >= distanceThreshold * distanceThreshold) {
                this.thebumblezone_trackedCrystalFlower = null;
                return;
            }
            BlockState state = this.f_19853_.m_8055_(this.thebumblezone_trackedCrystalFlower);
            if (state.m_60734_() instanceof CrystallineFlower) {
                double speedFactor = 1.0 - Math.sqrt(sqrDistance) / distanceThreshold;
                this.m_20256_(this.m_20184_().m_82549_(vec3.m_82541_().m_82490_(speedFactor * speedFactor * 0.11)));
            }
        }
    }
}

