/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.telepathicgrunt.the_bumblezone.items.HoneyCompass;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzLootFunctionTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class HoneyCompassLocateStructure
extends LootItemConditionalFunction {
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    final TagKey<Structure> destination;
    final int searchRadius;
    final boolean skipKnownStructures;

    public HoneyCompassLocateStructure(LootItemCondition[] lootItemConditions, TagKey<Structure> destination, int searchRadius, boolean skipKnownStructrues) {
        super(lootItemConditions);
        this.destination = destination;
        this.searchRadius = searchRadius;
        this.skipKnownStructures = skipKnownStructrues;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)BzLootFunctionTypes.HONEY_COMPASS_LOCATE_STRUCTURE.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    public ItemStack m_7372_(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.m_150930_((Item)BzItems.HONEY_COMPASS.get())) {
            Vec3 vec3 = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
            if (vec3 != null) {
                BlockPos blockPos = new BlockPos(vec3);
                itemStack.m_41784_().m_128379_("IsLoading", true);
                HoneyCompass.setStructureTags(itemStack.m_41784_(), this.destination);
                ThreadExecutor.locate(lootContext.m_78952_(), this.destination, blockPos, 100, false).thenOnServerThread(foundPos -> this.setCompassData(itemStack, lootContext, (BlockPos)foundPos));
            } else if (itemStack.m_41782_()) {
                itemStack.m_41751_(new CompoundTag());
            }
        }
        return itemStack;
    }

    private void setCompassData(ItemStack itemStack, LootContext lootContext, BlockPos blockPos) {
        if (blockPos != null) {
            HoneyCompass.addStructureTags((ResourceKey<Level>)lootContext.m_78952_().m_46472_(), blockPos, itemStack.m_41784_());
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<HoneyCompassLocateStructure> {
        public void serialize(JsonObject jsonObject, HoneyCompassLocateStructure honeyCompassLocateStructure, JsonSerializationContext context) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)honeyCompassLocateStructure, context);
            if (!honeyCompassLocateStructure.destination.equals((Object)ExplorationMapFunction.f_230983_)) {
                jsonObject.addProperty("destination", honeyCompassLocateStructure.destination.f_203868_().toString());
            }
            if (honeyCompassLocateStructure.searchRadius != 50) {
                jsonObject.addProperty("search_radius", (Number)honeyCompassLocateStructure.searchRadius);
            }
            if (!honeyCompassLocateStructure.skipKnownStructures) {
                jsonObject.addProperty("skip_existing_chunks", Boolean.valueOf(honeyCompassLocateStructure.skipKnownStructures));
            }
        }

        public HoneyCompassLocateStructure deserialize(JsonObject jsonObject, JsonDeserializationContext context, LootItemCondition[] lootItemConditions) {
            TagKey<Structure> tagkey = Serializer.readStructure(jsonObject);
            int searchRadiusInt = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"search_radius", (int)50);
            boolean skipExistingChunksBool = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"skip_existing_chunks", (boolean)true);
            return new HoneyCompassLocateStructure(lootItemConditions, tagkey, searchRadiusInt, skipExistingChunksBool);
        }

        private static TagKey<Structure> readStructure(JsonObject jsonObject) {
            if (jsonObject.has("destination")) {
                String s = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"destination");
                return TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(s));
            }
            return BzTags.HONEY_COMPASS_DEFAULT_LOCATING;
        }
    }
}

