/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityMisc;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ThrownStingerSpearEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class StingerSpearItem
extends TridentItem {
    public static final float BASE_DAMAGE = 1.0f;
    public static final float BASE_THROWN_DAMAGE = 1.5f;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public StingerSpearItem(Item.Properties properties) {
        super(properties.m_41503_(220));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -1.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public int m_8105_(ItemStack itemStack) {
        return 50000;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.STINGER_SPEAR_REPAIR_ITEMS);
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int currentDuration) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int remainingDuration = this.m_8105_(itemStack) - currentDuration;
            if (remainingDuration >= 10) {
                if (!level.f_46443_) {
                    itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(livingEntity.m_7655_()));
                    ThrownStingerSpearEntity thrownStingerSpear = new ThrownStingerSpearEntity(level, (LivingEntity)player, itemStack);
                    thrownStingerSpear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                    if (player.m_150110_().f_35937_) {
                        thrownStingerSpear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    level.m_7967_((Entity)thrownStingerSpear);
                    level.m_6269_(null, (Entity)thrownStingerSpear, (SoundEvent)BzSounds.STINGER_SPEAR_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150109_().m_36057_(itemStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity enemy, LivingEntity user) {
        int neuroToxinLevel;
        int potentPoisonLevel = itemStack.getEnchantmentLevel((Enchantment)BzEnchantments.POTENT_POISON.get());
        if (enemy.m_6336_() != MobType.f_21641_) {
            enemy.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100 + 100 * (potentPoisonLevel - (potentPoisonLevel - 1) / 2), potentPoisonLevel, true, true, true));
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                BzCriterias.STINGER_SPEAR_POISONING_TRIGGER.trigger(serverPlayer);
            }
        }
        int durabilityDecrease = 1;
        if (user instanceof Player && (neuroToxinLevel = itemStack.getEnchantmentLevel((Enchantment)BzEnchantments.NEUROTOXINS.get())) > 0) {
            durabilityDecrease = 5;
        }
        itemStack.m_41622_(durabilityDecrease, user, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            if (enemy.m_6095_() == EntityType.f_20496_ && enemy.m_21224_() && EntityMisc.rootAdvancementDone(serverPlayer)) {
                BzCriterias.STINGER_SPEAR_KILLED_WITH_WITHER_TRIGGER.trigger(serverPlayer);
            }
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44958_ || enchantment == Enchantments.f_44957_) {
            return false;
        }
        if (enchantment == Enchantments.f_44978_) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }
}

