/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.client.LivingEntityFlyingSoundInstance;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.mixin.entities.LivingEntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.BumbleBeeChestplateFlyingPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BumbleBeeChestplate
extends BeeArmor {
    public BumbleBeeChestplate(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties, boolean transTexture, int variant) {
        super(material, slot, properties, variant, transTexture);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.BEE_ARMOR_REPAIR_ITEMS);
    }

    public void onArmorTick(ItemStack itemstack, Level world, Player player) {
        CompoundTag tag = itemstack.m_41784_();
        boolean isFlying = tag.m_128471_("isFlying");
        int flyCounter = tag.m_128451_("flyCounter");
        if (world.m_5776_()) {
            if (!(flyCounter <= 0 || player.m_20096_() || player.m_20069_() || !((LivingEntityAccessor)player).isJumping() || player.m_150110_().f_35935_ || player.m_20159_() || player.m_6147_())) {
                if (!isFlying) {
                    LivingEntityFlyingSoundInstance.playSound((LivingEntity)player, (SoundEvent)BzSounds.BUMBLE_BEE_CHESTPLATE_FLYING.get());
                    BumbleBeeChestplateFlyingPacket.sendToServer(true);
                    tag.m_128379_("isFlying", true);
                }
            } else if (isFlying) {
                LivingEntityFlyingSoundInstance.stopSound((LivingEntity)player, (SoundEvent)BzSounds.BUMBLE_BEE_CHESTPLATE_FLYING.get());
                BumbleBeeChestplateFlyingPacket.sendToServer(false);
                tag.m_128379_("isFlying", false);
            }
        }
        boolean isAllBeeArmorOn = StinglessBeeHelmet.isAllBeeArmorOn((Entity)player);
        MobEffectInstance beenergized = player.m_21124_((MobEffect)BzEffects.BEENERGIZED.get());
        boolean isBeenergized = beenergized != null;
        isFlying = tag.m_128471_("isFlying");
        if (isFlying) {
            if (flyCounter > 0) {
                double additiveSpeed;
                Vec3 velocity = player.m_20184_();
                double d = velocity.m_7098_() > 0.0 ? (velocity.m_7098_() > 0.1 ? 0.06 : 0.08) : (additiveSpeed = 0.13);
                if (isBeenergized) {
                    additiveSpeed += (double)(beenergized.m_19564_() + 1) * 0.0125;
                }
                double newYSpeed = velocity.m_7098_() + additiveSpeed;
                player.m_20334_(velocity.m_7096_(), newYSpeed, velocity.m_7094_());
                if (newYSpeed > -0.3) {
                    player.f_19789_ = 0.0f;
                } else if (newYSpeed <= -0.3) {
                    player.f_19789_ = (float)Math.abs(newYSpeed) / 0.3f + 1.75f;
                }
                tag.m_128405_("flyCounter", flyCounter - 1);
                if (!world.m_5776_() && player.m_217043_().m_188501_() < 0.0025f) {
                    itemstack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.CHEST));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_36220_((ResourceLocation)BzStats.BUMBLE_BEE_CHESTPLATE_FLY_TIME_RL.get());
                }
            } else {
                tag.m_128379_("isFlying", false);
                if (isBeenergized && isAllBeeArmorOn && player instanceof ServerPlayer) {
                    BzCriterias.BUMBLE_BEE_CHESTPLATE_MAX_FLIGHT_TRIGGER.trigger((ServerPlayer)player);
                }
            }
        }
        if (player.m_20096_()) {
            tag.m_128405_("flyCounter", (int)(20.0f * (isBeenergized ? 1.5f : 1.0f) * (float)(isAllBeeArmorOn ? 2 : 1)));
        }
        super.onArmorTick(itemstack, world, player);
    }

    public static ItemStack getEntityBeeChestplate(Entity entity) {
        for (ItemStack armor : entity.m_6168_()) {
            if (!(armor.m_41720_() instanceof BumbleBeeChestplate)) continue;
            return armor;
        }
        return ItemStack.f_41583_;
    }
}

