/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import com.telepathicgrunt.the_bumblezone.client.rendering.FluidClientOverlay;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class RoyalJellyFluidType
extends FluidType {
    public static final ResourceLocation ROYAL_JELLY_FLUID_STILL_TEXTURE = new ResourceLocation("the_bumblezone", "block/royal_jelly_fluid_still");
    public static final ResourceLocation ROYAL_JELLY_FLUID_FLOWING_TEXTURE = new ResourceLocation("the_bumblezone", "block/royal_jelly_fluid_flow");

    public RoyalJellyFluidType() {
        super(FluidType.Properties.create().supportsBoating(true).canHydrate(false).canDrown(true).canExtinguish(true).canPushEntity(true).canSwim(true).pathType(BlockPathTypes.WATER).adjacentPathType(BlockPathTypes.WATER_BORDER).canConvertToSource(false).fallDistanceModifier(0.15f).motionScale(0.0115).rarity(Rarity.UNCOMMON).viscosity(5000).density(2000).temperature(300).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ROYAL_JELLY_FLUID_STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return ROYAL_JELLY_FLUID_FLOWING_TEXTURE;
            }

            public ResourceLocation getOverlayTexture() {
                return ROYAL_JELLY_FLUID_FLOWING_TEXTURE;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return null;
            }

            public int getTintColor() {
                return -1;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                BlockPos blockpos = new BlockPos(camera.m_90592_().m_20185_(), camera.m_90592_().m_20188_(), camera.m_90592_().m_20189_());
                float brightnessAtEyes = LightTexture.m_234316_((DimensionType)camera.m_90592_().f_19853_.m_6042_(), (int)camera.m_90592_().f_19853_.m_46803_(blockpos));
                float brightness = (float)Math.max(Math.pow(FluidClientOverlay.getDimensionBrightnessAtEyes(camera.m_90592_()), 2.0), (double)brightnessAtEyes);
                float fogRed = 0.5f * brightness;
                float fogGreen = 0.0f;
                float fogBlue = 0.55f * brightness;
                return new Vector3f(fogRed, fogGreen, fogBlue);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.m_157445_((float)0.35f);
                RenderSystem.m_157443_((float)4.0f);
            }
        });
    }
}

