/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.telepathicgrunt.the_bumblezone.items.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class HoneyFluidBlock
extends LiquidBlock {
    public static final int maxBottomLayer = 8;
    public static final IntegerProperty BOTTOM_LEVEL = IntegerProperty.m_61631_((String)"bottom_level", (int)0, (int)8);
    public static final BooleanProperty ABOVE_FLUID = BooleanProperty.m_61465_((String)"above_support");

    public HoneyFluidBlock(Supplier<? extends FlowingFluid> fluid) {
        super(fluid, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60913_(100.0f, 100.0f).m_222994_().m_60956_(0.15f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54688_, (Comparable)Integer.valueOf(0))).m_61124_((Property)BOTTOM_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FlowingFluid.f_75947_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{f_54688_, BOTTOM_LEVEL, FlowingFluid.f_75947_, ABOVE_FLUID});
    }

    public void m_6861_(BlockState blockState, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (this.neighboringFluidInteractions(world, pos)) {
            world.m_186469_(pos, blockState.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)world));
        }
    }

    public void m_6807_(BlockState blockState, Level world, BlockPos blockPos, BlockState previousBlockState, boolean notify) {
        if (this.neighboringFluidInteractions(world, blockPos)) {
            world.m_186469_(blockPos, blockState.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)world));
        }
    }

    private boolean neighboringFluidInteractions(Level world, BlockPos pos) {
        boolean lavaflag = false;
        boolean lavadownflag = false;
        for (Direction direction : Direction.values()) {
            BlockPos sidePos = pos.m_121945_(direction);
            FluidState sideFluid = world.m_6425_(sidePos);
            if (sideFluid.m_205070_(FluidTags.f_13132_)) {
                lavaflag = true;
                if (direction != Direction.DOWN) break;
                lavadownflag = true;
                break;
            }
            if (sideFluid.m_76178_() || sideFluid.m_205070_(BzTags.VISUAL_HONEY_FLUID)) continue;
            FluidState currentFluid = world.m_6425_(pos);
            if (direction == Direction.DOWN && currentFluid.m_61138_((Property)BOTTOM_LEVEL) && (Integer)currentFluid.m_61143_((Property)BOTTOM_LEVEL) != 0) continue;
            if (direction == Direction.UP) {
                world.m_7731_(pos, ((Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get()).m_49966_(), 3);
                return false;
            }
            world.m_7731_(sidePos, ((Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get()).m_49966_(), 3);
        }
        if (lavaflag) {
            FluidState currentFluid = world.m_6425_(pos);
            if (currentFluid.m_76170_()) {
                world.m_46597_(pos, ((Block)BzBlocks.SUGAR_INFUSED_STONE.get()).m_49966_());
                this.triggerMixEffects(world, pos);
                return false;
            }
            if (currentFluid.m_76155_((BlockGetter)world, pos) >= 0.44444445f || lavadownflag && currentFluid.m_61138_((Property)BOTTOM_LEVEL) && (Integer)currentFluid.m_61143_((Property)BOTTOM_LEVEL) == 0) {
                world.m_46597_(pos, ((Block)BzBlocks.SUGAR_INFUSED_COBBLESTONE.get()).m_49966_());
                this.triggerMixEffects(world, pos);
                return false;
            }
        }
        return true;
    }

    public FluidState m_5888_(BlockState blockState) {
        int fluidLevel = Math.min(Math.max((Integer)blockState.m_61143_((Property)f_54688_), 0), 8);
        int bottomFluidLevel = Math.min(Math.max((Integer)blockState.m_61143_((Property)BOTTOM_LEVEL), 0), 8);
        boolean isFalling = (Boolean)blockState.m_61143_((Property)FlowingFluid.f_75947_);
        FluidState fluidState = fluidLevel == 0 ? this.getFluid().m_76068_(false) : (FluidState)this.getFluid().m_75953_(fluidLevel, isFalling).m_61124_((Property)BOTTOM_LEVEL, (Comparable)Integer.valueOf(bottomFluidLevel));
        return (FluidState)fluidState.m_61124_((Property)ABOVE_FLUID, (Comparable)((Boolean)blockState.m_61143_((Property)ABOVE_FLUID)));
    }

    public void m_7892_(BlockState state, Level world, BlockPos position, Entity entity) {
        ServerPlayer serverPlayer;
        double verticalSpeedDeltaLimit = 0.01;
        if (entity instanceof Bee) {
            Bee beeEntity = (Bee)entity;
            if (beeEntity.m_21223_() < beeEntity.m_21233_() && entity.getEyeInFluidType().isAir()) {
                float diff = beeEntity.m_21233_() - beeEntity.m_21223_();
                beeEntity.m_5634_(diff);
                BlockState currentState = world.m_8055_(position);
                if (currentState.m_60713_((Block)BzFluids.HONEY_FLUID_BLOCK.get())) {
                    world.m_7731_(position, (BlockState)currentState.m_61124_((Property)f_54688_, (Comparable)Integer.valueOf(Math.max((Integer)currentState.m_61143_((Property)f_54688_) - (int)Math.ceil(diff), 1))), 3);
                }
            }
        } else if (Math.abs(entity.m_20184_().m_7098_()) > verticalSpeedDeltaLimit && (double)entity.f_19789_ <= 0.2) {
            Vec3 vec3 = entity.m_20184_();
            entity.m_20256_(new Vec3(vec3.m_7096_(), Math.copySign(verticalSpeedDeltaLimit, vec3.m_7098_()), vec3.m_7094_()));
        }
        if (entity instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity)) {
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, 0, false, false, true));
        }
        super.m_7892_(state, world, position, entity);
    }

    private void triggerMixEffects(Level world, BlockPos pos) {
        world.m_46796_(1501, pos, 0);
    }
}

