/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.queentrades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueenTradesCollectionObj;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.TradeEntryObj;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.TradeEntryReducedObj;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class QueensTradeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final QueensTradeManager QUEENS_TRADE_MANAGER = new QueensTradeManager();
    public Object2ObjectOpenHashMap<Item, WeightedRandomList<TradeEntryReducedObj>> tradeReduced = new Object2ObjectOpenHashMap();
    public Map<Pair<List<TradeEntryObj>, Boolean>, List<TradeEntryObj>> tradeRaw = new HashMap<Pair<List<TradeEntryObj>, Boolean>, List<TradeEntryObj>>();
    public List<TradeEntryReducedObj> tradeRandomizer = new ArrayList<TradeEntryReducedObj>();

    public QueensTradeManager() {
        super(GSON, "bz_bee_queen_trades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        this.tradeRaw.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                QueenTradesCollectionObj tradesCollection = (QueenTradesCollectionObj)GSON.fromJson(jsonElement, QueenTradesCollectionObj.class);
                if (tradesCollection.is_color_randomizer_trade) {
                    if (!tradesCollection.randomizes.isEmpty()) {
                        this.tradeRaw.put((Pair<List<TradeEntryObj>, Boolean>)Pair.of(tradesCollection.randomizes, (Object)true), tradesCollection.randomizes);
                    }
                    return;
                }
                if (tradesCollection.wants.isEmpty() || tradesCollection.possible_rewards.isEmpty()) {
                    return;
                }
                this.tradeRaw.put((Pair<List<TradeEntryObj>, Boolean>)Pair.of(tradesCollection.wants, (Object)false), tradesCollection.possible_rewards);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse bee queen trades file {}", fileIdentifier, (Object)e);
            }
        });
    }

    public void resolveQueenTrades(TagsUpdatedEvent event) {
        if (this.tradeRaw.isEmpty()) {
            return;
        }
        ArrayList<TradeEntryReducedObj> randomizerTrades = new ArrayList<TradeEntryReducedObj>();
        Object2ObjectOpenHashMap reducedTradeMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<Pair<List<TradeEntryObj>, Boolean>, List<TradeEntryObj>> entry : this.tradeRaw.entrySet()) {
            ArrayList<Item> wants = new ArrayList<Item>();
            ArrayList rewards = new ArrayList();
            ((List)entry.getKey().getFirst()).forEach(value -> {
                Set<Object> items = null;
                if (value.id.startsWith("#")) {
                    ResourceLocation tagRl = new ResourceLocation(value.id.substring(1));
                    TagKey itemTag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagRl);
                    Optional taggedItems = Registry.f_122827_.m_203431_(itemTag);
                    if (taggedItems.isPresent()) {
                        items = ((HolderSet.Named)taggedItems.get()).m_203614_().map(Holder::m_203334_).collect(Collectors.toSet());
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find want items tag {} in bee queen trades file", (Object)value.id);
                    }
                } else {
                    Optional item = ForgeRegistries.ITEMS.getHolder(new ResourceLocation(value.id));
                    if (item.isPresent()) {
                        items = Set.of((Item)((Holder)item.get()).m_203334_());
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find want items {} in bee queen trades file", (Object)value.id);
                    }
                }
                if (items == null) {
                    return;
                }
                wants.addAll(items);
            });
            if (wants.isEmpty()) continue;
            if (((Boolean)entry.getKey().getSecond()).booleanValue()) {
                randomizerTrades.add(new TradeEntryReducedObj(wants, 1, 0, 1));
            }
            AtomicInteger totalGroupWeight = new AtomicInteger();
            entry.getValue().forEach(value -> {
                if (value.id.startsWith("#")) {
                    ResourceLocation tagRl = new ResourceLocation(value.id.substring(1));
                    TagKey itemTag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagRl);
                    Optional taggedItems = Registry.f_122827_.m_203431_(itemTag);
                    taggedItems.ifPresent(holders -> totalGroupWeight.addAndGet(value.getWeight() * holders.m_203632_()));
                } else {
                    Optional item = ForgeRegistries.ITEMS.getHolder(new ResourceLocation(value.id));
                    item.ifPresent(holder -> totalGroupWeight.addAndGet(value.getWeight()));
                }
            });
            entry.getValue().forEach(value -> {
                if (value.id.startsWith("#")) {
                    ResourceLocation tagRl = new ResourceLocation(value.id.substring(1));
                    TagKey itemTag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagRl);
                    Optional taggedItems = Registry.f_122827_.m_203431_(itemTag);
                    if (taggedItems.isPresent()) {
                        List<Item> rewardGroup = ((HolderSet.Named)taggedItems.get()).m_203614_().map(Holder::get).collect(Collectors.toList());
                        rewards.add(new TradeEntryReducedObj(rewardGroup, value.getCount(), value.getXpReward(), value.getWeight() * rewardGroup.size(), totalGroupWeight.get(), (Boolean)((Pair)entry.getKey()).getSecond()));
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find rewards items tag {} in bee queen trades file", (Object)value.id);
                    }
                } else {
                    Optional item = ForgeRegistries.ITEMS.getHolder(new ResourceLocation(value.id));
                    if (item.isPresent()) {
                        rewards.add(new TradeEntryReducedObj(List.of((Item)((Holder)item.get()).m_203334_()), value.getCount(), value.getXpReward(), value.getWeight(), totalGroupWeight.get(), (Boolean)((Pair)entry.getKey()).getSecond()));
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find rewards items {} in bee queen trades file", (Object)value.id);
                    }
                }
            });
            if (rewards.isEmpty()) continue;
            for (Item item : wants) {
                WeightedRandomList existingRewards = (WeightedRandomList)reducedTradeMap.get((Object)item);
                if (existingRewards == null) {
                    reducedTradeMap.put((Object)item, (Object)WeightedRandomList.m_146328_(rewards));
                    continue;
                }
                ArrayList newWants = new ArrayList();
                newWants.addAll(existingRewards.m_146338_());
                newWants.addAll(rewards);
                reducedTradeMap.put((Object)item, (Object)WeightedRandomList.m_146328_(newWants));
            }
        }
        this.tradeReduced = reducedTradeMap;
        this.tradeRandomizer = randomizerTrades;
        this.tradeRaw.clear();
    }
}

