/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modcompat.ArsNouveauCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzWorldSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTeleportationHookup {
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            List poiInRange;
            ServerLevel serverLevel;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level level = serverPlayer.f_19853_;
            if (level instanceof ServerLevel && ((serverLevel = (ServerLevel)level).m_46467_() + serverPlayer.m_20148_().getLeastSignificantBits()) % 100L == 0L && !serverLevel.m_46472_().equals(BzDimension.BZ_WORLD_KEY) && (poiInRange = serverLevel.m_8904_().m_27166_(pointOfInterestType -> pointOfInterestType.m_203656_(BzTags.IS_NEAR_BEEHIVE_ADVANCEMENT_TRIGGER_POI), serverPlayer.m_20183_(), 8, PoiManager.Occupancy.ANY).toList()).size() > 0) {
                BzCriterias.IS_NEAR_BEEHIVE_TRIGGER.trigger(serverPlayer);
            }
        }
    }

    public static void entityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (livingEntity.m_20186_() < -2.0) {
                if (((Boolean)BzDimensionConfigs.enableExitTeleportation.get()).booleanValue()) {
                    if (livingEntity instanceof ServerPlayer) {
                        BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger((ServerPlayer)livingEntity);
                    }
                    if (livingEntity.m_20186_() < -4.0) {
                        livingEntity.m_6027_(livingEntity.m_20185_(), -4.0, livingEntity.m_20189_());
                        livingEntity.m_20248_(livingEntity.m_20185_(), -4.0, livingEntity.m_20189_());
                        livingEntity.m_20334_(0.0, 0.0, 0.0);
                        if (!livingEntity.f_19853_.m_5776_()) {
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 12, 100, false, false, true));
                        }
                    }
                    livingEntity.f_19789_ = 0.0f;
                    if (!livingEntity.f_19853_.m_5776_()) {
                        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                    }
                }
            } else if (livingEntity.m_20186_() > 255.0 && ((Boolean)BzDimensionConfigs.enableExitTeleportation.get()).booleanValue()) {
                if (livingEntity instanceof ServerPlayer) {
                    BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger((ServerPlayer)livingEntity);
                }
                if (livingEntity.m_20186_() > 257.0) {
                    livingEntity.m_6027_(livingEntity.m_20185_(), 257.0, livingEntity.m_20189_());
                    livingEntity.m_20248_(livingEntity.m_20185_(), 257.0, livingEntity.m_20189_());
                }
                if (!livingEntity.f_19853_.m_5776_()) {
                    EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                }
            }
        }
    }

    public static void teleportOutOfBz(LivingEntity livingEntity) {
        if (!livingEntity.f_19853_.m_5776_()) {
            ServerLevel serverWorld;
            EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity);
            MinecraftServer minecraftServer = livingEntity.m_20194_();
            ResourceKey worldKey = null;
            if (livingEntity.m_6688_() == null) {
                capOptional = livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY);
                if (capOptional.isPresent()) {
                    EntityPositionAndDimension capability = (EntityPositionAndDimension)capOptional.orElseThrow(RuntimeException::new);
                    worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)capability.getNonBZDim());
                }
            } else {
                Object capability = livingEntity.m_6688_();
                if (capability instanceof LivingEntity) {
                    LivingEntity livingEntity2 = (LivingEntity)capability;
                    EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity2);
                }
                if ((capOptional = livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY)).isPresent()) {
                    capability = (EntityPositionAndDimension)capOptional.orElseThrow(RuntimeException::new);
                    worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)((EntityPositionAndDimension)capability).getNonBZDim());
                }
            }
            ServerLevel serverLevel = serverWorld = worldKey == null ? null : minecraftServer.m_129880_(worldKey);
            if (serverWorld == null) {
                serverWorld = minecraftServer.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get())));
            }
            BzWorldSavedData.queueEntityToTeleport((Entity)livingEntity, (ResourceKey<Level>)serverWorld.m_46472_());
        }
    }

    public static boolean runTeleportProjectileImpact(HitResult hitResult, Entity thrower, Entity projectile) {
        if (thrower == null || thrower.f_19853_ == null) {
            return false;
        }
        Level world = thrower.f_19853_;
        if (EntityTeleportationHookup.isTeleportAllowedInDimension(world)) {
            BlockHitResult blockHitResult;
            BlockState block;
            BlockPos hivePos = null;
            if (hitResult instanceof BlockHitResult && EntityTeleportationBackend.isValidBeeHive(block = world.m_8055_((blockHitResult = (BlockHitResult)hitResult).m_82425_()))) {
                hivePos = blockHitResult.m_82425_();
            }
            if (hivePos == null) {
                hivePos = EntityTeleportationHookup.getNearbyHivePos(hitResult.m_82450_(), world);
            }
            if (hivePos == null && projectile != null) {
                hivePos = EntityTeleportationHookup.getNearbyHivePos(hitResult.m_82450_().m_82549_(projectile.m_20184_()), world);
            }
            if (hivePos == null) {
                return false;
            }
            boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(world, thrower, hivePos);
            if (validBelowBlock) {
                EntityTeleportationHookup.performTeleportation(thrower, projectile);
                return true;
            }
        }
        return false;
    }

    public static boolean runEntityHitCheck(HitResult hitResult, Entity thrower, Projectile projectile) {
        if (thrower == null || thrower.f_19853_ == null) {
            return false;
        }
        Level world = thrower.f_19853_;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            if (EntityTeleportationHookup.isTeleportAllowedInDimension(world)) {
                Entity hitEntity = entityHitResult.m_82443_();
                boolean passedCheck = false;
                if (ModChecker.arsNouveauPresent && ArsNouveauCompat.isArsWalkingBlock(hitEntity) && !ArsNouveauCompat.isArsWalkingBlockAvalidBeeHive(hitEntity)) {
                    return false;
                }
                if (hitEntity.m_6095_().m_204039_(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_ANYWHERE) || hitEntity.m_6095_().m_204039_(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH) || hitEntity.m_6095_().m_204039_(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_LOW)) {
                    Vec3 hitPos = hitResult.m_82450_();
                    AABB boundBox = entityHitResult.m_82443_().m_20191_();
                    double relativeHitY = hitPos.m_7098_() - boundBox.f_82289_;
                    double entityBoundHeight = boundBox.f_82292_ - boundBox.f_82289_;
                    double minYThreshold = -2.147483648E9;
                    double maxYThreshold = 2.147483647E9;
                    if (hitEntity.m_6095_().m_204039_(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH)) {
                        minYThreshold = entityBoundHeight / 2.0;
                    }
                    if (hitEntity.m_6095_().m_204039_(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH)) {
                        maxYThreshold = entityBoundHeight / 2.0;
                    }
                    if (minYThreshold != maxYThreshold && (relativeHitY > maxYThreshold || relativeHitY < minYThreshold)) {
                        return false;
                    }
                    passedCheck = true;
                }
                for (ItemStack stack : hitEntity.m_6167_()) {
                    if (stack == null || !stack.m_204117_(BzTags.TARGET_WITH_HELD_ITEM_HIT_BY_TELEPORT_PROJECTILE)) continue;
                    passedCheck = true;
                    break;
                }
                for (ItemStack stack : hitEntity.m_6168_()) {
                    if (stack == null || !stack.m_204117_(BzTags.TARGET_ARMOR_HIT_BY_TELEPORT_PROJECTILE)) continue;
                    passedCheck = true;
                }
                if (!passedCheck) {
                    return false;
                }
                BlockPos hivePos = entityHitResult.m_82443_().m_20183_();
                boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(world, thrower, hivePos);
                if (validBelowBlock) {
                    EntityTeleportationHookup.performTeleportation(thrower, (Entity)projectile);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean runItemUseOn(Player user, BlockPos clickedPos, BlockState blockstate, ItemStack usingStack) {
        Level world = user.f_19853_;
        if (EntityTeleportationHookup.isTeleportAllowedInDimension(world)) {
            boolean isAllowTeleportItem;
            if (!EntityTeleportationBackend.isValidBeeHive(blockstate)) {
                return false;
            }
            boolean bl = isAllowTeleportItem = usingStack.m_204117_(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE) || usingStack.m_204117_(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE_CROUCHING) && user.m_6144_();
            if (!isAllowTeleportItem) {
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)usingStack);
                for (Enchantment enchantment : enchantments.keySet()) {
                    if (Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.tags()).getTag(BzTags.ITEM_WITH_TELEPORT_ENCHANT).contains((Object)enchantment)) {
                        isAllowTeleportItem = true;
                        break;
                    }
                    if (!user.m_6144_() || !Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.tags()).getTag(BzTags.ITEM_WITH_TELEPORT_ENCHANT_CROUCHING).contains((Object)enchantment)) continue;
                    isAllowTeleportItem = true;
                    break;
                }
            }
            if (!isAllowTeleportItem) {
                return false;
            }
            boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(world, (Entity)user, clickedPos);
            if (validBelowBlock) {
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    BzWorldSavedData.queueEntityToTeleport((Entity)serverPlayer, BzDimension.BZ_WORLD_KEY);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTeleportAllowedInDimension(Level level) {
        if (!((Boolean)BzDimensionConfigs.enableEntranceTeleportation.get()).booleanValue() || level.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            return false;
        }
        if (((Boolean)BzDimensionConfigs.onlyOverworldHivesTeleports.get()).booleanValue()) {
            ResourceLocation defaultDimRL = new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get());
            ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)defaultDimRL);
            return level.m_46472_().equals((Object)worldKey);
        }
        return true;
    }

    private static void performTeleportation(Entity thrower, Entity projectile) {
        if (thrower instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)thrower;
            if (projectile != null) {
                if (Registry.f_122826_.m_7981_((Object)projectile.m_6095_()).m_135815_().contains("pearl")) {
                    BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(serverPlayer);
                }
                projectile.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            BzWorldSavedData.queueEntityToTeleport((Entity)serverPlayer, BzDimension.BZ_WORLD_KEY);
        }
    }

    private static boolean isValidBelowBlock(Level world, Entity playerEntity, BlockPos hivePos) {
        Optional blockTag = Registry.f_122824_.m_203431_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
        if (blockTag.isPresent() && GeneralUtils.getListOfNonDummyBlocks(blockTag).size() != 0) {
            if (world.m_8055_(hivePos.m_7495_()).m_204336_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) {
                return true;
            }
            if (((Boolean)BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive.get()).booleanValue() && playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                Bumblezone.LOGGER.info("Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.require_hive_blocks_failed");
                serverPlayer.m_5661_((Component)message, true);
            }
        } else {
            return true;
        }
        return false;
    }

    private static BlockPos getNearbyHivePos(Vec3 hitBlockPos, Level world) {
        double checkRadius = 0.5;
        for (double offset = -checkRadius; offset <= checkRadius; offset += checkRadius) {
            for (double offset2 = -checkRadius; offset2 <= checkRadius; offset2 += checkRadius) {
                for (double offset3 = -checkRadius; offset3 <= checkRadius; offset3 += checkRadius) {
                    BlockPos offsettedHitPos = new BlockPos(hitBlockPos.m_82520_(offset, offset2, offset3));
                    BlockState block = world.m_8055_(offsettedHitPos);
                    if (!EntityTeleportationBackend.isValidBeeHive(block)) continue;
                    return offsettedHitPos;
                }
            }
        }
        return null;
    }

    public static void runPistonPushed(Direction direction, LivingEntity pushedEntity) {
        ServerLevel world = (ServerLevel)pushedEntity.f_19853_;
        if (((Boolean)BzDimensionConfigs.enableEntranceTeleportation.get()).booleanValue() && !world.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) && (!((Boolean)BzDimensionConfigs.onlyOverworldHivesTeleports.get()).booleanValue() || world.m_46472_().equals((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get()))))) {
            if (BzWorldSavedData.isEntityQueuedToTeleportAlready((Entity)pushedEntity)) {
                return;
            }
            BlockPos.MutableBlockPos entityPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pushedEntity.m_20183_());
            BlockPos[] blockPositions = new BlockPos[]{entityPos, entityPos.m_121945_(direction), entityPos.m_121945_(Direction.UP), entityPos.m_121945_(Direction.UP).m_121945_(direction)};
            ArrayList<BlockState> belowHiveBlocks = new ArrayList<BlockState>();
            boolean isPushedIntoBeehive = false;
            for (BlockPos pos : blockPositions) {
                if (!EntityTeleportationBackend.isValidBeeHive(world.m_8055_(pos))) continue;
                isPushedIntoBeehive = true;
                belowHiveBlocks.add(world.m_8055_(pos.m_7495_()));
            }
            if (isPushedIntoBeehive) {
                boolean validBelowBlock = false;
                Optional blockTag = Registry.f_122824_.m_203431_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && GeneralUtils.getListOfNonDummyBlocks(blockTag).size() != 0) {
                    for (BlockState belowBlock : belowHiveBlocks) {
                        if (!belowBlock.m_204336_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) continue;
                        validBelowBlock = true;
                    }
                    if (!validBelowBlock && ((Boolean)BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive.get()).booleanValue()) {
                        if (pushedEntity instanceof Player) {
                            Player playerEntity = (Player)pushedEntity;
                            Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                            MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.require_hive_blocks_failed");
                            playerEntity.m_5661_((Component)message, true);
                        }
                        return;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    if (pushedEntity instanceof ServerPlayer) {
                        BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.trigger((ServerPlayer)pushedEntity);
                    }
                    BzWorldSavedData.queueEntityToTeleport((Entity)pushedEntity, BzDimension.BZ_WORLD_KEY);
                }
            }
        }
    }

    private static void checkAndCorrectStoredDimension(LivingEntity livingEntity) {
        livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capability -> {
            if (capability.getNonBZDim().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzDimensionConfigs.forceExitToOverworld.get()).booleanValue()) {
                capability.setNonBZDim(new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get()));
            }
        });
    }
}

