/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.beearmor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.BumbleBeeChestplate;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BeeArmorModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation VARIANT_1_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_bumblezone", "bee_armor"), "bee_armor");
    public static final ModelLayerLocation VARIANT_2_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_bumblezone", "bee_armor"), "bee_armor_2");
    protected final EquipmentSlot slot;
    public LivingEntity entityLiving;
    public final ModelPart leftWing;
    public final ModelPart rightWing;
    public final ModelPart leftPollen;
    public final ModelPart rightPollen;
    public final ModelPart trueRightLeg;
    public final ModelPart trueLeftLeg;
    public final ModelPart bootRight;
    public final ModelPart bootLeft;

    public BeeArmorModel(ModelPart part, EquipmentSlot slot, LivingEntity livingEntity) {
        super(part);
        this.slot = slot;
        this.entityLiving = livingEntity;
        this.leftWing = part.m_171324_("body").m_171324_("left_wing");
        this.rightWing = part.m_171324_("body").m_171324_("right_wing");
        this.leftPollen = part.m_171324_("left_leg").m_171324_("true_left_leg").m_171324_("pollen_left");
        this.rightPollen = part.m_171324_("right_leg").m_171324_("true_right_leg").m_171324_("pollen_right");
        this.trueLeftLeg = part.m_171324_("left_leg").m_171324_("true_left_leg");
        this.trueRightLeg = part.m_171324_("right_leg").m_171324_("true_right_leg");
        this.bootRight = part.m_171324_("right_leg").m_171324_("right_boot");
        this.bootLeft = part.m_171324_("left_leg").m_171324_("left_boot");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int light, int overlay, float r, float g, float b, float a) {
        this.m_8009_(false);
        switch (this.slot) {
            case HEAD: {
                this.f_102808_.f_104207_ = true;
                this.f_102809_.f_104207_ = true;
                this.f_102808_.m_104301_(poseStack, buffer, light, overlay);
                break;
            }
            case CHEST: {
                this.f_102810_.f_104207_ = true;
                this.f_102811_.f_104207_ = true;
                this.f_102812_.f_104207_ = true;
                ItemStack itemStack = BumbleBeeChestplate.getEntityBeeChestplate((Entity)this.entityLiving);
                if (!itemStack.m_41619_() && itemStack.m_41784_().m_128471_("isFlying")) {
                    BeeArmor beeArmor;
                    long time = System.currentTimeMillis();
                    double currentProg = Math.abs(Math.sin((double)time / 40.0));
                    this.leftWing.f_104204_ = -45.0f;
                    this.leftWing.f_104203_ = (float)Mth.m_14139_((double)currentProg, (double)-0.5, (double)1.5);
                    this.rightWing.f_104204_ = 45.0f;
                    this.rightWing.f_104203_ = (float)Mth.m_14139_((double)currentProg, (double)-0.5, (double)1.5);
                    Item item = itemStack.m_41720_();
                    if (item instanceof BeeArmor && (beeArmor = (BeeArmor)item).getVariant() == 2) {
                        this.rightWing.f_104205_ = 0.0f;
                    }
                } else {
                    BeeArmor beeArmor;
                    Item item = itemStack.m_41720_();
                    if (item instanceof BeeArmor && (beeArmor = (BeeArmor)item).getVariant() == 2) {
                        this.leftWing.f_104204_ = -0.2f;
                        this.leftWing.f_104203_ = -0.15f;
                        this.rightWing.f_104204_ = 0.2f;
                        this.rightWing.f_104203_ = -0.2f;
                        this.rightWing.f_104205_ = -0.5f;
                    } else {
                        this.leftWing.f_104204_ = -0.6f;
                        this.leftWing.f_104203_ = -0.2f;
                        this.rightWing.f_104204_ = 0.6f;
                        this.rightWing.f_104203_ = -0.2f;
                    }
                }
                this.f_102810_.m_104301_(poseStack, buffer, light, overlay);
                break;
            }
            case LEGS: {
                this.f_102810_.f_104207_ = true;
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                this.trueRightLeg.f_104207_ = true;
                this.trueLeftLeg.f_104207_ = true;
                this.bootRight.f_104207_ = false;
                this.bootLeft.f_104207_ = false;
                ItemStack itemStack = HoneyBeeLeggings.getEntityBeeLegging((Entity)this.entityLiving);
                if (!itemStack.m_41619_() && HoneyBeeLeggings.isPollinated(itemStack)) {
                    this.leftPollen.f_104207_ = true;
                    this.rightPollen.f_104207_ = true;
                } else {
                    this.leftPollen.f_104207_ = false;
                    this.rightPollen.f_104207_ = false;
                }
                this.f_102814_.m_104301_(poseStack, buffer, light, overlay);
                this.f_102813_.m_104301_(poseStack, buffer, light, overlay);
                break;
            }
            case FEET: {
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                this.bootRight.f_104207_ = true;
                this.bootLeft.f_104207_ = true;
                this.trueRightLeg.f_104207_ = false;
                this.trueLeftLeg.f_104207_ = false;
                this.f_102814_.m_104301_(poseStack, buffer, light, overlay);
                this.f_102813_.m_104301_(poseStack, buffer, light, overlay);
            }
        }
    }

    public static LayerDefinition createVariant1() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition armorHead = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -9.0f, -6.0f, 10.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition cube_r1 = armorHead.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(28, 82).m_171488_(1.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 82).m_171488_(-3.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 89).m_171488_(2.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(20, 89).m_171488_(-3.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = armorHead.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(40, 82).m_171488_(-3.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 82).m_171488_(2.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition armorBody = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-4.505f, 4.0f, -2.505f, 9.01f, 8.0f, 5.01f, new CubeDeformation(0.0f)).m_171514_(32, 66).m_171488_(-3.5f, 2.0f, -2.5f, 7.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 82).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition cube_r3 = armorBody.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(36, 82).m_171488_(-1.0f, 6.5f, -9.25f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = armorBody.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.82f, (float)3.1027f, (float)2.1854f));
        PartDefinition LeftWing_r1 = left_wing.m_171599_("LeftWing_r1", CubeListBuilder.m_171558_().m_171514_(0, 89).m_171488_(-0.25f, -2.75f, 3.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(1, 87).m_171488_(-0.25f, -0.75f, 4.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(3, 89).m_171488_(-0.25f, -1.75f, 6.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(4, 90).m_171488_(-0.25f, -2.75f, 7.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(1, 91).m_171488_(-0.25f, -4.75f, 4.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(2, 93).m_171488_(-0.25f, -5.75f, 5.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(3, 91).m_171488_(-0.25f, -4.75f, 6.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(3, 93).m_171488_(-0.25f, -6.75f, 6.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(5, 91).m_171488_(-0.25f, -5.75f, 8.5f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5623f, (float)-3.1027f, (float)-2.1854f, (float)-0.6695f, (float)0.7911f, (float)1.3711f));
        PartDefinition right_wing = armorBody.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0946f, (float)2.7065f, (float)2.1491f));
        PartDefinition RightWing_r1 = right_wing.m_171599_("RightWing_r1", CubeListBuilder.m_171558_().m_171514_(12, 91).m_171488_(-1.0f, -10.25f, 3.75f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(10, 93).m_171488_(-1.0f, -11.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(10, 91).m_171488_(-1.0f, -9.25f, 1.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(9, 93).m_171488_(-1.0f, -10.25f, 0.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 91).m_171488_(-1.0f, -9.25f, -0.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(11, 90).m_171488_(-1.0f, -7.25f, 2.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(10, 89).m_171488_(-1.0f, -6.25f, 1.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 87).m_171488_(-1.0f, -5.25f, -0.25f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(7, 89).m_171488_(-1.0f, -7.25f, -1.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0946f, (float)-2.7065f, (float)-2.1491f, (float)-0.9071f, (float)0.8312f, (float)1.7963f));
        PartDefinition right_leg_main = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = right_leg_main.m_171599_("true_right_leg", CubeListBuilder.m_171558_().m_171514_(20, 37).m_171488_(-2.75f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_right = right_leg.m_171599_("pollen_right", CubeListBuilder.m_171558_().m_171514_(40, 37).m_171488_(1.005f, 1.25f, -2.995f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition bootRight = right_leg_main.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(52, 44).m_171488_(-1.0f, 6.25f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 96).m_171488_(-3.0f, 7.0f, -4.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_main = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = left_leg_main.m_171599_("true_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-2.25f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_left = left_leg.m_171599_("pollen_left", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(3.0f, 1.25f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition bootLeft = left_leg_main.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(0, 96).m_171488_(-3.0f, 7.0f, -4.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(52, 44).m_171488_(-1.0f, 6.25f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static LayerDefinition createVariant2() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition armorHead = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -9.0f, -6.0f, 10.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.25f, (float)0.0f));
        PartDefinition antennas = armorHead.m_171599_("antennas", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)3.0f));
        PartDefinition cube_r1 = antennas.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(28, 82).m_171488_(1.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 82).m_171488_(-3.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 89).m_171488_(2.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(20, 89).m_171488_(-3.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = antennas.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(40, 82).m_171488_(-3.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 82).m_171488_(2.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition armorBody = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-4.505f, 0.0f, -2.505f, 9.01f, 12.0f, 5.01f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition cube_r3 = armorBody.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(36, 82).m_171488_(-0.5f, 0.5f, 0.75f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = armorBody.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0946f, (float)2.9565f, (float)2.3991f));
        PartDefinition RightWing_r1 = right_wing.m_171599_("RightWing_r1", CubeListBuilder.m_171558_().m_171514_(13, 77).m_171488_(-1.0f, -10.25f, 3.75f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(9, 85).m_171488_(-1.0f, -9.25f, 1.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(10, 82).m_171488_(-1.0f, -11.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(6, 86).m_171488_(-1.0f, -10.25f, 0.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(6, 86).m_171488_(-1.0f, -6.25f, 1.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(3, 86).m_171488_(-1.0f, -7.25f, 2.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 85).m_171488_(-1.0f, -9.25f, -0.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 77).m_171488_(-1.0f, -5.25f, -0.25f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 85).m_171488_(-1.0f, -7.25f, -1.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.8446f, (float)-2.9565f, (float)-2.8991f, (float)-0.9071f, (float)0.8312f, (float)1.7963f));
        PartDefinition left_wing = armorBody.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.1554f, (float)2.9565f, (float)2.3991f));
        PartDefinition LeftWing_r1 = left_wing.m_171599_("LeftWing_r1", CubeListBuilder.m_171558_().m_171514_(5, 74).m_171488_(-1.0f, -10.25f, 1.75f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(5, 82).m_171488_(-1.0f, -8.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 85).m_171488_(-1.0f, -9.25f, 4.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(6, 86).m_171488_(-1.0f, -7.25f, 3.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(6, 86).m_171488_(-1.0f, -8.25f, -0.25f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(3, 86).m_171488_(-1.0f, -9.25f, 0.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(10, 82).m_171488_(-1.0f, -6.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 82).m_171488_(-1.0f, -5.25f, -0.25f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 80).m_171488_(-1.0f, -7.25f, -1.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.8446f, (float)-2.9565f, (float)-2.8991f, (float)-0.9071f, (float)0.8312f, (float)1.7963f));
        PartDefinition right_leg_main = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = right_leg_main.m_171599_("true_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_right = right_leg.m_171599_("pollen_right", CubeListBuilder.m_171558_().m_171514_(40, 37).m_171488_(-2.995f, 1.5f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_boot = right_leg_main.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(0, 96).m_171488_(-3.0f, 7.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.005f)).m_171514_(22, 107).m_171488_(-2.901f, 7.9f, -2.1f, 5.0f, 4.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_main = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = left_leg_main.m_171599_("true_left_leg", CubeListBuilder.m_171558_().m_171514_(20, 37).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_left = left_leg.m_171599_("pollen_left", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(0.005f, 1.5f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_boot = left_leg_main.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(0, 96).m_171488_(-2.0f, 7.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.005f)).m_171514_(22, 98).m_171488_(-2.099f, 7.9f, -2.1f, 5.0f, 4.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }
}

