/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.bakedmodel;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.telepathicgrunt.the_bumblezone.client.bakedmodel.PorousHoneycombLoader;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

public class PorousHoneycombBlockModel
implements IDynamicBakedModel {
    private static final ChunkRenderTypeSet CUTOUT_CHUNK_RENDER_TYPE = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    public static final ModelProperty<Map<Direction, Set<CORNERS>>> DIRECTION_OF_HONEY_MERGERS = new ModelProperty();
    public static final List<PorousHoneycombBlockModel> INSTANCES = new ArrayList<PorousHoneycombBlockModel>();
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Direction.AxisDirection[] AXIS_DIRECTIONS = Direction.AxisDirection.values();
    public static final ModelResourceLocation BACKING_DIRT_MODEL = new ModelResourceLocation("minecraft", "dirt", "inventory");
    public static final ResourceLocation BLOCK_ATLAS = TextureAtlas.f_118259_;
    private final ResourceLocation modelLocation;
    private final ResourceLocation topLeft;
    private final ResourceLocation topRight;
    private final ResourceLocation botLeft;
    private final ResourceLocation botRight;
    private final ResourceLocation particle;
    private final ResourceLocation base;
    private TextureAtlasSprite particleTex;
    private Map<Direction, BakedModel[]> cache;
    private BakedModel mainModel;

    private void checkAdjacent(BlockAndTintGetter level, BlockPos.MutableBlockPos mutable, BlockPos origin, Map<Direction, Set<CORNERS>> map) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (!this.needsConnection(level, (BlockPos)mutable.m_122159_((Vec3i)origin, d))) continue;
            Set<CORNERS> ccw = map.get(d.m_122428_());
            Set<CORNERS> cw = map.get(d.m_122427_());
            Set<CORNERS> up = map.get(Direction.UP);
            Set<CORNERS> down = map.get(Direction.DOWN);
            if (d == Direction.EAST) {
                ccw.add(CORNERS.TOP_LEFT);
                ccw.add(CORNERS.BOTTOM_LEFT);
                cw.add(CORNERS.TOP_LEFT);
                cw.add(CORNERS.BOTTOM_LEFT);
                up.add(CORNERS.TOP_LEFT);
                up.add(CORNERS.BOTTOM_LEFT);
                down.add(CORNERS.TOP_LEFT);
                down.add(CORNERS.BOTTOM_LEFT);
                continue;
            }
            if (d == Direction.WEST) {
                cw.add(CORNERS.TOP_RIGHT);
                cw.add(CORNERS.BOTTOM_RIGHT);
                ccw.add(CORNERS.TOP_RIGHT);
                ccw.add(CORNERS.BOTTOM_RIGHT);
                down.add(CORNERS.TOP_RIGHT);
                down.add(CORNERS.BOTTOM_RIGHT);
                up.add(CORNERS.TOP_RIGHT);
                up.add(CORNERS.BOTTOM_RIGHT);
                continue;
            }
            if (d == Direction.SOUTH) {
                cw.add(CORNERS.BOTTOM_LEFT);
                cw.add(CORNERS.TOP_LEFT);
                ccw.add(CORNERS.BOTTOM_LEFT);
                ccw.add(CORNERS.TOP_LEFT);
                down.add(CORNERS.TOP_RIGHT);
                down.add(CORNERS.TOP_LEFT);
                up.add(CORNERS.TOP_RIGHT);
                up.add(CORNERS.TOP_LEFT);
                continue;
            }
            if (d != Direction.NORTH) continue;
            cw.add(CORNERS.BOTTOM_RIGHT);
            cw.add(CORNERS.TOP_RIGHT);
            ccw.add(CORNERS.BOTTOM_RIGHT);
            ccw.add(CORNERS.TOP_RIGHT);
            down.add(CORNERS.BOTTOM_RIGHT);
            down.add(CORNERS.BOTTOM_LEFT);
            up.add(CORNERS.BOTTOM_RIGHT);
            up.add(CORNERS.BOTTOM_LEFT);
        }
        if (this.needsConnection(level, (BlockPos)mutable.m_122154_((Vec3i)origin, 0, 1, 0))) {
            for (Direction d : Direction.Plane.HORIZONTAL) {
                map.get(d).add(CORNERS.TOP_LEFT);
                map.get(d).add(CORNERS.TOP_RIGHT);
            }
        }
        if (this.needsConnection(level, (BlockPos)mutable.m_122154_((Vec3i)origin, 0, -1, 0))) {
            for (Direction d : Direction.Plane.HORIZONTAL) {
                map.get(d).add(CORNERS.BOTTOM_LEFT);
                map.get(d).add(CORNERS.BOTTOM_RIGHT);
            }
        }
    }

    public PorousHoneycombBlockModel(ResourceLocation modelLocation, ResourceLocation botLeft, ResourceLocation botRight, ResourceLocation topLeft, ResourceLocation topRight, ResourceLocation particle, ResourceLocation base) {
        this.particle = particle;
        this.modelLocation = modelLocation;
        this.botLeft = botLeft;
        this.botRight = botRight;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.base = base;
        INSTANCES.add(this);
    }

    public void init() {
        this.cache = PorousHoneycombBlockModel.buildCache(this.modelLocation, this.particle, new ResourceLocation[]{this.topLeft, this.topRight, this.botLeft, this.botRight});
        this.mainModel = PorousHoneycombBlockModel.buildBlock(this.base, this.modelLocation);
        this.particleTex = PorousHoneycombBlockModel.getTexture(this.particle);
    }

    private static Map<Direction, BakedModel[]> buildCache(ResourceLocation modelLocation, ResourceLocation particle, ResourceLocation[] cornerLocations) {
        EnumMap<Direction, BakedModel[]> map = new EnumMap<Direction, BakedModel[]>(Direction.class);
        for (Direction direction : DIRECTIONS) {
            map.put(direction, new BakedModel[4]);
        }
        for (CORNERS cORNERS : CORNERS.values()) {
            PorousHoneycombBlockModel.put(map, Direction.WEST, cORNERS, PorousHoneycombBlockModel.bakedModel(new Vector3f(-0.01f, 0.0f, 0.0f), new Vector3f(-0.01f, 16.0f, 16.0f), Direction.WEST, PorousHoneycombBlockModel.flipLR(cORNERS), modelLocation, particle, cornerLocations));
            PorousHoneycombBlockModel.put(map, Direction.EAST, cORNERS, PorousHoneycombBlockModel.bakedModel(new Vector3f(16.01f, 0.0f, 0.0f), new Vector3f(16.01f, 16.0f, 16.0f), Direction.EAST, cORNERS, modelLocation, particle, cornerLocations));
            PorousHoneycombBlockModel.put(map, Direction.NORTH, cORNERS, PorousHoneycombBlockModel.bakedModel(new Vector3f(0.0f, 0.0f, -0.01f), new Vector3f(16.0f, 16.0f, -0.01f), Direction.NORTH, cORNERS, modelLocation, particle, cornerLocations));
            PorousHoneycombBlockModel.put(map, Direction.SOUTH, cORNERS, PorousHoneycombBlockModel.bakedModel(new Vector3f(0.0f, 0.0f, 16.01f), new Vector3f(16.0f, 16.0f, 16.01f), Direction.SOUTH, PorousHoneycombBlockModel.flipLR(cORNERS), modelLocation, particle, cornerLocations));
            PorousHoneycombBlockModel.put(map, Direction.DOWN, cORNERS, PorousHoneycombBlockModel.bakedModel(new Vector3f(0.0f, -0.01f, 0.0f), new Vector3f(16.0f, -0.01f, 16.0f), Direction.DOWN, PorousHoneycombBlockModel.flipLR(cORNERS), modelLocation, particle, cornerLocations));
            PorousHoneycombBlockModel.put(map, Direction.UP, cORNERS, PorousHoneycombBlockModel.bakedModel(new Vector3f(0.0f, 16.01f, 0.0f), new Vector3f(16.0f, 16.01f, 16.0f), Direction.UP, PorousHoneycombBlockModel.flipLR(PorousHoneycombBlockModel.flipUD(cORNERS)), modelLocation, particle, cornerLocations));
        }
        return map;
    }

    private static CORNERS flipLR(CORNERS corner) {
        return switch (corner) {
            default -> throw new IncompatibleClassChangeError();
            case CORNERS.TOP_LEFT -> CORNERS.TOP_RIGHT;
            case CORNERS.TOP_RIGHT -> CORNERS.TOP_LEFT;
            case CORNERS.BOTTOM_LEFT -> CORNERS.BOTTOM_RIGHT;
            case CORNERS.BOTTOM_RIGHT -> CORNERS.BOTTOM_LEFT;
        };
    }

    private static CORNERS flipUD(CORNERS corner) {
        return switch (corner) {
            default -> throw new IncompatibleClassChangeError();
            case CORNERS.TOP_LEFT -> CORNERS.BOTTOM_LEFT;
            case CORNERS.TOP_RIGHT -> CORNERS.BOTTOM_RIGHT;
            case CORNERS.BOTTOM_LEFT -> CORNERS.TOP_LEFT;
            case CORNERS.BOTTOM_RIGHT -> CORNERS.TOP_RIGHT;
        };
    }

    private static void put(Map<Direction, BakedModel[]> map, Direction d, CORNERS corner, BakedModel model) {
        map.get((Object)d)[corner.ordinal()] = model;
    }

    private static BakedModel buildBlock(ResourceLocation textureLocation, ResourceLocation modelLocation) {
        BlockModel dummy = new BlockModel(null, new ArrayList(), new HashMap(), false, BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        TextureAtlasSprite tex = PorousHoneycombBlockModel.getTexture(textureLocation);
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction d : DIRECTIONS) {
            mapFacesIn.put(d, new BlockElementFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        }
        BlockElement part = new BlockElement(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(dummy, ItemOverrides.f_111734_, false).m_119528_(tex);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction d = (Direction)e.getKey();
            builder.m_119530_(d, PorousHoneycombBlockModel.makeBakedQuad(part, (BlockElementFace)e.getValue(), tex, d, BlockModelRotation.X0_Y0, modelLocation));
        }
        return builder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("solid")));
    }

    private static BakedModel bakedModel(Vector3f from, Vector3f to, Direction direction, CORNERS corner, ResourceLocation modelLocation, ResourceLocation particleLocation, ResourceLocation[] textures) {
        BlockElement element = PorousHoneycombBlockModel.blockElement(from, to, direction);
        BlockModel dummy = new BlockModel(null, new ArrayList(), new HashMap(), false, BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(dummy, ItemOverrides.f_111734_, false).m_119528_(PorousHoneycombBlockModel.getTexture(particleLocation));
        builder.m_119530_(direction, PorousHoneycombBlockModel.makeBakedQuad(element, (BlockElementFace)element.f_111310_.get(direction), PorousHoneycombBlockModel.getTexture(textures[corner.ordinal()]), direction, BlockModelRotation.X0_Y0, modelLocation));
        return builder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("cutout")));
    }

    private static TextureAtlasSprite getTexture(ResourceLocation id) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(BLOCK_ATLAS).apply(id);
    }

    private static BakedQuad makeBakedQuad(BlockElement BlockElement2, BlockElementFace partFace, TextureAtlasSprite atlasSprite, Direction dir, BlockModelRotation modelRotation, ResourceLocation modelResLoc) {
        return new FaceBakery().m_111600_(BlockElement2.f_111308_, BlockElement2.f_111309_, partFace, atlasSprite, dir, (ModelState)modelRotation, BlockElement2.f_111311_, true, modelResLoc);
    }

    private static BlockElement blockElement(Vector3f from, Vector3f to, Direction direction) {
        EnumMap<Direction, BlockElementFace> mapFacesIn = new EnumMap<Direction, BlockElementFace>(Direction.class);
        mapFacesIn.put(direction, new BlockElementFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        return new BlockElement(from, to, mapFacesIn, null, true);
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        Map directionsOfHoney;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.mainModel.getQuads(state, side, rand, extraData, renderType));
        if (quads.size() > 0 && side != null && extraData.has(DIRECTION_OF_HONEY_MERGERS) && (directionsOfHoney = (Map)extraData.get(DIRECTION_OF_HONEY_MERGERS)) != null) {
            for (CORNERS corners : (Set)directionsOfHoney.get(side)) {
                quads.addAll(this.cache.get(side)[corners.ordinal()].getQuads(state, side, rand, extraData, renderType));
            }
        }
        return quads;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        EnumMap<Direction, Set<CORNERS>> currentData = new EnumMap<Direction, Set<CORNERS>>(Direction.class);
        if (state != null) {
            for (Direction direction : DIRECTIONS) {
                currentData.put(direction, new HashSet());
            }
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (CHECKS check : CHECKS.VALUES) {
                check.set(cursor, pos);
                if (!this.needsConnection(level, (BlockPos)cursor)) continue;
                check.put(currentData, check);
            }
            this.checkAdjacent(level, cursor, pos, currentData);
        }
        return modelData.derive().with(DIRECTION_OF_HONEY_MERGERS, (Object)ImmutableMap.copyOf(currentData)).build();
    }

    private boolean needsConnection(BlockAndTintGetter level, BlockPos pos) {
        BlockState neighborState = level.m_8055_(pos);
        return neighborState.m_60713_((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()) || neighborState.m_60713_((Block)BzBlocks.HONEYCOMB_BROOD.get());
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return CUTOUT_CHUNK_RENDER_TYPE;
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return List.of(RenderType.m_110463_());
    }

    public TextureAtlasSprite m_6160_() {
        return this.particleTex;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        Minecraft.m_91087_().m_91304_().m_119422_(BACKING_DIRT_MODEL).applyTransform(transformType, poseStack, applyLeftHandTransform);
        return this;
    }

    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("porous_honeycomb", (IGeometryLoader)new PorousHoneycombLoader());
    }

    public static void onBakingCompleted(ModelEvent.BakingCompleted event) {
        INSTANCES.forEach(PorousHoneycombBlockModel::init);
    }

    private static enum CORNERS {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    private static enum CHECKS {
        TLX(Direction.Axis.X, CORNERS.TOP_LEFT, 0, 1, 1),
        TLY(Direction.Axis.Y, CORNERS.TOP_LEFT, 1, 0, 1),
        TLZ(Direction.Axis.Z, CORNERS.TOP_LEFT, 1, 1, 0),
        TRX(Direction.Axis.X, CORNERS.TOP_RIGHT, 0, 1, -1),
        TRY(Direction.Axis.Y, CORNERS.TOP_RIGHT, -1, 0, 1),
        TRZ(Direction.Axis.Z, CORNERS.TOP_RIGHT, -1, 1, 0),
        BLX(Direction.Axis.X, CORNERS.BOTTOM_LEFT, 0, -1, 1),
        BLY(Direction.Axis.Y, CORNERS.BOTTOM_LEFT, 1, 0, -1),
        BLZ(Direction.Axis.Z, CORNERS.BOTTOM_LEFT, 1, -1, 0),
        BRX(Direction.Axis.X, CORNERS.BOTTOM_RIGHT, 0, -1, -1),
        BRY(Direction.Axis.Y, CORNERS.BOTTOM_RIGHT, -1, 0, -1),
        BRZ(Direction.Axis.Z, CORNERS.BOTTOM_RIGHT, -1, -1, 0);

        public static final CHECKS[] VALUES;
        private final Direction.Axis axis;
        private final CORNERS corner;
        private final int dx;
        private final int dy;
        private final int dz;

        private CHECKS(Direction.Axis axis, CORNERS corner, int dx, int dy, int dz) {
            this.axis = axis;
            this.corner = corner;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
        }

        void set(BlockPos.MutableBlockPos mutable, BlockPos origin) {
            mutable.m_122154_((Vec3i)origin, this.dx, this.dy, this.dz);
        }

        void put(Map<Direction, Set<CORNERS>> map, CHECKS check) {
            for (Direction.AxisDirection axisDir : AXIS_DIRECTIONS) {
                Direction d = Direction.m_122387_((Direction.Axis)this.axis, (Direction.AxisDirection)axisDir);
                map.get(d).add(check.corner);
            }
        }

        static {
            VALUES = CHECKS.values();
        }
    }
}

