/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.HoneyCrystalShards;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CrystallineFlowerBlockEntity
extends BlockEntity {
    public static String TIER_TAG = "tier";
    public static String XP_TAG = "xp";
    public static String GUID_TAG = "guid";
    private int xpTier = 1;
    private int currentXp = 0;
    private String guid = UUID.randomUUID().toString();
    private Boolean isBreaking = false;

    protected CrystallineFlowerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public CrystallineFlowerBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)BzBlockEntities.CRYSTALLINE_FLOWER.get(), blockPos, blockState);
    }

    public int getXpTier() {
        return this.xpTier;
    }

    public void setXpTier(int xpTier) {
        this.xpTier = xpTier;
    }

    public int getCurrentXp() {
        return this.currentXp;
    }

    public void setCurrentXp(int currentXp) {
        this.currentXp = currentXp;
    }

    public boolean getIsBreaking() {
        return this.isBreaking;
    }

    public void setIsBreaking(boolean isBreaking) {
        this.isBreaking = isBreaking;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.xpTier = compoundTag.m_128451_(TIER_TAG);
        this.currentXp = Math.min(compoundTag.m_128451_(XP_TAG), this.getMaxXpForTier(this.xpTier));
        this.guid = compoundTag.m_128461_(GUID_TAG);
        if (this.guid.isEmpty()) {
            this.guid = UUID.randomUUID().toString();
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        this.saveFieldsToTag(compoundTag);
    }

    private void saveFieldsToTag(CompoundTag compoundTag) {
        compoundTag.m_128405_(TIER_TAG, this.xpTier);
        compoundTag.m_128405_(XP_TAG, this.currentXp);
        compoundTag.m_128359_(GUID_TAG, this.guid);
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)this.m_58903_(), (CompoundTag)compoundTag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.saveFieldsToTag(tag);
        return tag;
    }

    public void addXpAndTier(int xpChange) {
        this.currentXp += xpChange;
        int tierChange = 0;
        while (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp -= this.getMaxXpForTier(this.xpTier);
            ++tierChange;
            ++this.xpTier;
        }
        while (this.currentXp < 0 && !this.isMinTier()) {
            this.currentXp += this.getMaxXpForTier(this.xpTier);
            --tierChange;
            --this.xpTier;
        }
        if (this.isMaxTier()) {
            this.currentXp = 0;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier)) {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        } else if (this.currentXp < 0) {
            this.currentXp = 0;
        }
        this.m_6596_();
        this.setPillar(tierChange);
    }

    public void increaseTier(int tierIncrease) {
        int tierChange = Math.min(7 - this.xpTier, tierIncrease);
        if (!this.isMaxTier()) {
            this.xpTier += tierIncrease;
        } else {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.m_6596_();
        this.setPillar(tierChange);
    }

    public void decreaseTier(int tierDecrease) {
        int tierChange = Math.min(this.xpTier - 1, tierDecrease);
        if (!this.isMinTier()) {
            this.xpTier -= tierDecrease;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.m_6596_();
        this.setPillar(-tierChange);
    }

    public void setPillar(int tierChange) {
        if (this.f_58857_ != null && tierChange != 0) {
            int bottomHeight = CrystallineFlower.flowerHeightBelow((LevelReader)this.f_58857_, this.m_58899_());
            BlockPos operatingPos = this.m_58899_().m_6625_(bottomHeight);
            int topHeight = CrystallineFlower.flowerHeightAbove((LevelReader)this.f_58857_, operatingPos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(operatingPos);
            if (blockEntity instanceof CrystallineFlowerBlockEntity) {
                BlockEntity targetBlockEntity;
                CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
                if (bottomHeight != 0 && (targetBlockEntity = this.f_58857_.m_7702_(this.m_58899_().m_6625_(bottomHeight))) instanceof CrystallineFlowerBlockEntity) {
                    targetBlockEntity.m_142466_(crystallineFlowerBlockEntity.m_5995_());
                }
                for (int i = 0; i < topHeight + 1; ++i) {
                    BlockEntity blockEntity2 = this.f_58857_.m_7702_(operatingPos.m_6630_(i));
                    if (!(blockEntity2 instanceof CrystallineFlowerBlockEntity)) continue;
                    CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                    crystallineFlowerBlockEntity2.setIsBreaking(true);
                }
                boolean upward = tierChange > 0;
                for (int i = 0; i < (upward ? this.xpTier : topHeight + 1); ++i) {
                    boolean placePlant = upward || i < this.xpTier;
                    this.f_58857_.m_7731_(operatingPos.m_6630_(i), placePlant ? ((Block)BzBlocks.CRYSTALLINE_FLOWER.get()).m_49966_() : Blocks.f_50016_.m_49966_(), 3);
                    this.f_58857_.m_46672_(operatingPos.m_6630_(i), placePlant ? (Block)BzBlocks.CRYSTALLINE_FLOWER.get() : Blocks.f_50016_);
                    if (placePlant) {
                        BlockEntity blockEntity2 = this.f_58857_.m_7702_(operatingPos.m_6630_(i));
                        if (!(blockEntity2 instanceof CrystallineFlowerBlockEntity)) continue;
                        CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                        crystallineFlowerBlockEntity2.setGUID(crystallineFlowerBlockEntity.getGUID());
                        crystallineFlowerBlockEntity2.setIsBreaking(false);
                        continue;
                    }
                    Level blockEntity2 = this.f_58857_;
                    if (!(blockEntity2 instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)blockEntity2;
                    int itemsToDrop = 0;
                    while ((double)itemsToDrop < 2.0 + (double)i / 1.5) {
                        ItemStack stack = ((HoneyCrystalShards)((Object)BzItems.HONEY_CRYSTAL_SHARDS.get())).m_7968_();
                        stack.m_41764_(1);
                        GeneralUtils.spawnItemEntity(serverLevel, operatingPos.m_6630_(i), stack, 0.05, 0.2);
                        ++itemsToDrop;
                    }
                }
                operatingPos = operatingPos.m_6630_(upward ? this.xpTier - 1 : topHeight + tierChange);
                this.f_58857_.m_7731_(operatingPos, (BlockState)((Block)BzBlocks.CRYSTALLINE_FLOWER.get()).m_49966_().m_61124_((Property)CrystallineFlower.FLOWER, (Comparable)Boolean.valueOf(true)), 3);
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(operatingPos);
                if (blockEntity2 instanceof CrystallineFlowerBlockEntity) {
                    CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                    crystallineFlowerBlockEntity2.setGUID(crystallineFlowerBlockEntity.getGUID());
                    crystallineFlowerBlockEntity2.setIsBreaking(false);
                }
            }
        }
    }

    public boolean isMaxXP() {
        return this.currentXp == this.getMaxXpForTier(this.xpTier);
    }

    public boolean isMinXP() {
        return this.currentXp == 0;
    }

    public boolean isMaxTier() {
        return this.xpTier == 7;
    }

    public boolean isMinTier() {
        return this.xpTier == 0;
    }

    public int getMaxXpForTier(int tier) {
        return Math.max(1, 45 + tier * tier * 13 + (Integer)BzGeneralConfigs.crystallineFlowerExtraXpNeededForTiers.get());
    }

    public int getXpForNextTiers(int nextTiersToCalculate) {
        int totalXpNeeded = 0;
        for (int i = 0; i < nextTiersToCalculate; ++i) {
            if (i == 0) {
                totalXpNeeded += this.getMaxXpForTier(this.xpTier) - this.currentXp;
                continue;
            }
            if (this.xpTier + i > 7) continue;
            totalXpNeeded += this.getMaxXpForTier(this.xpTier + i);
        }
        return totalXpNeeded;
    }
}

