/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.advancements;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class RecipeDiscoveredTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("the_bumblezone", "recipe_discovered");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject jsonObject, EntityPredicate.Composite predicate, DeserializationContext deserializationContext) {
        return new Instance(predicate, RecipeDiscoveredTrigger.fromJson((JsonElement)jsonObject));
    }

    public static ResourceLocation[] fromJson(JsonElement jsonElement) {
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            JsonArray jsonarray = jsonElement.getAsJsonObject().getAsJsonArray("recipes");
            ResourceLocation[] resourceLocations = new ResourceLocation[jsonarray.size()];
            for (int i = 0; i < resourceLocations.length; ++i) {
                resourceLocations[i] = new ResourceLocation(jsonarray.get(i).getAsString());
            }
            return resourceLocations;
        }
        return new ResourceLocation[0];
    }

    public void trigger(ServerPlayer serverPlayer, ResourceLocation recipeRL) {
        super.m_66234_(serverPlayer, instance -> instance.matches(recipeRL));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final Set<ResourceLocation> resourceLocations;

        public Instance(EntityPredicate.Composite predicate, ResourceLocation[] resourceLocations) {
            super(ID, predicate);
            this.resourceLocations = new HashSet<ResourceLocation>(Arrays.asList(resourceLocations));
        }

        public boolean matches(ResourceLocation recipeRL) {
            return this.resourceLocations.contains(recipeRL);
        }

        public JsonObject m_7683_(SerializationContext serializationContext) {
            JsonObject jsonobject = super.m_7683_(serializationContext);
            Object[] recipes = new String[this.resourceLocations.size()];
            int i = 0;
            for (ResourceLocation rl : this.resourceLocations) {
                recipes[i] = rl.toString();
                ++i;
            }
            jsonobject.addProperty("recipes", Arrays.toString(recipes));
            return jsonobject;
        }
    }
}

