/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class KilledCounterTrigger
extends SimpleCriterionTrigger<Instance> {
    private final ResourceLocation id;

    public KilledCounterTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    public Instance createInstance(JsonObject jsonObject, EntityPredicate.Composite predicate, DeserializationContext deserializationContext) {
        JsonElement beeArmorJson = jsonObject.get("bee_armor_required");
        return new Instance(predicate, new ResourceLocation(jsonObject.get("target_entity").getAsString()), jsonObject.get("target_count").getAsInt(), beeArmorJson != null && beeArmorJson.getAsBoolean());
    }

    public void trigger(ServerPlayer serverPlayer, ResourceLocation currentEntity, int currentCount) {
        super.m_66234_(serverPlayer, trigger -> trigger.matches(serverPlayer, currentEntity, currentCount));
    }

    public class Instance
    extends AbstractCriterionTriggerInstance {
        private final int targetCount;
        private final ResourceLocation targetEntity;
        private final boolean beeArmorRequired;

        public Instance(EntityPredicate.Composite predicate, ResourceLocation targetEntity, int targetCount, boolean beeArmorRequired) {
            super(KilledCounterTrigger.this.id, predicate);
            this.targetCount = targetCount;
            this.targetEntity = targetEntity;
            this.beeArmorRequired = beeArmorRequired;
        }

        public boolean matches(ServerPlayer serverPlayer, ResourceLocation currentEntity, int currentCount) {
            return (!this.beeArmorRequired || StinglessBeeHelmet.isAllBeeArmorOn((Entity)serverPlayer)) && currentEntity.equals((Object)this.targetEntity) && currentCount >= this.targetCount;
        }

        public JsonObject m_7683_(SerializationContext serializationContext) {
            JsonObject jsonobject = super.m_7683_(serializationContext);
            jsonobject.addProperty("target_count", (Number)this.targetCount);
            jsonobject.addProperty("target_entity", this.targetEntity.toString());
            jsonobject.addProperty("bee_armor_required", Boolean.valueOf(this.beeArmorRequired));
            return jsonobject;
        }
    }
}

