/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import shetiphian.core.internal.teams.TeamHelper;

public class PlayerTeam {
    private final String id;
    private Component displayName;
    @Nullable
    private UUID leader;
    private final List<UUID> managers = new ArrayList<UUID>();
    private final List<UUID> members = new ArrayList<UUID>();

    public static PlayerTeam create(String id, UUID owner, Component displayName) {
        PlayerTeam team = new PlayerTeam(id, owner, displayName);
        TeamHelper.SAVEDATA.TEAMS.put(id, team);
        if (owner != null) {
            TeamHelper.PLAYER_TEAM.put(owner, team);
        }
        TeamHelper.markDirty();
        return team;
    }

    public String getId() {
        return this.id;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public List<UUID> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public boolean isManager(UUID player) {
        return this.managers.contains(player);
    }

    private PlayerTeam(String id, UUID leader, Component displayName) {
        this.id = id;
        Object object = this.displayName = displayName != null ? displayName : Component.m_237113_((String)id);
        if (leader != null) {
            this.leader = leader;
            this.managers.add(leader);
            this.members.add(leader);
        }
    }

    @Nullable
    UUID getLeader() {
        return this.leader;
    }

    public List<UUID> getManagers() {
        return ImmutableList.copyOf(this.managers);
    }

    boolean changeDisplayName(Component displayName) {
        if (!this.displayName.equals(displayName)) {
            this.displayName = displayName;
            TeamHelper.markDirty();
            return true;
        }
        return false;
    }

    void add(UUID player) {
        if (!this.members.contains(player)) {
            this.members.add(player);
            TeamHelper.PLAYER_TEAM.put(player, this);
            TeamHelper.markDirty();
        }
    }

    void leave(UUID player) {
        if (!player.equals(this.leader)) {
            this.managers.remove(player);
            this.members.remove(player);
            TeamHelper.PLAYER_TEAM.remove(player);
            TeamHelper.markDirty();
        }
    }

    void kick(UUID player) {
        if (player.equals(this.leader)) {
            this.leader = null;
        }
        this.managers.remove(player);
        this.members.remove(player);
        TeamHelper.PLAYER_TEAM.remove(player);
        TeamHelper.markDirty();
    }

    boolean promote(UUID player) {
        if (!this.managers.contains(player)) {
            this.managers.add(player);
            this.members.add(player);
            TeamHelper.markDirty();
            return true;
        }
        return false;
    }

    boolean demote(UUID player) {
        if (this.managers.contains(player)) {
            this.managers.remove(player);
            TeamHelper.markDirty();
            return true;
        }
        return false;
    }

    boolean transfer(UUID player) {
        if (!player.equals(this.leader)) {
            this.leader = player;
            this.managers.add(player);
            this.members.add(player);
            TeamHelper.PLAYER_TEAM.put(player, this);
            TeamHelper.markDirty();
            return true;
        }
        return false;
    }

    static PlayerTeam load(String teamId, CompoundTag nbt) {
        UUID leader = null;
        try {
            leader = nbt.m_128425_("leader", 11) ? nbt.m_128342_("leader") : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        MutableComponent displayName = null;
        try {
            displayName = nbt.m_128425_("display_name", 8) ? Component.Serializer.m_130701_((String)nbt.m_128461_("display_name")) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlayerTeam team = new PlayerTeam(teamId, leader, (Component)displayName);
        if (nbt.m_128425_("members", 9)) {
            nbt.m_128437_("members", 11).forEach(player -> {
                try {
                    team.members.add(NbtUtils.m_129233_((Tag)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.m_128425_("managers", 9)) {
            nbt.m_128437_("managers", 11).forEach(player -> {
                try {
                    team.managers.add(NbtUtils.m_129233_((Tag)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return team;
    }

    CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("display_name", Component.Serializer.m_130703_((Component)this.displayName));
        if (this.leader != null) {
            nbt.m_128362_("leader", this.leader);
        }
        ListTag memberNBT = new ListTag();
        this.members.forEach(player -> {
            try {
                memberNBT.add((Object)NbtUtils.m_129226_((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.m_128365_("members", (Tag)memberNBT);
        ListTag adminNBT = new ListTag();
        this.managers.forEach(player -> {
            try {
                adminNBT.add((Object)NbtUtils.m_129226_((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.m_128365_("managers", (Tag)adminNBT);
        return nbt;
    }
}

