/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import joptsimple.internal.Strings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.network.NetworkHandler;

public class PacketParticle
extends PacketBase {
    private static final PacketParticle INVALID = new PacketParticle(null, null, 0.0, 0.0, 0.0, 0.0, 0);
    private static final RandomSource random = RandomSource.m_216327_();
    private final ParticleType particleType;
    private final BlockPos sourcePos;
    private final double xCoord;
    private final double yCoord;
    private final double zCoord;
    private final double particleSpeed;
    private final int particleCount;

    public PacketParticle(ParticleType particleType, BlockPos sourcePos, double xCoord, double yCoord, double zCoord, double particleSpeed, int particleCount) {
        this.particleType = particleType;
        this.sourcePos = sourcePos;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.particleSpeed = particleSpeed;
        this.particleCount = particleCount;
    }

    public static void writeData(PacketParticle packet, FriendlyByteBuf buffer) {
        ResourceLocation particle = ForgeRegistries.PARTICLE_TYPES.getKey((Object)packet.particleType);
        if (particle == null) {
            PacketParticle.writeString(buffer, "invalid");
            return;
        }
        PacketParticle.writeString(buffer, particle.toString());
        buffer.m_130064_(packet.sourcePos);
        buffer.writeDouble(packet.xCoord);
        buffer.writeDouble(packet.yCoord);
        buffer.writeDouble(packet.zCoord);
        buffer.writeDouble(packet.particleSpeed);
        buffer.m_130130_(packet.particleCount);
    }

    public static PacketParticle readData(FriendlyByteBuf buffer) {
        String particle = PacketParticle.readString(buffer);
        if (Strings.isNullOrEmpty((String)particle) || particle.equals("invalid")) {
            return INVALID;
        }
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(PacketParticle.readString(buffer)));
        return particleType == null ? INVALID : new PacketParticle(particleType, buffer.m_130135_(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.m_130242_());
    }

    @Override
    public void handleClientSide(Player player) {
    }

    @Override
    public void handleServerSide(Player player) {
        NetworkHandler.sendToPoint(this, player.m_9236_().m_6042_(), this.sourcePos, 1024.0);
    }
}

