/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.Configuration;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.internal.teams.TeamCommand;

public class EventHandler {
    private static final Map<Block, Block> LOG_LOOKUP = new HashMap<Block, Block>();
    private final RandomSource rand = RandomSource.m_216327_();
    public static final CauldronInteraction RGB16WASH = (state, world, pos, player, hand, stack) -> {
        Item item = stack.m_41720_();
        if (RGB16StackHelper.getRGB16Index(stack) != ((IRGB16_Item)item).getStartingIndex(stack)) {
            return InteractionResult.PASS;
        }
        if (!world.m_5776_()) {
            ItemStack washedStack = stack.m_41777_();
            washedStack.m_41764_(1);
            IRGB16_Item itemRGB16 = (IRGB16_Item)item;
            short baseColor = itemRGB16.getStartingIndex(washedStack);
            if (itemRGB16.setRGB16(washedStack, baseColor)) {
                stack.m_41774_(1);
                if (!player.m_150110_().f_35937_) {
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                }
                if (stack.m_41619_()) {
                    player.m_21008_(hand, washedStack);
                } else if (!player.m_150109_().m_36054_(washedStack)) {
                    player.m_36176_(washedStack, false);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    };

    @SubscribeEvent
    public void registerCommandsEvent(RegisterCommandsEvent event) {
        TeamCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        BlockState state = event.getBlock();
        if (state != null) {
            BlockPos pos;
            Level world;
            IBonemealable bonemealable;
            Block block = state.m_60734_();
            if (((Boolean)Configuration.CORE_EDITS.bonemealRestoresBark.get()).booleanValue()) {
                if (LOG_LOOKUP.isEmpty()) {
                    UseContext context = new UseContext(event.getLevel(), null, new ItemStack((ItemLike)Items.f_42391_));
                    TagHelper.getBlocks("minecraft:logs").forEach(arg_0 -> EventHandler.lambda$onApplyBonemeal$2((UseOnContext)context, arg_0));
                }
                if (LOG_LOOKUP.containsKey(block)) {
                    BlockState unstripped = LOG_LOOKUP.get(block).m_49966_();
                    state.m_61147_().forEach(property -> this.copyProperty((Property)property, state, unstripped));
                    Function.setBlock((LevelAccessor)event.getLevel(), event.getPos(), unstripped, true);
                    event.setResult(Event.Result.ALLOW);
                    return;
                }
            }
            if (block instanceof IBonemealable && (bonemealable = (IBonemealable)state.m_60734_()).canGrow(world = event.getLevel(), pos = event.getPos(), state, world.m_5776_())) {
                if (!world.m_5776_() && bonemealable.canUseBonemeal(world, world.f_46441_, pos, state)) {
                    bonemealable.grow(world, world.f_46441_, pos, state);
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    private <T extends Comparable<T>> void copyProperty(Property<T> property, BlockState stripped, BlockState unstripped) {
        if (unstripped.m_61138_(property)) {
            unstripped.m_61124_(property, stripped.m_61143_(property));
        }
    }

    @SubscribeEvent
    public void itemCrafted(PlayerEvent.ItemCraftedEvent event) {
        IRGB16_Item rgb16Item;
        Item item;
        ItemStack result = event.getCrafting();
        if (!result.m_41619_() && (item = result.m_41720_()) instanceof IRGB16_Item && (rgb16Item = (IRGB16_Item)item).enableDyeRecipe(result) && rgb16Item.dyeUseChance(result)) {
            this.rand.m_188584_((long)RGB16StackHelper.readColorTag(result));
            int counter = 0;
            Container inv = event.getInventory();
            for (int index = 0; index < inv.m_6643_(); ++index) {
                ItemStack invStack = inv.m_8020_(index);
                if (invStack.m_41619_() || !invStack.m_41753_() || !DyeHelper.isDye(invStack) || invStack.hasCraftingRemainingItem()) continue;
                double chance = rgb16Item.getDyeUseChance(result, invStack, counter);
                ++counter;
                if (!(chance < 1.0) || chance != 0.0 && !(this.rand.m_188500_() >= chance)) continue;
                invStack.m_41769_(1);
            }
        }
    }

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        String dyeName;
        Player player = event.getEntity();
        if (player == null || event.getItemStack().m_41619_()) {
            return;
        }
        BlockState state = player.m_9236_().m_8055_(event.getPos());
        Block block = state.m_60734_();
        if (block instanceof IRGB16_Block && !Strings.isNullOrEmpty((String)(dyeName = DyeHelper.getDyeName(event.getItemStack())))) {
            Vec3 hitVec;
            HitResult result = Function.getMovingObjectPosition(player.m_9236_(), (Entity)player, true, 64.0);
            Vec3 vec3 = hitVec = result != null ? result.m_82450_() : new Vec3(0.5, 0.5, 0.5);
            if (((IRGB16_Block)block).recolorBlock(state, (LevelAccessor)player.m_9236_(), event.getPos(), player, event.getHand(), event.getFace(), hitVec, dyeName)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_() && event.getEntity() instanceof Player) {
            Configuration.sync();
        }
    }

    private static /* synthetic */ void lambda$onApplyBonemeal$2(UseOnContext context, Block unstripped) {
        try {
            Optional.ofNullable(unstripped.m_49966_().getToolModifiedState(context, ToolActions.AXE_STRIP, true)).ifPresent(result -> LOG_LOOKUP.compute(result.m_60734_(), (stripped, cached) -> {
                ResourceKey uKey;
                if (cached == null) {
                    return unstripped;
                }
                ResourceKey sKey = ForgeRegistries.BLOCKS.getResourceKey(stripped).orElse(null);
                ResourceKey cKey = ForgeRegistries.BLOCKS.getResourceKey(cached).orElse(null);
                if (sKey != null && cKey != null && !sKey.m_135782_().m_135827_().equals(cKey.m_135782_().m_135827_()) && (uKey = (ResourceKey)ForgeRegistries.BLOCKS.getResourceKey((Object)unstripped).orElse(null)) != null && sKey.m_135782_().m_135827_().equals(uKey.m_135782_().m_135827_())) {
                    return unstripped;
                }
                return cached;
            }));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

