/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import shetiphian.core.common.ColorHelper;
import shetiphian.core.common.rgb16.RGB16;

public class RGB16Helper {
    private static final Map<String, byte[]> map = new HashMap<String, byte[]>();
    private static final int[] dyeValues = new int[]{0x333333, 0xBB3333, 0x556622, 0x774422, 0x3344AA, 0x8844CC, 0x3399BB, 0xAAAAAA, 0x444444, 0xEE88AA, 0x44DD44, 0xCCBB22, 0x6688EE, 0xAA33AA, 0xDD7711, 0xFFFFFF};
    private static final RandomSource rnd = RandomSource.m_216327_();

    public static short getIndexFor(int red, int green, int blue) {
        return RGB16Helper.getIndexFor(RGB16Helper.clamp(red, green, blue));
    }

    public static short getIndexFor(String dyeName) {
        byte[] values = RGB16Helper.getDyeValues(dyeName, true);
        return RGB16Helper.getIndexFor(values[0], values[1], values[2]);
    }

    public static short getIndexFor(DyeColor color) {
        return RGB16Helper.getIndexFor(color.m_41065_());
    }

    public static short getIndexFor(int javaColor) {
        return RGB16Helper.getIndexFor(RGB16Helper.getValuesFrom(javaColor));
    }

    private static short getIndexFor(byte[] values) {
        return (short)(values[0] * 256 + values[1] * 16 + values[2]);
    }

    public static byte[] getValuesFrom(short index) {
        index = (short)Mth.m_14045_((int)index, (int)0, (int)4095);
        int vR = index / 256;
        int vG = (index - vR * 256) / 16;
        int vB = index - vR * 256 - vG * 16;
        return RGB16Helper.clamp(vR, vG, vB);
    }

    public static byte[] getBaseValuesFrom(String colorName) {
        return RGB16Helper.getDyeValues(colorName, true);
    }

    public static byte[] getAdjustValuesFrom(String colorName) {
        return RGB16Helper.getDyeValues(colorName, false);
    }

    public static byte[] getValuesFrom(int javaColor) {
        byte vR = (byte)(((javaColor & 0xFF0000) >> 16) / 17);
        byte vG = (byte)(((javaColor & 0xFF00) >> 8) / 17);
        byte vB = (byte)((javaColor & 0xFF) / 17);
        return new byte[]{vR, vG, vB};
    }

    public static byte getSimpleColor(short rgbIndex) {
        int[] rgb = RGB16Helper.javaColorToFullRGB(RGB16Helper.getColor(rgbIndex));
        double lowest = RGB16Helper.colorDistance(rgb, RGB16Helper.javaColorToFullRGB(dyeValues[0]));
        int dyeIndex = 0;
        for (int index = 1; index < dyeValues.length; ++index) {
            double current = RGB16Helper.colorDistance(rgb, RGB16Helper.javaColorToFullRGB(dyeValues[index]));
            if (!(current < lowest)) continue;
            dyeIndex = index;
            lowest = current;
        }
        return (byte)Mth.m_14045_((int)(15 - dyeIndex), (int)0, (int)15);
    }

    public static DyeColor getDyeColor(short rgbIndex) {
        return DyeColor.m_41053_((int)RGB16Helper.getSimpleColor(rgbIndex));
    }

    public static int getColor(short rgbIndex) {
        byte[] values = RGB16Helper.getValuesFrom(rgbIndex);
        return -16777216 + (values[0] * 17 << 16) + (values[1] * 17 << 8) + values[2] * 17;
    }

    public static String getTooltip(short rgbIndex) {
        byte[] values = RGB16Helper.getValuesFrom(rgbIndex);
        return "\u00a7c" + values[0] + "\u00a7a" + values[1] + "\u00a79" + values[2];
    }

    private static byte[] getDyeValues(String colorName, boolean base) {
        byte[] byArray;
        if ((colorName = colorName.toLowerCase().replaceFirst("dye", "").replaceAll(" ", "").replaceAll("_", "")).equals("lightgray")) {
            colorName = "silver";
        }
        if (map.containsKey(colorName)) {
            byte[] byArray2;
            byte[] array = map.get(colorName);
            if (base) {
                byte[] byArray3 = new byte[3];
                byArray3[0] = array[0];
                byArray3[1] = array[1];
                byArray2 = byArray3;
                byArray3[2] = array[2];
            } else {
                byte[] byArray4 = new byte[3];
                byArray4[0] = array[3];
                byArray4[1] = array[4];
                byArray2 = byArray4;
                byArray4[2] = array[5];
            }
            return byArray2;
        }
        if (base) {
            byArray = RGB16Helper.getRandomValues();
        } else {
            byte[] byArray5 = new byte[3];
            byArray5[0] = 0;
            byArray5[1] = 0;
            byArray = byArray5;
            byArray5[2] = 0;
        }
        return byArray;
    }

    protected static byte[] getRandomValues() {
        return new byte[]{(byte)rnd.m_188503_(16), (byte)rnd.m_188503_(16), (byte)rnd.m_188503_(16)};
    }

    protected static byte[] clamp(int r, int g, int b) {
        byte vR = (byte)Mth.m_14045_((int)r, (int)0, (int)15);
        byte vG = (byte)Mth.m_14045_((int)g, (int)0, (int)15);
        byte vB = (byte)Mth.m_14045_((int)b, (int)0, (int)15);
        return new byte[]{vR, vG, vB};
    }

    private static int[] javaColorToFullRGB(int javaColor) {
        int vR = javaColor >> 16 & 0xFF;
        int vG = javaColor >> 8 & 0xFF;
        int vB = javaColor & 0xFF;
        return new int[]{vR, vG, vB};
    }

    private static double colorDistance(int[] rgb, int[] dye) {
        int rmean = (rgb[0] + dye[0]) / 2;
        int r = rgb[0] - dye[0];
        int g = rgb[1] - dye[1];
        int b = rgb[2] - dye[2];
        return Math.sqrt(((512 + rmean) * r * r >> 8) + 4 * g * g + ((767 - rmean) * b * b >> 8));
    }

    public static boolean blend(RGB16 rgb16, String colorName) {
        short dyeIndex = RGB16Helper.getIndexFor(colorName);
        float[] base = ColorHelper.colorToRYB(rgb16.getColor());
        float[] mix = ColorHelper.colorToRYB(RGB16Helper.getColor(dyeIndex));
        int color = ColorHelper.rybToColor(base[0] * 0.75f + mix[0] * 0.25f, base[1] * 0.75f + mix[1] * 0.25f, base[2] * 0.75f + mix[2] * 0.25f);
        short newIndex = RGB16Helper.getIndexFor(color);
        return rgb16.setValues(newIndex);
    }

    static {
        map.put("black", new byte[]{2, 2, 2, -2, -2, -2});
        map.put("red", new byte[]{11, 3, 3, 1, 0, 0});
        map.put("green", new byte[]{5, 6, 2, 0, 1, 0});
        map.put("brown", new byte[]{7, 4, 2, 2, 1, 0});
        map.put("blue", new byte[]{1, 4, 10, 0, 0, 1});
        map.put("purple", new byte[]{8, 4, 12, 1, 0, 1});
        map.put("cyan", new byte[]{3, 9, 11, 0, 1, 1});
        map.put("silver", new byte[]{9, 9, 9, 1, 1, 1});
        map.put("gray", new byte[]{5, 5, 5, -1, -1, -1});
        map.put("pink", new byte[]{14, 8, 10, 2, 1, 1});
        map.put("lime", new byte[]{3, 13, 4, 1, 2, 1});
        map.put("yellow", new byte[]{12, 11, 2, 1, 1, 0});
        map.put("lightblue", new byte[]{6, 8, 14, 1, 1, 2});
        map.put("magenta", new byte[]{10, 3, 10, 2, 0, 1});
        map.put("orange", new byte[]{13, 7, 1, 2, 1, 0});
        map.put("white", new byte[]{15, 15, 15, 2, 2, 2});
    }
}

