/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class ItemWrench
extends TieredItem {
    private TooltipProvider provider;

    public ItemWrench(Item.Properties properties) {
        super((Tier)Tiers.IRON, properties);
    }

    public ItemWrench(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public ItemWrench tooltip(TooltipProvider provider) {
        this.provider = provider;
        return this;
    }

    public ItemWrench tooltip(String normal, String shift) {
        boolean hasShift;
        boolean hasNormal = !Strings.isNullOrEmpty((String)normal);
        boolean bl = hasShift = !Strings.isNullOrEmpty((String)shift);
        if (hasNormal || hasShift) {
            this.tooltip((stack, world, tooltip, flag, addSuper) -> {
                if (hasShift && Screen.m_96638_()) {
                    tooltip.add(Component.m_237115_((String)shift));
                } else {
                    if (hasNormal) {
                        tooltip.add(Component.m_237115_((String)normal));
                    }
                    if (hasShift) {
                        tooltip.add(Component.m_237115_((String)"info.shetiphian.holdshift"));
                    }
                }
            });
        }
        return this;
    }

    protected boolean m_220152_(CreativeModeTab group) {
        return group == CreativeModeTab.f_40756_ || super.m_220152_(group);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos;
        Player player = context.m_43723_();
        Rotation direction = player != null && player.m_6047_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        BlockState result = state.rotate((LevelAccessor)world, pos, direction);
        if (result != state) {
            if (player != null) {
                player.m_6674_(context.m_43724_());
            }
            if (result != world.m_8055_(pos)) {
                world.m_7731_(pos, result, 11);
            }
            result.m_60690_(world, pos, result.m_60734_(), pos, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        if (!stack.m_41619_() && this.provider != null) {
            this.provider.build(stack, world, tooltip, advancedTooltips, () -> super.m_7373_(stack, world, tooltip, advancedTooltips));
        }
        super.m_7373_(stack, world, tooltip, advancedTooltips);
    }

    @FunctionalInterface
    public static interface TooltipProvider {
        public void build(ItemStack var1, Level var2, List<Component> var3, TooltipFlag var4, Runnable var5);
    }
}

