/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core;

import com.mojang.logging.LogUtils;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import shetiphian.core.Configuration;
import shetiphian.core.internal.ClientEventHandler;
import shetiphian.core.internal.ProxyClient;
import shetiphian.core.internal.ProxyCommon;
import shetiphian.core.internal.Roster;
import shetiphian.core.internal.modintegration.ModIntegration;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.teams.TeamHelper;

@Mod(value="shetiphiancore")
public class ShetiPhianCore {
    public static final String MOD_ID = "shetiphiancore";
    public static ShetiPhianCore INSTANCE;
    public static Logger LOGGER;
    public static ProxyCommon PROXY;
    MinecraftServer bufferedServer = null;

    public ShetiPhianCore() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
        IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        Roster.setup(MOD_EVENT_BUS);
        PROXY = (ProxyCommon)DistExecutor.runForDist(() -> ProxyClient::new, () -> ProxyCommon::new);
        MOD_EVENT_BUS.addListener(this::preInit);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MOD_EVENT_BUS.addListener(this::clientSetup));
        MOD_EVENT_BUS.addListener(this::init);
        MOD_EVENT_BUS.addListener(this::postInit);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::worldLoaded);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::serverStarted);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configuration.SPEC_CLIENT, "shetiphiancore-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.SPEC_COMMON, "shetiphiancore.toml");
        MOD_EVENT_BUS.register(Configuration.class);
    }

    private void preInit(FMLCommonSetupEvent event) {
        PROXY.preInit();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    private void init(InterModEnqueueEvent event) {
        NetworkHandler.initialise(MOD_ID);
        PROXY.init();
        ModIntegration.INSTANCE.init();
    }

    private void postInit(InterModProcessEvent event) {
        PROXY.postInit();
        Stream imc = InterModComms.getMessages((String)MOD_ID);
        imc.forEach(PROXY::fmlInterModComms);
    }

    private void serverStarting(ServerAboutToStartEvent event) {
        this.bufferedServer = event.getServer();
    }

    private void worldLoaded(LevelEvent.Load event) {
        ServerLevel world;
        if (this.bufferedServer != null && (world = this.bufferedServer.m_129880_(Level.f_46428_)) != null) {
            TeamHelper.load(this.bufferedServer, world);
            this.bufferedServer = null;
        }
    }

    private void serverStarted(ServerStartedEvent event) {
        Configuration.sync();
    }
}

